/*
////////////////////////////////////////////////////////////////////////////////
//  XDR stream implementation.                                                //  
//  LAST EDIT: Thu Oct 20 14:44:01 1994 by ekki(@prakinf.tu-ilmenau.de)
////////////////////////////////////////////////////////////////////////////////
//  This file belongs to the YART/VR extension. Copying, distribution and     //
//  legal info is in the file COPYRGHT which should be distributed with this  //
//  file. If COPYRGHT is not available or for more info please contact:       //
//                                                                            //  
//		yart@prakinf.tu-ilmenau.de                                    //
//                                                                            //  
// (C) Copyright '94 '95 Ekkehard 'Ekki' Beier                                //
////////////////////////////////////////////////////////////////////////////////
*/

#include <stdio.h>
#include <stdlib.h>
#include "vr_xdrfd.h"

static bool_t xdrfd_getlong(XDR *, long *);
static bool_t xdrfd_putlong(XDR *, long *);
static bool_t xdrfd_getbytes(XDR *, void *, u_int);
static bool_t xdrfd_putbytes(XDR *, void *, u_int);
static u_int xdrfd_getpostn(XDR *);
static bool_t xdrfd_setpostn(XDR *, u_int);
static long *xdrfd_inline(XDR *, int);
static void xdrfd_destroy(XDR *);

static struct xdr_ops default_xdrfd_ops = {
    xdrfd_getlong,
    xdrfd_putlong,
    xdrfd_getbytes,
    xdrfd_putbytes,
    xdrfd_getpostn,
    xdrfd_setpostn,
    xdrfd_inline,
    xdrfd_destroy
};

void VR_createXDR(XDR *xdrs, int fd, enum xdr_op op) {
    xdrs->x_op = op;
    xdrs->x_ops = &default_xdrfd_ops;
    xdrs->x_public = xdrs->x_private = xdrs->x_base = NULL;
    xdrs->x_handy = fd;
}

static bool_t xdrfd_getlong(XDR *xdrs, long *lp) {
    u_char buf[4];

    if (!xdrfd_getbytes(xdrs, buf, 4)) return FALSE;
    *lp = (buf[0] << 24) | (buf[1] << 16) | (buf[2] << 8) | buf[3];
    return TRUE;
}

static bool_t xdrfd_putlong(XDR *xdrs, long *lp) {
    u_long ul;
    u_char buf[4];

    ul = (u_long)*lp;
    buf[3] = (u_char)ul;
    buf[2] = (u_char)(ul >>= 8);
    buf[1] = (u_char)(ul >>= 8);
    buf[0] = (u_char)(ul >> 8);
    if (write(xdrs->x_handy, buf, 4) != 4) return FALSE;
    return TRUE;
}

static bool_t xdrfd_getbytes(XDR *xdrs, void *buf, u_int n) {
    int r;
    while (n != 0) {
	if ((r = read(xdrs->x_handy, buf, n)) == -1 || r == 0)
	    return FALSE;
	n -= r;
	buf = (char *)buf + r;
    }
    return TRUE;
}

static bool_t xdrfd_putbytes(XDR *xdrs, void *buf, u_int n) {
    if (write(xdrs->x_handy, buf, n) != n) return FALSE;
    return TRUE;
}

static u_int xdrfd_getpostn(XDR *xdr) {
    fprintf(stderr, "xdrfd_getpostn() called\n");
    exit(1);
}

static bool_t xdrfd_setpostn(XDR *xrd, u_int uint) {
    fprintf(stderr, "xdrfd_setposn() called\n");
    exit(1);
}

static long *xdrfd_inline(XDR *xdr, int iint) {
    fprintf(stderr, "xdrfd_inline() called\n");
    exit(1);
}

static void xdrfd_destroy(XDR *xdr) {}
  
