////////////////////////////////////////////////////////////////////////////////
//  Base classes for attribute handling:                                      //
//     Attribute                                                              //
//     AttributeImplementator                                                 //
//     AttributeList                                                          //
//                                                                            //  
//  LAST EDIT: Wed Mar  8 13:56:02 1995 by ekki(@prakinf.tu-ilmenau.de)
////////////////////////////////////////////////////////////////////////////////
//  This file belongs to the YART implementation. Copying, distribution and   //
//  legal info is in the file COPYRIGHT which should be distributed with this //
//  file. If COPYRIGHT is not available or for more info please contact:      //
//                                                                            //  
//		yart@prakinf.tu-ilmenau.de                                    //
//                                                                            //  
// (C) Copyright 1994 YART team                                               //
////////////////////////////////////////////////////////////////////////////////

#ifndef __ATTRIBUTE_H__
#define __ATTRIBUTE_H__

#include "utils.h"
#include "rlist.h"

extern const char *RT_ANY;

class RT_AttrImpl {}; 
// this is the base class for attribute implementation classes
// it is still empty, but may be extended in future

extern const char *RTN_ATTRIBUTE;

class RT_Attribute: public RT_GeneralListEntry { 
    RT_String names; 
    // a list of names the attribute is related to
    int changedFlag;
    // if equal to 1 - the attribute contents has changed

  protected:
    RT_Attribute(): names( RT_ANY ) { changedFlag = 0; }
    int findStart(char **);
    // find the start position of the attribute
    // returns -1 if there isnt one
  public:
    void print(FILE *f) const {
	fprintf( f, "-%c%s %s ", tolower(getClass()[0]), &getClass()[1], get() );
	// convert "Resolution" to "-resolution"
    }
    int isA(const char *_c) const { return RTM_isA( _c, RTN_ATTRIBUTE ); }

    virtual void operator=(const RT_Attribute &) = 0;
    // copy one attribute into another
    // only attrs of the same type can be copied into another

    virtual int operator!=(const RT_Attribute &) const = 0;
    // test antivalency by value

    virtual int set(const char *) = 0;
    // set attribute value from a string representation
    // return 1 if succesful set
    virtual const char *get() const = 0;
    // get attribute value as a string representation
    
    virtual const char *getClass() const = 0;
    // the unique class name of the attribute
    
    virtual const RT_Attribute *getDefault() = 0;
    // return the default attribute of the attribute class

    void setNamesList(const char *_names) {
	// overwrite the prim class name
	names = _names;
	changed();
    }
    const char *getNamesList() const { return names.getValue(); }
    // get the name list
    
    // modify/inquire change state:
    void changed();  
    void reset() { changedFlag = 0; }
    int isChanged() const { return changedFlag; }
};

class RT_Primitive;

class RT_AttributeList: public RT_GeneralList {
    RT_Primitive *pm;
  public:
    RT_AttributeList( RT_Primitive *prim = 0) { pm = prim; }

    void clear();
    // clear all attributes from the list

    void insert(RT_Attribute *);
    // append it only if it not already exists
    // else modify the existing one

    RT_Attribute *get(const char *);
    // get the attribute with the specified attribute class
    // looking for it only in this list
    // returns attribute if succesful - 0 else

    const RT_Attribute *retraverse(const char *, const RT_Primitive *) const;
    // get the attribute of the specified attribute
    // class that matches to the overgiven primitive
    // by RETRAVERSING!! returns attribute if successful - 0 else

    void merge(const RT_AttributeList *);
    // merge an another list to this list
    // use "overwrite" priority rule

    void print(FILE *) const;
    // overload the standard list print
};

#endif
