////////////////////////////////////////////////////////////////////////////////
//  Implementation of OFF reading classes.                                    //  
//  LAST EDIT: Fri Aug  5 08:55:02 1994 by ekki(@prakinf.tu-ilmenau.de)
////////////////////////////////////////////////////////////////////////////////
//  This file belongs to the YART implementation. Copying, distribution and   //
//  legal info is in the file COPYRGHT which should be distributed with this  //
//  file. If COPYRGHT is not available or for more info please contact:       //
//                                                                            //  
//		yart@prakinf.tu-ilmenau.de                                    //
//                                                                            //  
// (C) Copyright 1994 YART team                                               //
////////////////////////////////////////////////////////////////////////////////

#include "off.h"
#include "../poly.h"

const char *RTN_OFF_POLYGON = "OFFPolygon";

RT_OFFPolygon::RT_OFFPolygon(char *a, char *_file): RT_Primitive( a ), file(_file) {
    RT_Vector polygon[30];
    // hope, that there isnt a polygon with more than 30 points

    // open the data files for reading:
    static RT_String str(40);
    str = file; str += ".geom";
    FILE *geom = fopen( str, "r" ); 
    if (!geom) {
	rt_Output->errorVar( get_name(), ": No OFF geometry file ", (char*)str, "!", 0 ); 
	return;
    }
    str = file; str += ".ipcol";
    FILE *colr = fopen( str, "r" );
    str = file; str += ".vnorm";
    FILE *norm = fopen( str, "r" );
    str = file; str += ".vcol";
    FILE *vcol = fopen( str, "r" );
    str = file; str += ".pcol";
    FILE *pcol = fopen( str, "r" );

    //skip over senseless values:
    int dum;
    if (vcol) fscanf( vcol, "%i", &dum );
    if (pcol) fscanf( pcol, "%i", &dum );

    // read the vertices:
    int nvt, npo; 
    fscanf( geom, "%i %i %i", &nvt, &npo, &dum ); 
    RT_Vector *vertices = new RT_Vector[ nvt ];

    RT_Vector *tmpvt = vertices;
    for (int i = 0; i < nvt; i++ ) {
	fscanf( geom, "%lf %lf %lf", &tmpvt->x, &tmpvt->y, &tmpvt->z );
	tmpvt++;
    }

    // read the colors:
    RT_Color *colors = 0;
    if (colr) {
	int ncl, dum;
	fscanf( colr, "%i %i", &ncl, &dum); 
	colors = new RT_Color[ ncl ];
	RT_Color *tmpc = colors;
	for (int i = 0; i < ncl; i++ ) {
	    fscanf( colr, "%lf %lf %lf", &tmpc->r, &tmpc->g, &tmpc->b );
	    tmpc++;
	}
    }
    
    // read the normals:
    RT_Vector *normals = 0;
    if (norm) {
	int nnm, dum1;
	fscanf( norm, "%i %i %i", &nnm, &dum, &dum1 ); 
	normals = new RT_Vector[ nnm ];
	RT_Vector *tmpn = normals;
	for (int i = 0; i < nnm; i++ ) {
	    fscanf( norm, "%lf %lf %lf", &tmpn->x, &tmpn->y, &tmpn->z );
	    tmpn++;
	}
    }
    
    RT_Surface s;
    // create the polygons:
    for (i = 0; i < npo; i++ ) {
	fscanf( geom, "%i", &nvt );
	// read vertices:
	for (int j = 0; j < nvt; j ++ ) {
	    int pt;
	    fscanf( geom, "%i", &pt );
	    polygon[j] = vertices[pt -1];
	}

	RT_Polygon *p = new RT_Polygon( 0, nvt, polygon );
	// read color:
	if (vcol) {
	    for ( j = 0; j < nvt; j ++ ) {
		fscanf( vcol, "%lf %lf %lf", &s.diff.r, &s.diff.g, &s.diff.b );
//		s.ambi = s.diff;
		p->vtSurface( j, s );
	    }
	}
	if (colr) {
	    int cl;
	    fscanf( colr, "%i", &cl );
	    p->diffuse( colors[cl-1] ); 
//	    p->ambient( colors[cl-1] );
	}
	if (pcol) {
	    RT_Color v;
	    fscanf( pcol, "%lf %lf %lf", &v.r, &v.g, &v.b );
	    p->diffuse( v );
//	    p->ambient( v );
	}
	// read normals:
	if (norm) { 
	    int nm;
	    fscanf( norm, "%i", &nm );
	    for (int j = 0; j < nm; j ++ ) {
		int pt;
		fscanf( norm, "%i", &pt );
		if (pt) p->vtNormal( j, normals[pt -1]);
	    }
	}
	p->father( this );
    }
    delete vertices;
    if (colors) delete colors;
    if (normals) delete normals;

    fclose( geom );
    if (colr) fclose( colr );
    if (norm) fclose( norm );
    if (vcol) fclose( vcol );
    if (pcol) fclose( pcol );
}

int RT_OFFPolygon::classCMD(ClientData cd, Tcl_Interp *ip, int argc, char *argv[]) { 
    int res;
    res = _classCMD(cd, ip, argc, argv);
    if (res == TCL_HELP) {
	Tcl_AppendResult( ip, "{", argv[0], " {String File} {Creates a polygon set from OFF files, parameters: {ARG 1 Name}, {ARG 2 File} without extension.}}", 0 );
	return TCL_OK;
    }
    if ( res  == TCL_OK ) {  
	if (argc != 3 ) {
	    Tcl_AppendResult( ip, "Bad syntax. Must be: ", argv[0], " <name> <file>. ", NULL );
	    return TCL_ERROR;
	}
	new RT_OFFPolygon( argv[1], argv[2] ); 
	RTM_classReturn;
    }
    return res; 
}

const char *RTN_OFF_QUADMESH = "OFFQuadmesh";

RT_OFFQuadmesh::RT_OFFQuadmesh(char *a, char *_file): RT_Quadmesh( a, 0, 0, 0 ), file( _file) {

    // open the data files for reading:
    RT_String str(40);
    str = file; str += ".geom";
    FILE *geom = fopen( str, "r" );
    if (!geom) {
	rt_Output->errorVar( get_name(), ": No OFF geometry file ", (char*)str, "!", 0 ); 
	return;
    }
    str = file; str += ".vnorm";
    FILE *norm = fopen( str, "r" );
     
    // read the dimensions:      
    int x_dim, y_dim, dum;         
    fscanf( geom, "%i %i", &x_dim, &y_dim); 
    if (norm) fscanf( norm, "%i %i", &dum, &dum);
    newGeometry(x_dim, y_dim);
   
    // read the vertices:
    RT_Vector tmp;
    for(int x = 0; x < x_dim; x++) 
      for(int y = 0; y < y_dim; y++) {
        fscanf( geom, "%lf %lf %lf", &tmp.x, &tmp.y, &tmp.z );
        vtPoint(x, y, tmp);
        if (norm) fscanf( norm, "%lf %lf %lf", &tmp.x, &tmp.y, &tmp.z );
        tmp = tmp.UNITIZE();
        vtNormal(x, y, tmp );
      }

    fclose( geom );
    if (norm) fclose( norm );
}

int RT_OFFQuadmesh::classCMD(ClientData cd, Tcl_Interp *ip, int argc, char *argv[]) { 
    int res;
    res = _classCMD(cd, ip, argc, argv);
    if (res == TCL_HELP) {
	Tcl_AppendResult( ip, "{", argv[0], " {String File} {Creates a quadmesh from a OFF-like file, parameters: {ARG 1 Name}, {ARG 2 File} without extension.}}", 0 );
	return TCL_OK;
    }
    if ( res  == TCL_OK ) {  
	if (argc != 3 ) {
	    Tcl_AppendResult( ip, "Bad syntax. Must be: ", argv[0], " <name> <file>. ", NULL );
	    return TCL_ERROR;
	}
	new RT_OFFQuadmesh( argv[1], argv[2] ); 
	RTM_classReturn;
    }
    return res; 
}

