////////////////////////////////////////////////////////////////////////////////
//  Implementation of One-Ray-Camera                                          //
//  LAST EDIT: Fri Aug  5 08:55:02 1994 by ekki(@prakinf.tu-ilmenau.de)
////////////////////////////////////////////////////////////////////////////////
//  This file belongs to the YART implementation. Copying, distribution and   //
//  legal info is in the file COPYRIGHT which should be distributed with this //
//  file. If COPYRIGHT is not available or for more info please contact:      //
//                                                                            //  
//		yart@prakinf.tu-ilmenau.de                                    //
//                                                                            //  
// (C) Copyright 1994 YART team                                               //
////////////////////////////////////////////////////////////////////////////////

#include "oneray.h"

const char *RTN_ONE_RAY_CAMERA = "OneRayCamera";
const char *RTSN_ORC = "ORC";

RT_Vector RT_OneRayCamera::ptV; int RT_OneRayCamera::ptF, RT_OneRayCamera::ptG;
RT_Vector RT_OneRayCamera::drV; int RT_OneRayCamera::drF, RT_OneRayCamera::drG;

RT_ParseEntry RT_OneRayCamera::table[] = {
    { "-viewpoint", RTP_VECTOR, (char*)&ptV, &ptF, "Change the {ARG 1 Startpoint} of the test ray.", RTPS_VECTOR },
    { "-get_viewpoint", RTP_NONE, 0, &ptG, "Get the starting point.", RTPS_NONE },
    { "-direction", RTP_VECTOR, (char*)&drV, &drF, "Change the {ARG 1 Direction} of the test ray. The direction vector will be unitized automatically.", RTPS_VECTOR },
    { "-get_direction", RTP_NONE, 0, &drG, "Get the direction.", RTPS_NONE },
    { 0, RTP_END, 0, 0, 0, 0 }
};

int RT_OneRayCamera::objectCMD(char *argv[]) {
    int r = RT_Camera::objectCMD( argv );
    RT_parseTable( argv, table );
    if (ptF) { viewpoint( ptV ); r++; };
    if (ptG) {
	r++;
	char tmp[60];
	RT_vector2string( get_viewpoint(), tmp );
	RT_Object::result( tmp );
    }
    if (drF) { direction( drV ); r++; };
    if (drG) {
	r++;
	char tmp[60];
	RT_vector2string( get_direction(), tmp );
	RT_Object::result( tmp );
    }
    return r;
}

void RT_OneRayCamera::rendering() {
    RT_RayCamera::rendering();
    if (!get_scene()) return;
    // update the WC box inside the primitives:
    RT_PrimitiveBoundingFunc func;
    get_scene()->doWithElements( &func);
    RT_Ray ray;
    buildRay( 0, 0, ray );
    RT_Color colr;
    trace( 0, 1, ray, colr );
    colr.print( stdout, "Color: " );
    fputc( '\n', stdout );
}

int RT_OneRayCamera::classCMD(ClientData cd, Tcl_Interp *ip, int argc, char *argv[]) { 
    int res;
    res = _classCMD(cd, ip, argc, argv);
    if (res == TCL_HELP) {
	Tcl_AppendResult( ip, "{", argv[0], " {String Vector Vector} {Creates a new one ray camera called {ARG 1 Name} for test purposes. The ray starts at {ARG 2 Point} with the specified {ARG 3 Direction}. Shortname is ", RTSN_ORC, ".}}", 0 );
	return TCL_OK;
    }
    if ( res  == TCL_OK ) {  
	if (argc != 4) {
	    Tcl_AppendResult( ip, "Bad syntax. Must be: ", argv[0], " <name> <pt[3]> <dir[3]>. ", NULL );
	    return TCL_ERROR;
	}
	RT_Vector xpt, xdir; int dum;
	if (RT_getVector( &argv[2], xpt, dum ) && RT_getVector( &argv[3], xdir, dum )) { 
	    new RT_OneRayCamera( argv[1], xpt, xdir ); 
	    RTM_classReturn;
	}
    }
    return res; 
}





