////////////////////////////////////////////////////////////////////////////////
//           A Special matrix class for storage of coefficients.              //
// LAST EDIT: Fri Aug  5 08:55:06 1994 by ekki(@prakinf.tu-ilmenau.de)
////////////////////////////////////////////////////////////////////////////////
//  This file belongs to the YART implementation. Copying, distribution and   //
//  legal info is in the file COPYRIGHT which should be distributed with this //
//  file. If COPYRIGHT is not available or for more info please contact:      //
//                                                                            //
//              yart@prakinf.tu-ilmenau.de                                    //
//                                                                            //
// (C) Copyright 1994 YART team                                               //
////////////////////////////////////////////////////////////////////////////////

#include <stdio.h>
#include <stdlib.h>
#include <math.h>  
#include <string.h>
#include <values.h>
#include "rs_lmmat.h"
#include "rs_io.h"
#include "../global.h"
#include "../error.h"

//////////////////////  THE RT_RS_lmMatrix MEMBER FUNCTIONS /////////////////////////

void RT_RS_lmMatrix::alloch(int n, float f, char atemp)
{
  nelem = n * n;
#ifdef RS_DEBUG
  if(nelem > RS_MAX_COEFF)
    rt_Output->fatalVar(get_class(), ":Illegal number of elements", NULL);
#endif
  nr = nc = n;
  temp = atemp;
  fm = new float[nelem];
  set(f);
  return;
}

void RT_RS_lmMatrix::freeh()
{
  if(fm == NULL) return;
  delete fm;
  fm = NULL;
}

RT_RS_lmMatrix::RT_RS_lmMatrix(char *filename, FILE *fp)
{
  fm = NULL;
  if(!read(filename, fp))
    freeh();
}

RT_RS_lmMatrix::RT_RS_lmMatrix(RT_RS_lmMatrix& a)
{
#ifdef RS_DEBUG
  if(a.fm == NULL)
    rt_Output->fatalVar("Reference to a deleted ", get_class(), " in copy-constructor", NULL);
#endif
  nr = a.nr;
  nc = a.nc;
  temp = a.temp;
  nelem = a.nelem;

  if(a.temp == 'y') {
    fm = a.fm;
    a.fm = NULL;
  }
  else {
    fm = new float[nelem];
#ifdef RS_USE_MEM_FUNCS
    memcpy(fm, a.fm, nelem * sizeof(float));
#else
    for(int i = 0; i < nelem; i++) fm[i] = a.fm[i];
#endif
  }
}

void RT_RS_lmMatrix::set(float f)
{
#ifdef RS_DEBUG
  if(fm == NULL)
    rt_Output->fatalVar("Reference to a deleted ", get_class(), " in set()", NULL);
#endif
  for(int i = 0; i < nelem; i++) fm[i] = f;
}

float& RT_RS_lmMatrix::operator () (int i, int j)
{
#ifdef RS_DEBUG
  if(fm == NULL)
    rt_Output->fatalVar("Reference to a deleted ", get_class(), " in operator ()", NULL);
  if(i < 0 || i >= nr)
    rt_Output->fatalVar(get_class(), ":Illegal row index in operator ()", NULL);
  if(j < -i || j > i)
    rt_Output->fatalVar(get_class(), ":Illegal column index in operator ()", NULL);
#endif
  if(j < 0) {
    int temp = i;
    i = -1 - j;
    j = temp;
  }
  return(fm[i * nc + j]);
}

boolean RT_RS_lmMatrix::read(char *filename, FILE *fp)
{
  int _nr, l, m;
  boolean aln = fp == NULL;
  boolean Ok = TRUE;
  int clmn = 0;

  if(aln) Ok = openfile(filename, fp, "rt");
  if(Ok) Ok = getline(filename, fp, RS_s);
  if(Ok) Ok = getstr(filename, fp, RS_s, RS_s1, clmn);
  if(Ok) Ok = isclass(filename, RS_s1);
  if(Ok) Ok = getint(filename, fp, _nr, RS_s, clmn);
  if(Ok) {
    freeh();
    alloch(_nr, _nr, 'n');
    for(l=0;l<nr && Ok;l++)
      for(m=-l;m<=l && Ok;m++)
        Ok = getfloat(filename, fp, (*this)(l,m), RS_s, clmn);
  }
  if(aln) fclose(fp);
  return Ok;
}

boolean RT_RS_lmMatrix::write(char *filename, FILE *fp)
{
#ifdef RS_DEBUG
  if(fm == NULL)
    rt_Output->fatalVar("Reference to a deleted ", get_class(), NULL);
#endif
  int l,m;
  int aln = fp == NULL;
  boolean Ok = TRUE;

  if(aln) Ok = openfile(filename, fp, "wt");
  if(Ok) {
    fprintf(fp,"%s %d\n", get_class(), nr);
    Ok = !ferror(fp);
  }
  for(l=0;l<nr && Ok;l++)
    for(m=-l;m<=l && Ok;m++) {
      fprintf(fp, "% .6f\n", (*this)(l,m));
      Ok = !ferror(fp);
    }
  if(!Ok) {
    rt_Output->errorVar(get_class(), ":Cannot write ", filename, NULL);
    return FALSE;
  }
  if(aln) fclose(fp);
  return TRUE;
}

void RT_RS_lmMatrix::print(FILE *f, char *n, int width, int decimalPlaces)
{
  int l, m, nperline;

  if(fm == NULL) return;
  if(n) fprintf(f, "%s\n", n);
  nperline = 79/width;
  sprintf(fmt,"%s%d.%df", "%", width, decimalPlaces);
  for(l = 0; l < nr; l++){
    for(m = -l; m <= l; m++){
      fprintf(f, fmt, (*this)(l,m));
      if(((m+l) % nperline == nperline -1) && m < l)
        fprintf(f, "\n");
    }
    fprintf(f, "\n");
  }
}
