//  LAST EDIT: Fri Feb 11 04:01:34 1994 by ekki(@prakinf.tu-ilmenau.de)
#include "fisher.h"

boolean DoNorm(vct3 *v) {
  /* Normiere eine Vektor v (Laenge 1) und gibt TRUE zurueck, wenn
     |v| < epsilon. */
  double norm;

  norm = sqrt(v->x * v->x + v->y * v->y + v->z * v->z);
  if (fabs(norm) < epsilon)
    return true;
  else {
    v->x /= norm;
    v->y /= norm;
    v->z /= norm;
    return false;
  }
}


void MulMat(double (*a)[4], double (*b)[4], double (*c)[4]) {
  /* Multiplikation zweier 4*4 Matrizen mit c:=a*b */
  mat4 m; /* (erforderlich, da a=c oder b=c sein kann) */
  int i;

  for (i = 0; i <= 3; i++) {
    m[0][i] = a[0][0] * b[0][i] + a[0][1] * b[1][i] +
              a[0][2] * b[2][i] + a[0][3] * b[3][i];
    m[1][i] = a[1][0] * b[0][i] + a[1][1] * b[1][i] +
              a[1][2] * b[2][i] + a[1][3] * b[3][i];
    m[2][i] = a[2][0] * b[0][i] + a[2][1] * b[1][i] +
              a[2][2] * b[2][i] + a[2][3] * b[3][i];
    m[3][i] = a[3][0] * b[0][i] + a[3][1] * b[1][i] +
              a[3][2] * b[2][i] + a[3][3] * b[3][i];
  }
  memcpy(c, m, sizeof(mat4));
}


void InvMat(double (*a)[4], double (*am1)[4]) {
  /* Inversion einer 4*4-Matrix a. Vorgehen : Bildung der transponierten
     Adjunkten durch Unterdeterminaten und anschliessende Division der
     Elemente durch det(a). det(a) ist Skalarprodukt aus einem Zeilenvektor
     von a dem entsprechendem Spaltenvektor von Adj(a).  */
  double det;
  long i, j, i1, i2, i3, j1, j2, j3;
  boolean negflag;

  negflag = false;
  for (i = 0; i <= 3; i++) {
    i1 = (i + 1) & 3;
    i2 = (i + 2) & 3;
    i3 = (i + 3) & 3;
    for (j = 0; j <= 3; j++) {
      j1 = (j + 1) & 3;
      j2 = (j + 2) & 3;
      j3 = (j + 3) & 3;
      am1[j][i] =
        a[i1][j1] * (a[i2][j2] * a[i3][j3] - a[i2][j3] * a[i3][j2]) +
	      a[i1][j2] * (a[i2][j3] * a[i3][j1] - a[i2][j1] * a[i3][j3]) +
	      a[i1][j3] * (a[i2][j1] * a[i3][j2] - a[i2][j2] * a[i3][j1]);
      if (negflag)
	      am1[j][i] = -am1[j][i];
      negflag = !negflag;
    }
    negflag = !negflag;
  }
  det = a[0][0] * am1[0][0];
  for (i = 1; i <= 3; i++) det += a[0][i] * am1[i][0];
  if (fabs(det) < epsilon) {
      if (det >= 0 ) det = epsilon; 
      else det = -epsilon;
  }
  for (i = 0; i <= 3; i++) {
    for (j = 0; j <= 3; j++)
      am1[i][j] /= det;
  }
}

/* Local variables for SetViewing */
struct LOC_SetViewing {
  vct3 VRP, NRP, VUP; double xMin, yMin, xMax, yMax, VPD, FPD, BPD;
};

void CalcWC_VRC(double (*WC_VRC)[4], struct LOC_SetViewing *LINK)
{
  vct3 VPN;   /* Normale zur Bildschirmebene in Richtung Betrachter */
  double scal;

  /* calculate w-axis (origin) */
  WC_VRC[0][0] = 1.0;
  WC_VRC[0][1] = LINK->VRP.x;
  WC_VRC[0][2] = LINK->VRP.y;
  WC_VRC[0][3] = LINK->VRP.z;
  /* calculate z-axis (view plane normal) */
  VPN.x = LINK->NRP.x - LINK->VRP.x;
  VPN.y = LINK->NRP.y - LINK->VRP.y;
  VPN.z = LINK->NRP.z - LINK->VRP.z;
  if (DoNorm(&VPN))
    GraphError("CalcWC_VRC: VRP und NRP sind identisch!");
  /* sonst kann ja kein Normalenvektor zur Bildschirmebene berechnet
     werden! */
  WC_VRC[3][0] = 0.0;
  WC_VRC[3][1] = VPN.x;
  WC_VRC[3][2] = VPN.y;
  WC_VRC[3][3] = VPN.z;
  /* calculate y-axis (view up vector) */
  scal = LINK->VUP.x * VPN.x + LINK->VUP.y * VPN.y + LINK->VUP.z * VPN.z;
  LINK->VUP.x -= scal * VPN.x;
  LINK->VUP.y -= scal * VPN.y;
  LINK->VUP.z -= scal * VPN.z;
  if (DoNorm(&LINK->VUP))
    GraphError("CalcWC_VRC: VUP liegt kollinear zu (VRP,NRP)");
  /* Man hat die Augen schliesslich im Gesicht und nicht AUF dem Kopf! */
  WC_VRC[2][0] = 0.0;
  WC_VRC[2][1] = LINK->VUP.x;
  WC_VRC[2][2] = LINK->VUP.y;
  WC_VRC[2][3] = LINK->VUP.z;
  /* calculate x-axis (direction to right) */
  WC_VRC[1][0] = 0.0;
  WC_VRC[1][1] = LINK->VUP.y * VPN.z - LINK->VUP.z * VPN.y;
  WC_VRC[1][2] = LINK->VUP.z * VPN.x - LINK->VUP.x * VPN.z;
  WC_VRC[1][3] = LINK->VUP.x * VPN.y - LINK->VUP.y * VPN.x;
  eyePoint.x = VPN.x * LINK->VPD + LINK->VRP.x;
      /* Berechnung Betrachterstandpunkt */
  eyePoint.y = VPN.y * LINK->VPD + LINK->VRP.y;
  eyePoint.z = VPN.z * LINK->VPD + LINK->VRP.z;
}

void CalcVRC_NPC(double (*VRC_NPC)[4], struct LOC_SetViewing *LINK)
{
  double k, l;

  /* calculate auxiliary values */
  k = (LINK->VPD - LINK->BPD) / LINK->VPD;
  l = (LINK->FPD - LINK->BPD) / (LINK->VPD - LINK->FPD);
  /* calculate w-axis (origin ): */
  VRC_NPC[0][0] = 1.0;
  VRC_NPC[0][1] = k * LINK->xMin;
  VRC_NPC[0][2] = k * LINK->yMin;
  VRC_NPC[0][3] = LINK->BPD;
  /* calculate x-axis (origin ): */
  VRC_NPC[1][0] = 0.0;
  VRC_NPC[1][1] = k * (LINK->xMax - LINK->xMin);
  VRC_NPC[1][2] = 0.0;
  VRC_NPC[1][3] = 0.0;
  /* calculate y-axis (origin ): */
  VRC_NPC[2][0] = 0.0;
  VRC_NPC[2][1] = 0.0;
  VRC_NPC[2][2] = k * (LINK->yMax - LINK->yMin);
  VRC_NPC[2][3] = 0.0;
  /* calculate z-axis (origin ): */
  VRC_NPC[3][0] = l;
  VRC_NPC[3][1] = 0.0;
  VRC_NPC[3][2] = 0.0;
  VRC_NPC[3][3] = l * LINK->VPD;
}

void SetViewing(vct3 VRP_, vct3 NRP_, vct3 VUP_,
                double xMin_, double yMin_, double xMax_, double yMax_,
                double VPD_, double FPD_,double	BPD_)
{
/*   Parameter:
       VRP: view refrence point (Ursprung der Bildschirmebene)
       NRP: normal reference point (Punkt in Betrachterrichtung)
       VUP: view up vector (Richtung "Oben" fuer den Betrachter)
       xMin,yMin: linke untere Ecke der Bildschirmebene ( = (0,0,z) im NPC)
       xMax,yMax: dto. rechts oben ( = (1,1,z) im NPC)
       VPD : view plane distance (Abstand des Betr. zur Bildschirmebene)
       FPD : front plane distance (Anfang des aktiven Bereichs vor der
                Bildschirmebene). Punkte, die im Abstand FPD vor der
                Bildschirmebene liegen, werden im NPC auf (x,y,1)
                abgebildet.
       BPD : back plane distance (Ende des aktiven Bereichs vor
                (bzw. hinter) der Bildschirmeben.  Punkte, die im Abstand
                FPD vor (bzw. hinter) der Bildschirmebene liegen,
                werden im NPC auf (x,y,0) abgebildet.
      Ergebnis ist die Matrix WC_NPC, die Punkte von der Welt in das VRC
      transformiert. */
  struct LOC_SetViewing V;
  mat4 WC_VRC, VRC_NPC, NPC_WC;

  V.VRP = VRP_;
  V.NRP = NRP_;
  V.VUP = VUP_;
  V.xMin = xMin_;
  V.yMin = yMin_;
  V.xMax = xMax_;
  V.yMax = yMax_;
  V.VPD = VPD_;
  V.FPD = FPD_;
  V.BPD = BPD_;
  CalcWC_VRC(WC_VRC, &V);
  CalcVRC_NPC(VRC_NPC, &V);
  MulMat(VRC_NPC, WC_VRC, NPC_WC);
      /* transformiert vom NPC in die Welt     */
  InvMat(NPC_WC, WC_NPC);   /* Umkehrabbildung (von Welt ins NPC)    */
  MatsChanged = true;   /* Bearbeitung der Matrizen wird noetig,  */
}  /* da sich WC_NPC geaendert hat.          */


void SetViewGlobal(vct3 VRP, vct3 NRP, vct3 VUP,
                   double xMin, double yMin, double xSize,
                   double VPD, double FPD, double BPD)
{
  /* Im Gegensatz zu SetViewing werden in SetViewingGlobal nur die
     linke untere Ecke der Bildschirmebene und die Breite des Bildschirms
     uebergeben. Die Hoehe ergibt sich aus dem Seitenverhaeltnis des
     Windows auf dem Bildschirm und dem Seitenverhaeltnis eines Pixels!

     Die Variablen werden in dieser Prozedur nur zwischengespeichert und
     dann in "DoLocalInit" beim Aufruf von SetViewing eingesetzt.
     In einem spaeteren Artickel wird die zu zeichnende Grafik aus
     mehreren Stuecken zusammengebaut (Speichermangel bei z-Buffering).
     Dann wird SetViewing fuer jeden Teil neu aufgerufen, SetViewGlobal
     aber nur einmal fuer das ganze Bild. Das gleiche gilt fuer
     SetScreen u. SetScreenGlobal. */

  _VRP = VRP;
  _NRP = NRP;
  _VUP = VUP;
  _VPD = VPD;
  _FPD = FPD;
  _BPD = BPD;
  _xMin = xMin;
  _xSize = xSize;
  _yMin = yMin;
}


void SetScreen(double lux, double luy, double rox, double roy, boolean frame)
{
  /* SetScreen berechnet die Screentransformationsmatrix, die das VRC auf
     das Bildschirm"kasten" mit den Koordinaten
     (x=lux,rox; y=luy,roy; z=0,maxint;) abbildet.
     Ist Frame TRUE, wird um diese Fenster ein Rahmen gezeichnet.  */
  /* Screentransformation */
  int zbits;
  xwinsize = rox - lux;
  xwinofs = (int)floor(lux + 0.5);
  ywinsize = roy - luy;
  ywinofs = (int)floor(luy + 0.5);
  if (frame) {
    line2d(lux, luy, rox, luy);
    line2d(lux, roy, rox, roy);
    line2d(lux, luy, lux, roy);
    line2d(rox, luy, rox, roy);
  }
  memcpy(NPC_DC, E, sizeof(mat4));   /* Matrix auf Einheitsmatrix setzen */
  NPC_DC[1][1] = xwinsize;
  NPC_DC[2][2] = ywinsize;
  zbits = sizeof(TzBuffer)*8;
  if (zbits > 30) zbits = 30;
  NPC_DC[3][3] = pow(2.0,zbits);   /* Skalierung (z wird spaeter erklaert */
  NPC_DC[0][1] = xwinofs;
  NPC_DC[0][2] = ywinofs;    /* Translation */
  MatsChanged = true;        /* Bearbeitung der Matrizen wird noetig */
}


void SetScreenGlobal(double lux, double luy, double rox, double roy)
{
  /* Erlaeuterung siehe SetViewGlobal.
     Erst an dieser Stelle ist die Hoehe der Bildschirmebene
     bekannt (_ySize). Die Funktion von _YSubU und _YSubO geben in einem
     der naechsten Kapitel die y-Grenzen des "Unterwindows" an.  */
  _lux = lux;
  _luy = luy;
  _rox = rox;
  _roy = roy;
  _YSubO = (int)floor(_roy + 0.5);
  _YSubU = (int)floor(_roy - 1 + 0.5);
  _ySize = (_xSize * rt_Aspect * (luy - roy)) / (rox - lux);
  _SpanMemSize = (int)floor((_rox + 1) * sizeof(TzBuffer) + 0.5);   /* Erlaeuterung spaeter */
}


boolean DoLocalInit(void)
{
  /* ruft SetViewing und SetScreen auf.
     DoLocalInit wir spaeter fuer jedes Teilbild aufgerufen */
  long i, MSCnt;

  for (i = _YSubO; i <= _YSubU; i++)   /* fuer alten Streifen:  */
    free(zBuffer[i]);                  /* z-Buffers freigeben  */
  if (_YSubU == _luy)                  /* ganze Bild fertig?   */
    return false;                      /* false zurueck         */
  _YSubU++;                 /* untere Streifengrenze weiter         */
  _YSubO = _YSubU;          /* neue obere Grenze ist alte untere-1  */
  MSCnt=(long)ceil((double)MeshSpace/0xF000);
  for(i=0;i<MSCnt;i++)
    MemTest[i] = (uchar *)malloc(0xF000);
  i--;        
  /* Solange Platz (MSCnt*60k Platz lassen) und noch nicht ganz unten:           */
  while ((MemTest[i] != NULL) && (_YSubU <= _luy)){
    free(MemTest[i]);
    zBuffer[_YSubU] = (TzBuffer *)malloc(_SpanMemSize);  /* Speicher fuer Z-Buffer  */
    memset(zBuffer[_YSubU],0,_SpanMemSize);   /* Auf BackPlane initial. */
    _YSubU++; /* _YSubU weiter fuer naechste Zeile      */
    MemTest[i] = (uchar *)malloc(0xF000);
  }
  for(i=0;i<MSCnt;i++)
    if(MemTest[i] != NULL) free(MemTest[i]);    
    
  _YSubU--;     /* "naechste" Zeile rueckgaengig           */
  SetViewing(_VRP, _NRP, _VUP, _xMin,
	     _yMin + _ySize * (_luy - _YSubU) / (_luy - _roy), _xMin + _xSize,
	     _yMin + _ySize * (_luy - _YSubO) / (_luy - _roy), _VPD, _FPD,
	     _BPD);
  /* Screen mit Sub-Window setzen */
  SetScreen(_lux, (double)_YSubU, _rox, (double)_YSubO, false);
  return true;     /* es muss noch weiter gezeichnet werden */
}


void MCtoDC(vct3 a, double *x, double *y)
{
  /* transformiert einen Punkt des Objektes (Modell Coordinates) direkt auf
     Bildschirmkoordinaten (Device Coordinates). Da die z-Koordinate bei
     dieser Transformation nicht mehr benoetigt wird, wird sie
     erst gar nicht berechnet */

  /* Uebergang affin->homogen , dann Objekt->Screen, dann homogen->affin */
  double w;

  w = MC_DC[0][0] + a.x * MC_DC[1][0] + a.y * MC_DC[2][0] + a.z * MC_DC[3][0];
  if (fabs(w) < epsilon)
    GraphError("MCtoDC: Punkt nicht deffiniert!");
  *x = (MC_DC[0]
	[1] + a.x * MC_DC[1][1] + a.y * MC_DC[2][1] + a.z * MC_DC[3][1]) / w;
  *y = (MC_DC[0]
	[2] + a.x * MC_DC[1][2] + a.y * MC_DC[2][2] + a.z * MC_DC[3][2]) / w;
}


void Rotate(int achse, double w)
{
  /* RotObj rotiert ein Objekt um die x (achse=1), y (achse=2) oder
     z (achse=3) Achse gegen den Uhrzeigersinn um w Grad. */
  double s, c;
  mat4 M;

  memcpy(M, E, sizeof(mat4));
  w = w * M_PI / 180.0;
  s = sin(w);
  c = cos(w);
  switch (achse) {

  case 1:
    M[2][2] = c;
    M[2][3] = s;
    M[3][2] = -s;
    M[3][3] = c;
    break;

  case 2:
    M[3][3] = c;
    M[3][1] = s;
    M[1][3] = -s;
    M[1][1] = c;
    break;

  case 3:
    M[1][1] = c;
    M[1][2] = s;
    M[2][1] = -s;
    M[2][2] = c;
    break;
  }
  MulMat(M, MC_WC, MC_WC);   /* Neue Objekt-Transformationsmatrix  */
  MatsChanged = true;   /* Bearbeiten der Matrizen wird noetig */
}


void Translate(double xv, double yv, double zv)
{
  /* TransObj verschiebt ein Objekt um den Vektor (xv,yv,zv) */
  mat4 M;

  memcpy(M, E, sizeof(mat4));
  M[0][1] = xv;
  M[0][2] = yv;
  M[0][3] = zv;
  MulMat(M, MC_WC, MC_WC);   /* Neue Objekt-Transformationsmatrix  */
  MatsChanged = true;   /* Bearbeiten der Matrizen wird noetig */
}


void Scale(double scx, double scy, double scz)
{
  /* ScaleObj skallier die Koordinaten eines Objektes in x-Richtung um scx,
     in y-Richtung um scy und in z-Richtung um scy */
  mat4 M;

  memcpy(M, E, sizeof(mat4));
  M[1][1] = scx;
  M[2][2] = scy;
  M[3][3] = scz;
  MulMat(M, MC_WC, MC_WC);   /* Neue Objekt-Transformationsmatrix  */
  MatsChanged = true;   /* Bearbeiten der Matrizen wird noetig */
}


void updateMats(void)
{
  /* Wenn sich irgendwelche Matrizen veraendert haben, so werden an
     dieser Stelle die Matrizen MC_NPC, MC_DC, WC_MC und NPC_MC
     berechnet. */
  if (!MatsChanged)
    return;
  MulMat(MC_WC, WC_NPC, MC_NPC);   /* Objekt -> NPC     */
  MulMat(MC_NPC, NPC_DC, MC_DC);   /* Objekt -> Screen  */
  MulMat(WC_NPC, NPC_DC, WC_DC);   /*-------!!!!!!------*/
  InvMat(MC_WC, WC_MC);   /* fuer Normale light*/
  InvMat(MC_NPC, NPC_MC);   /* fuer Normale flip */
  MatsChanged = false;
}


void NPCtoDC(vct4 a, double *x, double *y)
{

  /* NPCtoDC transformiert den homogenen Vektor a vom NPC auf
     Devicekoordinaten.
     Da diese Routine nur von CLine aufgerufen wird, die wiederum nur
     weisse, "flache" Linien zeichnet, wird die z-Koordinate nicht berechnet. */
  *x = NPC_DC[0][1] + a.x / a.w * NPC_DC[1][1];
  *y = NPC_DC[0][2] + a.y / a.w * NPC_DC[2][2];
}


void MCtoNPC(vct3 a, vct4 *as)
{
  /* wird fuer Modellkoordinaten aufgerufen um im NPC clippen zu koennen. */
  /* Uebergang affin->homogen , dann Transformation */
  as->w = MC_NPC[0]
	  [0] + a.x * MC_NPC[1][0] + a.y * MC_NPC[2][0] + a.z * MC_NPC[3][0];
  as->x = MC_NPC[0]
	  [1] + a.x * MC_NPC[1][1] + a.y * MC_NPC[2][1] + a.z * MC_NPC[3][1];
  as->y = MC_NPC[0]
	  [2] + a.x * MC_NPC[1][2] + a.y * MC_NPC[2][2] + a.z * MC_NPC[3][2];
  as->z = MC_NPC[0]
	  [3] + a.x * MC_NPC[1][3] + a.y * MC_NPC[2][3] + a.z * MC_NPC[3][3];
}


void MCtoWC_vertex(vertex aMC, vertex *aWC)
{
  /*__neu__*/
  /* wird fuer Punkte nach dem Clippen aufgreufen, um in der Welt das Lighting
     zu berechnen. (Erleuterungen zum Lighting im naechsten Artikel)
     Der Normalenvektor in der Welt wird in dieser Routine normiert. */
  aWC->crd.x = MC_WC[0][1] + aMC.crd.x * MC_WC[1][1] +
	       aMC.crd.y * MC_WC[2][1] + aMC.crd.z * MC_WC[3][1];
  aWC->crd.y = MC_WC[0][2] + aMC.crd.x * MC_WC[1][2] +
	       aMC.crd.y * MC_WC[2][2] + aMC.crd.z * MC_WC[3][2];
  aWC->crd.z = MC_WC[0][3] + aMC.crd.x * MC_WC[1][3] +
	       aMC.crd.y * MC_WC[2][3] + aMC.crd.z * MC_WC[3][3];
  /* Normale transformieren (Transponieren der Inversen vor Ort! */
  aWC->nrm.x = aMC.nrm.x * WC_MC[1][1] + aMC.nrm.y * WC_MC[1][2] +
	       aMC.nrm.z * WC_MC[1][3];
  aWC->nrm.y = aMC.nrm.x * WC_MC[2][1] + aMC.nrm.y * WC_MC[2][2] +
	       aMC.nrm.z * WC_MC[2][3];
  aWC->nrm.z = aMC.nrm.x * WC_MC[3][1] + aMC.nrm.y * WC_MC[3][2] +
	       aMC.nrm.z * WC_MC[3][3];
    aWC->c = aMC.c;
}


void MCtoDC3(vct3 a, SHD_VTX *ps)
{
  /* transformiert einen Punkt des Objektes (Modell Coordinates) direkt auf
     Bildschirmkoordinaten (Device Coordinates) icl. z-Koordinate. */
  /* Uebergang affin->homogen , dann Objekt->Screen, dann homogen->affin */
  double w;

  w = MC_DC[0][0] + a.x * MC_DC[1][0] + a.y * MC_DC[2][0] + a.z * MC_DC[3][0];
  if (fabs(w) < epsilon)
    GraphError("MCtoDC3: Punkt nicht definiert!");
  ps->x = (long)floor((MC_DC[0]
		       [1] + a.x * MC_DC[1][1] + a.y * MC_DC[2][1] + a.z * MC_DC[3]
			 [1]) / w + 0.5);
  ps->y = (long)floor((MC_DC[0]
		       [2] + a.x * MC_DC[1][2] + a.y * MC_DC[2][2] + a.z * MC_DC[3]
			 [2]) / w + 0.5);
  ps->z = (long)floor((MC_DC[0]
		       [3] + a.x * MC_DC[1][3] + a.y * MC_DC[2][3] + a.z * MC_DC[3]
			 [3]) / w + 0.5);
}


void PushTrafs(void)
{
  /* Rettet die aktuellen Transformationsmatrizen auf einen Stack, der
     als doppelt verkettete Liste ausgelegt ist */
  updateMats();   /* wenn die Matrizen noch nicht aktuell sind, berechnen */
  if (TrafStack == NULL) {  /* erster Eintrag?                  */
    TrafStack = (TrafStackTyp *)malloc(sizeof(TrafStackTyp));
    TrafStack->vor = NULL;   /* kein Vorgaenger!                  */
  } else {
    TrafStack->nach = (TrafStackTyp *)malloc(sizeof(TrafStackTyp));
	/* Platz fuer neuen Eintrag          */
    TrafStack->nach->vor = TrafStack;   /* so kompliziert, wie's aussieht,  */
    TrafStack = TrafStack->nach;   /* ist das gar nicht!               */
  }
  /* Die Matrizen in Record eintragen: */
  memcpy(TrafStack->MC_WC, MC_WC, sizeof(mat4));
      /* fuer Lighting                         */
  memcpy(TrafStack->MC_NPC, MC_NPC, sizeof(mat4));
      /* fuer Clipping                         */
  memcpy(TrafStack->MC_DC, MC_DC, sizeof(mat4));
      /* zum direkten Darstellen von Punkten  */
  memcpy(TrafStack->WC_NPC, WC_NPC, sizeof(mat4));
      /* fuer Routine "updateMats"             */
  memcpy(TrafStack->WC_DC, WC_DC, sizeof(mat4));
      /* fuer belichtete Punkte                */
  memcpy(TrafStack->WC_MC, WC_MC, sizeof(mat4));
      /* fuer die Normalen beim Lighting       */
  memcpy(TrafStack->NPC_MC, NPC_MC, sizeof(mat4));
      /* fuer Flipping                         */
  memcpy(TrafStack->NPC_DC, NPC_DC, sizeof(mat4));
      /* fuer wireframes (geclippt)            */
}


void PopTrafs(void)
{
  /* holt Matrizen vom Transformationsstack */
  if (TrafStack == NULL)
    GraphError("Transformationsstack leer!");
  memcpy(MC_WC, TrafStack->MC_WC, sizeof(mat4));
      /* Bedeutung siehe PushTrafs            */
  memcpy(MC_NPC, TrafStack->MC_NPC, sizeof(mat4));
  memcpy(MC_DC, TrafStack->MC_DC, sizeof(mat4));
  memcpy(WC_NPC, TrafStack->WC_NPC, sizeof(mat4));
  memcpy(WC_DC, TrafStack->WC_DC, sizeof(mat4));
  memcpy(WC_MC, TrafStack->WC_MC, sizeof(mat4));
  memcpy(NPC_MC, TrafStack->NPC_MC, sizeof(mat4));
  memcpy(NPC_DC, TrafStack->NPC_DC, sizeof(mat4));
  if (TrafStack->vor == NULL) {  /* kein Vorgaenger?                  */
    free(TrafStack);   /* alten Eintrag loeschen            */
    TrafStack = NULL;   /* Stack ist leer                   */
  } else {
    TrafStack = TrafStack->vor;   /* einen Eintrag zurueck             */
    free(TrafStack->nach);   /* alten Eintrag loeschen            */
    TrafStack->nach = NULL;
  }
  MatsChanged = false;   /* Die Matrizen waren spaetestens     */
}  /* bei PushTrafs berechnet           */


void CopyTrafs(void)
{
  PopTrafs();   /* Kein Kommentar! */
  PushTrafs();
}


boolean FlipNormal(vertex *a)
{
  /* Flippt Normale, wenn erlaubt, und gibt TRUE zurueck,
     wenn sichtbar */
  double d, z;

  /* da nicht gefordert ist, das die Objektnormalen normiert sind, die
     Berechnung von d aber Einheitsnormalen erfordert: */
//  if (DoNorm(&a->nrm))
//    GraphError("Objektnormale nicht definiert");
  d = a->crd.x * a->nrm.x + a->crd.y * a->nrm.y + a->crd.z * a->nrm.z;
  z = a->nrm.x * NPC_MC[3][1] - d * NPC_MC[3][0] + a->nrm.y * NPC_MC[3][2] +
      a->nrm.z * NPC_MC[3][3];
  if (z < 0) {  /* Normale von Rueckflaeche?       */
    if (FlipAreaEnabled) {  /* Normale umdrehen wenn erlaubt */
      a->nrm.x = -a->nrm.x;
      a->nrm.y = -a->nrm.y;
      a->nrm.z = -a->nrm.z;
      return true;
    } else
      return false;
  } else
    return true;
}


void WCtoDC(vct3 a, long *x, long *y, long *z)
{
  /* Transformation von affinen Koordinaten (Welt) auf Devicekoordinaten.
     Diese Routine wird fuer Punkte in einem Mesh nach dem Lighting aufgerufen,
     um diese in das DC abzubilden. Bis jetzt wurde dies durch die Routinen
     MCtoDC bzw. MCtoDC3 erledigt. Da aber nach dem Lighting nur noch
     die Weltkoordinaten der Objektkoordinaten bekannt sind (sie ueberschreiben
     die MC-Koordinaten), wird diese Routine noetig.

     Berechnungsschema: 1) homogene Erweiterung (1,ax,ay,az)
			2) Matrixmultiplikation
                        3) Division durch homeogene Komponente
     Achtung! Die Divicekoordinaten sind Integerwerte.                       */
  double w;   /* Homogene Komponente */

  w = WC_DC[0][0] + a.x * WC_DC[1][0] + a.y * WC_DC[2][0] + a.z * WC_DC[3][0];
  if (fabs(w) < epsilon)
    GraphError("WCtoDC: Punkt nicht definiert!");
  *x = (long)floor((WC_DC[0]
		    [1] + a.x * WC_DC[1][1] + a.y * WC_DC[2][1] + a.z * WC_DC[3]
		      [1]) / w + 0.5);
  *y = (long)floor((WC_DC[0]
		    [2] + a.x * WC_DC[1][2] + a.y * WC_DC[2][2] + a.z * WC_DC[3]
		      [2]) / w + 0.5);
  *z = (long)floor((WC_DC[0]
		    [3] + a.x * WC_DC[1][3] + a.y * WC_DC[2][3] + a.z * WC_DC[3]
		      [3]) / w + 0.5);
}


void MCtoDCi(vct3 a, long *x, long *y)
{
  /* Berechnet aus Modellkoordinaten Devicekoordinaten in Integer.
     Die z-Koordinate wird nicht beruecksichtigt. MCtoDCi wird von der
     Prozedur Mesh fuer Wireframes aufgerufen.                               */
  double xr, yr;

  MCtoDC(a, &xr, &yr);   /* Beschreibung von MCtoDC siehe dort */
  *x = (long)floor(xr + 0.5);
  *y = (long)floor(yr + 0.5);   /* auf Integer runden */
}

