#ifndef __TEXTURE_H__
#define __TEXTURE_H__

////////////////////////////////////////////////////////////////////////////////
// This is the root class of 3D textures. The code of this class and their    //
// subclasses is taken from GRIS UNI Tuebingen (Armin Krauss, Alwin Groene)   //
// used with friendly permission                                              //  
// LAST EDIT: Tue Aug 16 14:08:21 1994 by ekki(@prakinf.tu-ilmenau.de)
////////////////////////////////////////////////////////////////////////////////
//  This file belongs to the YART implementation. Copying, distribution and   //
//  legal info is in the file COPYRGHT which should be distributed with this  //
//  file. If COPYRGHT is not available or for more info please contact:       //
//                                                                            //  
//		yart@prakinf.tu-ilmenau.de                                    //
//                                                                            //  
// (C) Copyright 1994 YART team                                               //
////////////////////////////////////////////////////////////////////////////////

#include "object.h"
#include "vector.h"
#include "color.h"
#include "matrix.h"

#define RTD_MAXNOISE 10

#define RTN_TEXTURE_3D "Texture3D"

typedef enum RT_TextureSampleMode {
    RTE_NO_SAMPLE = 0, 
    RTE_REPLACE_SAMPLE, // replace surface components {ambient/
    // diffuse or specular or etc.} of the primitive
    RTE_ADD_SAMPLE, // add texture to the surface of the primitive
    RTE_MUL_SAMPLE // multiply texture with the surface of the primitive
};

typedef enum RT_TextureNormalMode {
    RTE_NO_NORMAL = 0, 
    RTE_REPLACE_NORMAL, // replace the normal of the primitive
    RTE_ADD_NORMAL // add textures normal to the normal of the primitive
};

class RT_Texture3D: public RT_Object {
    static int ***noiseTable;
    static RT_ParseEntry table[];
    //##### statics for parameter parsing:
    static int matF, matG;
    static RT_Matrix matV;
    int refcnt;
  protected:
    RT_Matrix mat;

    RT_TextureSampleMode smode;
    RT_TextureNormalMode nmode;

    double getNoise( const RT_Vector &) const;
    RT_Color getRGBNoise( const RT_Vector &, double ) const;
    double getTurbulence( const RT_Vector &, int ) const;

  public:
    static void initNoise();
    
    // generic methods:
    
    virtual RT_Color getSample( const RT_Vector & ) const {
	RT_Color c( 0, 0, 0 ); return c;
    }
    virtual RT_Vector getNormal( const RT_Vector & ) const {
	RT_Vector v( 0, 0, 0 ); return v;
    }

    RT_TextureSampleMode getSampleMode() { return smode; }
    RT_TextureNormalMode getNormalMode() { return nmode; }

    void ref() { refcnt++; }
    void deref() { refcnt--; }
    int getRef() const { return refcnt; }

    //##### the Tcl/C++ methods:
    RT_Texture3D(char *_name = 0): RT_Object(_name) { 
	refcnt = 0; 
	smode = RTE_REPLACE_SAMPLE;
	nmode = RTE_NO_NORMAL;
    }

    virtual ~RT_Texture3D() {
	if ( refcnt ) rt_Output->fatalVar( get_name(), " was deleted though it is still referenced in at least one another texture.", 0 );
	
    }

    void matrix(const RT_Matrix &m) { mat = m; }
    const RT_Matrix &get_matrix() const { return mat; }

    int isA(const char *c) const { return RTM_isA( c, RTN_TEXTURE_3D ) || RT_Object::isA( c ); }
    void print(FILE *f) const {
	printCon( f );
	fputc( '\n', f );
	if (mat.changed) { fprintf( f, "%s -matrix ", get_name() ); mat.print( f ); fprintf( f, "\n"); }
    }

    //#### the Tcl commands:
    int objectCMD(char *[]);
};

extern double frac(double d);

#endif

