/*
 *    Ygl: Run 2d-GL programs with standard X11 routines.
 *    (C) Fred Hucht 1993-95
 *    EMail: fred@thp.Uni-Duisburg.DE
 */

#include "header.h" /* for COVERSLEEP */

#ifdef YGL_PREFIX
# include <X11/Yglprefix.h>
#else
# define YGL_PRE(x) x
#endif

#include <X11/Ygl.h>

/* draw.c */

void YGL_PRE(arc_)  ( Coord*x1,  Coord*x2,  Coord*x3, Int32*x4, Int32*x5) { arc  (*x1, *x2, *x3, *x4, *x5);}
void YGL_PRE(arci_) (Icoord*x1, Icoord*x2, Icoord*x3, Int32*x4, Int32*x5) { arci (*x1, *x2, *x3, *x4, *x5);}
void YGL_PRE(arcs_) (Scoord*x1, Scoord*x2, Scoord*x3, Int32*x4, Int32*x5) { arcs (*x1, *x2, *x3, *x4, *x5);}
void YGL_PRE(arcf_) ( Coord*x1,  Coord*x2,  Coord*x3, Int32*x4, Int32*x5) { arcf (*x1, *x2, *x3, *x4, *x5);}
void YGL_PRE(arcfi_)(Icoord*x1, Icoord*x2, Icoord*x3, Int32*x4, Int32*x5) { arcfi(*x1, *x2, *x3, *x4, *x5);}
void YGL_PRE(arcfs_)(Scoord*x1, Scoord*x2, Scoord*x3, Int32*x4, Int32*x5) { arcfs(*x1, *x2, *x3, *x4, *x5);}

void YGL_PRE(circ_)  ( Coord*x1,  Coord*x2,  Coord*x3) { circ  (*x1, *x2, *x3);}
void YGL_PRE(circi_) (Icoord*x1, Icoord*x2, Icoord*x3) { circi (*x1, *x2, *x3);}
void YGL_PRE(circs_) (Scoord*x1, Scoord*x2, Scoord*x3) { circs (*x1, *x2, *x3);}
void YGL_PRE(circf_) ( Coord*x1,  Coord*x2,  Coord*x3) { circf (*x1, *x2, *x3);}
void YGL_PRE(circfi_)(Icoord*x1, Icoord*x2, Icoord*x3) { circfi(*x1, *x2, *x3);}
void YGL_PRE(circfs_)(Scoord*x1, Scoord*x2, Scoord*x3) { circfs(*x1, *x2, *x3);}

void YGL_PRE(clear_)(void) { clear();}

void YGL_PRE(cmov2_) ( Coord*x1,  Coord*x2) { cmov2 (*x1, *x2);}
void YGL_PRE(cmov2i_)(Icoord*x1, Icoord*x2) { cmov2i(*x1, *x2);}
void YGL_PRE(cmov2s_)(Scoord*x1, Scoord*x2) { cmov2s(*x1, *x2);}

void YGL_PRE(concav_) (Int32*x1) { concave(*x1);}

void YGL_PRE(draw2_) ( Coord*x1,  Coord*x2) { draw2 (*x1, *x2);}
void YGL_PRE(draw2i_)(Icoord*x1, Icoord*x2) { draw2i(*x1, *x2);}
void YGL_PRE(draw2s_)(Scoord*x1, Scoord*x2) { draw2s(*x1, *x2);}

void YGL_PRE(move2_) ( Coord*x1,  Coord*x2) { move2 (*x1, *x2);}
void YGL_PRE(move2i_)(Icoord*x1, Icoord*x2) { move2i(*x1, *x2);}
void YGL_PRE(move2s_)(Scoord*x1, Scoord*x2) { move2s(*x1, *x2);}

void YGL_PRE(pdr2_) ( Coord*x1,  Coord*x2) { pdr2 (*x1, *x2);}
void YGL_PRE(pdr2i_)(Icoord*x1, Icoord*x2) { pdr2i(*x1, *x2);}
void YGL_PRE(pdr2s_)(Scoord*x1, Scoord*x2) { pdr2s(*x1, *x2);}

void YGL_PRE(pmv2_) ( Coord*x1,  Coord*x2) { pmv2 (*x1, *x2);}
void YGL_PRE(pmv2i_)(Icoord*x1, Icoord*x2) { pmv2i(*x1, *x2);}
void YGL_PRE(pmv2s_)(Scoord*x1, Scoord*x2) { pmv2s(*x1, *x2);}

void YGL_PRE(pnt2_) ( Coord*x1,  Coord*x2) { pnt2 (*x1, *x2);}
void YGL_PRE(pnt2i_)(Icoord*x1, Icoord*x2) { pnt2i(*x1, *x2);}
void YGL_PRE(pnt2s_)(Scoord*x1, Scoord*x2) { pnt2s(*x1, *x2);}

void YGL_PRE(pclos_)(void) { pclos();}

void YGL_PRE(polf2_) (Int32*x1,  Coord x2[][2]) { polf2 (*x1, x2); }
void YGL_PRE(polf2i_)(Int32*x1, Icoord x2[][2]) { polf2i(*x1, x2); }
void YGL_PRE(polf2s_)(Int32*x1, Scoord x2[][2]) { polf2s(*x1, x2); }
void YGL_PRE(poly2_) (Int32*x1,  Coord x2[][2]) { polf2 (*x1, x2); }
void YGL_PRE(poly2i_)(Int32*x1, Icoord x2[][2]) { polf2i(*x1, x2); }
void YGL_PRE(poly2s_)(Int32*x1, Scoord x2[][2]) { polf2s(*x1, x2); }

void YGL_PRE(rect_)  ( Coord*x1,  Coord*x2,  Coord*x3,  Coord*x4) { rect  (*x1, *x2, *x3, *x4);}
void YGL_PRE(recti_) (Icoord*x1, Icoord*x2, Icoord*x3, Icoord*x4) { recti (*x1, *x2, *x3, *x4);}
void YGL_PRE(rects_) (Scoord*x1, Scoord*x2, Scoord*x3, Scoord*x4) { rects (*x1, *x2, *x3, *x4);}
void YGL_PRE(rectf_) ( Coord*x1,  Coord*x2,  Coord*x3,  Coord*x4) { rectf (*x1, *x2, *x3, *x4);}
void YGL_PRE(rectfi_)(Icoord*x1, Icoord*x2, Icoord*x3, Icoord*x4) { rectfi(*x1, *x2, *x3, *x4);}
void YGL_PRE(rectfs_)(Scoord*x1, Scoord*x2, Scoord*x3, Scoord*x4) { rectfs(*x1, *x2, *x3, *x4);}

void YGL_PRE(rdr2_) ( Coord*x1,  Coord*x2) { rdr2 (*x1, *x2);}
void YGL_PRE(rdr2i_)(Icoord*x1, Icoord*x2) { rdr2i(*x1, *x2);}
void YGL_PRE(rdr2s_)(Scoord*x1, Scoord*x2) { rdr2s(*x1, *x2);}

void YGL_PRE(rpdr2_) ( Coord*x1,  Coord*x2) { rpdr2 (*x1, *x2);}
void YGL_PRE(rpdr2i_)(Icoord*x1, Icoord*x2) { rpdr2i(*x1, *x2);}
void YGL_PRE(rpdr2s_)(Scoord*x1, Scoord*x2) { rpdr2s(*x1, *x2);}

void YGL_PRE(rmv2_) ( Coord*x1,  Coord*x2) { rmv2 (*x1, *x2);}
void YGL_PRE(rmv2i_)(Icoord*x1, Icoord*x2) { rmv2i(*x1, *x2);}
void YGL_PRE(rmv2s_)(Scoord*x1, Scoord*x2) { rmv2s(*x1, *x2);}

void YGL_PRE(sbox_)  ( Coord*x1,  Coord*x2,  Coord*x3,  Coord*x4) { sbox  (*x1, *x2, *x3, *x4);}
void YGL_PRE(sboxi_) (Icoord*x1, Icoord*x2, Icoord*x3, Icoord*x4) { sboxi (*x1, *x2, *x3, *x4);}
void YGL_PRE(sboxs_) (Scoord*x1, Scoord*x2, Scoord*x3, Scoord*x4) { sboxs (*x1, *x2, *x3, *x4);}
void YGL_PRE(sboxf_) ( Coord*x1,  Coord*x2,  Coord*x3,  Coord*x4) { sboxf (*x1, *x2, *x3, *x4);}
void YGL_PRE(sboxfi_)(Icoord*x1, Icoord*x2, Icoord*x3, Icoord*x4) { sboxfi(*x1, *x2, *x3, *x4);}
void YGL_PRE(sboxfs_)(Scoord*x1, Scoord*x2, Scoord*x3, Scoord*x4) { sboxfs(*x1, *x2, *x3, *x4);}

/* color.c */

void YGL_PRE(c3s_)(Int16 x1[3]) { c3s(x1);}
void YGL_PRE(c3i_)(Int32 x1[3]) { c3i(x1);}
void YGL_PRE(c3f_)(float x1[3]) { c3f(x1);}

void YGL_PRE(cmode_)(void) { cmode();}
void YGL_PRE(color_)(Int32*x1) { color(*x1);}
void YGL_PRE(cpack_)(Uint32*x1) { cpack(*x1);}

void YGL_PRE(getmco_)    (Int32*x1,           Int16*x2, Int16*x3, Int16*x4) { getmcolor (*x1,      x2, x3, x4); }
void YGL_PRE(getmcolors_)(Int32*x1, Int32*x2, Int16*x3, Int16*x4, Int16*x5) { getmcolors(*x1, *x2, x3, x4, x5); } /* > 6 */

void YGL_PRE(grgbco_)(Int16*x1, Int16*x2, Int16*x3) { gRGBcolor( x1,  x2,  x3);}
void YGL_PRE(mapcol_)(Int32*x1, Int16*x2, Int16*x3, Int16*x4) { mapcolor(*x1, *x2, *x3, *x4);}
void YGL_PRE(readso_)(Int32*x1) { readsource(*x1);}

void YGL_PRE(rgbcol_)(Int16*x1, Int16*x2, Int16*x3) { RGBcolor(*x1, *x2, *x3);}
void YGL_PRE(rgbmod_)(void) { RGBmode();}

Int32 YGL_PRE(crectr_)( Int32*x1, Int32*x2, Int32*x3, Int32*x4, Uint8*x5) { return(crectread (*x1,*x2,*x3,*x4,x5)); }
Int32 YGL_PRE(rectre_)( Int32*x1, Int32*x2, Int32*x3, Int32*x4, Int16*x5) { return( rectread (*x1,*x2,*x3,*x4,x5)); }
Int32 YGL_PRE(lrectr_)( Int32*x1, Int32*x2, Int32*x3, Int32*x4, Int32*x5) { return(lrectread (*x1,*x2,*x3,*x4,x5)); }
void  YGL_PRE(crectw_)( Int32*x1, Int32*x2, Int32*x3, Int32*x4, Uint8*x5) { crectwrite(*x1,*x2,*x3,*x4,x5); }
void  YGL_PRE(rectwr_)( Int32*x1, Int32*x2, Int32*x3, Int32*x4, Int16*x5) {  rectwrite(*x1,*x2,*x3,*x4,x5); }
void  YGL_PRE(lrectw_)( Int32*x1, Int32*x2, Int32*x3, Int32*x4, Int32*x5) { lrectwrite(*x1,*x2,*x3,*x4,x5); }
void  YGL_PRE(rectco_)( Int32*x1, Int32*x2, Int32*x3, Int32*x4, Int32*x5, Int32*x6) { rectcopy(*x1,*x2,*x3,*x4,*x5,*x6); }

/* font.c */

void  YGL_PRE(charst_)(Char8*x1, Int32*len) { charstr(x1);}
void  YGL_PRE(loadxf_) (Int32*x1, Char8*x2, Int32*len) { loadXfont(*x1, x2); }
Int32 YGL_PRE(strwid_)(Char8*x1, Int32*len) { return(strwidth(x1));}
void  YGL_PRE(font_)(Int16*x1) { font(*x1);}
Int32 YGL_PRE(getfon_)(void) { return(getfont());}
void  YGL_PRE(getfontencoding_)(Char8*x1, Int32*len) { getfontencoding(x1);} /* > 6 */

/* misc.c */

void YGL_PRE(single_)(void) { singlebuffer();}
void YGL_PRE(doublebuffer_)(void) { doublebuffer();} /* > 6 */
void YGL_PRE(swapbu_)(void) { swapbuffers();}
void YGL_PRE(backbu_)(Int32*x1) { backbuffer (*x1);}
void YGL_PRE(frontb_)(Int32*x1) { frontbuffer(*x1);}

Int32 YGL_PRE(getbut_)(Device*x1) { return(getbutton(*x1));}
Int32 YGL_PRE(getcol_)(void) { return(getcolor());}
void  YGL_PRE(getcpo_)(Int16*x1, Int16*x2) { getcpos( x1,  x2);}
Int32 YGL_PRE(getdes_)(void) { return(getdescender());}
Int32 YGL_PRE(getdis_)(void) { return(getdisplaymode());}
Int32 YGL_PRE(getgde_)(Int32*x1) { return(getgdesc(*x1));}
Int32 YGL_PRE(gethei_)(void) { return(getheight());}
Int32 YGL_PRE(getlwi_)(void) { return(getlwidth());}
void  YGL_PRE(getori_)(Int32*x1, Int32*x2) { getorigin( x1,  x2);}
Int32 YGL_PRE(getpla_)(void) { return(getplanes());}
void  YGL_PRE(getsiz_)(Int32*x1, Int32*x2) { getsize( x1,  x2);}
Int32 YGL_PRE(getval_)(Device*x1) { return(getvaluator(*x1));}
void  YGL_PRE(ringbe_)(void) { ringbell();}
void  YGL_PRE(setbel_)(Char8*x1, Int32*len) { setbell(*x1);}

Int32 YGL_PRE(getxdpy_)(void) { return((Int32)getXdpy()); } /* > 6 */
Int32 YGL_PRE(getxwid_)(void) { return((Int32)getXwid()); } /* > 6 */
Int32 YGL_PRE(getxdid_)(void) { return((Int32)getXdid()); } /* > 6 */
Int32 YGL_PRE(getxgc_) (void) { return((Int32)getXgc ()); }

/* ygl.c */
void  YGL_PRE(foregr_)(void) { }
void  YGL_PRE(gconfi_)(void) { gconfig();}
void  YGL_PRE(gexit_)(void) { gexit();}
void  YGL_PRE(ginit_)(void) { ginit();}
Int32 YGL_PRE(gversi_)(Char8 x1[12], Int32*len) { return(gversion(x1));}
void  YGL_PRE(keepas_)(Int32*x1, Int32*x2) { keepaspect(*x1, *x2);}
void  YGL_PRE(linewi_)(Int16*x1) { linewidth(*x1);}
void  YGL_PRE(maxsiz_)(Int32*x1, Int32*x2) { maxsize(*x1, *x2);}
void  YGL_PRE(minsiz_)(Int32*x1, Int32*x2) { minsize(*x1, *x2);}
void  YGL_PRE(noport_)(void) { noport();}
void  YGL_PRE(ortho2_)(Coord*x1, Coord*x2, Coord*x3, Coord*x4) { ortho2(*x1, *x2, *x3, *x4);}
void  YGL_PRE(prefpo_)(Int32*x1, Int32*x2, Int32*x3, Int32*x4) { prefposition(*x1, *x2, *x3, *x4);}
void  YGL_PRE(prefsi_)(Int32*x1, Int32*x2) { prefsize(*x1, *x2);}
void  YGL_PRE(reshap_)(void) { reshapeviewport();}
void  YGL_PRE(stepun_)(Int32*x1, Int32*x2) { stepunit(*x1, *x2);}
void  YGL_PRE(wincon_)(void) { winconstraints();}
void  YGL_PRE(winclo_)(Int32*x1) { winclose(*x1);}
Int32 YGL_PRE(winget_)(void) { return(winget());}
Int32 YGL_PRE(winope_)(Char8*x1, Int32*len) { return(winopen(x1));}
Int32 YGL_PRE(swinop_)(Int32*x1) { return(swinopen(*x1));}
void  YGL_PRE(winset_)(Int32*x1) { winset(*x1);}
void  YGL_PRE(wintit_)(Char8*x1, Int32*len) { wintitle(x1);}
void  YGL_PRE(winmov_)(Int32*x1, Int32*x2) { winmove(*x1, *x2);}
void  YGL_PRE(winpos_)(Int32*x1, Int32*x2, Int32*x3, Int32*x4) { winposition(*x1, *x2, *x3, *x4);}
void  YGL_PRE(winpop_)(void) { winpop();}
void  YGL_PRE(winpus_)(void) { winpush();}
Int32 YGL_PRE(winx_)(Display *dpy, Window *win) { return(winX(dpy, *win));}

/* queue.c */

void  YGL_PRE(qdevic_)(Device*x1) { qdevice(*x1);}
void  YGL_PRE(qenter_)(Int16*x1, Int16*x2) { qenter(*x1, *x2);}
Int32 YGL_PRE(qread_)(Int16*x1) { return(qread(x1));}
void  YGL_PRE(qreset_)(void) { qreset();}
Int32 YGL_PRE(qtest_)(void) { return(qtest());}
void  YGL_PRE(tie_)(Device*x1, Device*x2, Device*x3) { tie(*x1, *x2, *x3);}
void  YGL_PRE(unqdev_)(Device*x1) { unqdevice(*x1);}

/* menu.c */

Int32 YGL_PRE(newpup_)(void    ) { return(newpup());}
void  YGL_PRE(freepu_)(Int32*x1) { freepup(*x1);}
void  YGL_PRE(addtop_)(Int32*x1, Char8*x2, Int32*len, Int32*x3) { addtopup(*x1, x2, *x3);}
void  YGL_PRE(setpup_)(Int32*x1, Int32*x2, Int32*x3) { setpup(*x1, *x2, *x3);}

/* Add-ons */

void YGL_PRE(arcx_)  ( Coord*x1,  Coord*x2,  Coord*x3,  Coord*x4, Int32*x5, Int32*x6) { arcx  (*x1,*x2,*x3,*x4,*x5,*x6); }
void YGL_PRE(arcxi_) (Icoord*x1, Icoord*x2, Icoord*x3, Icoord*x4, Int32*x5, Int32*x6) { arcxi (*x1,*x2,*x3,*x4,*x5,*x6); }
void YGL_PRE(arcxs_) (Scoord*x1, Scoord*x2, Scoord*x3, Scoord*x4, Int32*x5, Int32*x6) { arcxs (*x1,*x2,*x3,*x4,*x5,*x6); }
void YGL_PRE(arcxf_) ( Coord*x1,  Coord*x2,  Coord*x3,  Coord*x4, Int32*x5, Int32*x6) { arcxf (*x1,*x2,*x3,*x4,*x5,*x6); }
void YGL_PRE(arcxfi_)(Icoord*x1, Icoord*x2, Icoord*x3, Icoord*x4, Int32*x5, Int32*x6) { arcxfi(*x1,*x2,*x3,*x4,*x5,*x6); }
void YGL_PRE(arcxfs_)(Scoord*x1, Scoord*x2, Scoord*x3, Scoord*x4, Int32*x5, Int32*x6) { arcxfs(*x1,*x2,*x3,*x4,*x5,*x6); }

void YGL_PRE(gflush_)(void) { gflush(); }

#ifdef COVERSLEEP
void YGL_PRE(usleep_)(Ulong*x1) {usleep(*x1);}
void YGL_PRE(sleep_) (Uint*x1)  { sleep(*x1);}
#endif

int  YGL_PRE(gl2ppm_) (const char*x1, Int32*len) { return(gl2ppm(x1)); }
