### Copyright (C) 1995 Jesper K. Pedersen
### This program is free software; you can redistribute it and/or modify
### it under the terms of the GNU General Public License as published by
### the Free Software Foundation; either version 2 of the License, or
### (at your option) any later version.
###
### This program is distributed in the hope that it will be useful,
### but WITHOUT ANY WARRANTY; without even the implied warranty of
### MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
### GNU General Public License for more details.
###
### You should have received a copy of the GNU General Public License
### along with this program; if not, write to the Free Software
### Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.


############################################################
#   funktion to insert information about the actual info
#   into the info list.
############################################################
proc print {args} {
    global answers editInfo fileHandles setup
    if {[string match [lindex $args 0]* "-file"]} {
	set handler [lindex $args 1]
	set args [lrange $args 2 end]
	if {![info exists fileHandles($handler)]} {
	    error "Wrong handler: \"$handler\", should be one of [array names fileHandles]"
	}
    } else {
	set handler [lindex [lindex $setup(dotfile) 0] 0]
    }
    append answers($handler) [join $args] "\n"
}

############################################################
#                    set the description
############################################################
proc Desc {args} {
  global editInfo desc
  set function $editInfo(name)
  set desc($function) [join $args]
}

############################################################
#               set the short description
############################################################
proc ShortDesc {args} {
  global shortDesc setup editInfo
  set function $editInfo(name)
  
  set shortDesc($function) "[join $args]"
}

############################################################
#             function to create save functions
############################################################
proc Save {funk} {
  global ok editInfo
  set function $editInfo(name)
  set ok($function) $funk
}

############################################################
#      create function to be called whenever changes
#      are made to the scheme
############################################################
proc Change {funk} {
  global editInfo changeFunc
  set function $editInfo(name)
  set changeFunc($function)  $funk
}
############################################################
#  create function to be called at startup the first time
############################################################
proc Init {funk} {
  global initFunc editInfo
  set function $editInfo(name)
  set initFunc($function) $funk
}
############################################################
#      create function to be called whenever changes
#      are made to the scheme
############################################################
proc PageEnd {funk} {
  global editInfo pageEnd
  set function $editInfo(name)
  set pageEnd($function) $funk
}
############################################################
# This function activates the change function which it
# read in changeFunc($function)
############################################################
proc setChangeFunc {} {
  global editInfo changeFunc
  set function $editInfo(name)
  if {$changeFunc($function) == ""} {
    proc makeChange {name prefix {menuCreate 0}} "global changed; if {!\$menuCreate} {set changed 1}"
  } else {
    proc makeChange {name prefix {menuCreate 0}} "global changed changeElm;set changeElm \$name;UpdateActive \$name \$prefix;if {!\$menuCreate} {set changed 1}; uplevel \#0 \{$changeFunc($function)\}"
  }
}

############################################################
#        Just an alias for source...
#        used when importing template files
############################################################
proc import {file} {
  global argv
  source [lindex $argv 1]/$file
}

############################################################
#                        Edit WINDOW
############################################################
proc makeEdit {} {
  global module
  toplevel .edit
  pack [frame .edit.name]
  pack [frame .edit.save -bd 2 -relief ridge] -side bottom -fill x -expand yes 
  pack [frame .edit.description] -side bottom

  label .edit.name.1 -text "name: "
  label .edit.name.2 
  pack .edit.name.1 .edit.name.2 -side left
  
  message .edit.description.desc -textvariable editInfo(desc) -aspect 200
  pack .edit.description.desc

  wm withdraw .edit
  wm geometry .edit +300+0
  wm deiconify .edit
  wm title .edit "$module(name) module"
  bind .edit <Control-s> generate
  bind .edit <Meta-s> {set saveInfo($editInfo(name)) [expr ($saveInfo($editInfo(name))+1) %% 2]}
  bind .edit.description.desc <3> "set editInfo(desc) \$desc(\$editInfo(name))"
}

############################################################
#   This function reset a page to it's default values
############################################################
proc resetToDefult {} {
  global editInfo loaded scrollValue fillList children

  set function $editInfo(name)
  if {$function == ""} {
    error "You have to select a page befor you can run this command."
  }
  destroy .edit
  uplevel \#0 "eval unset \[info vars ${function}_*\]"
  set loaded($function) 0
  if {[info exists scrollValue]} {
    foreach elm [array names scrollValue] {
      if {[string match ${function}_* $elm]} {
	unset scrollValue($elm)
      }
    }
  }
  if {[info exists fillList]} {
    foreach elm [array names fillList] {
      if {[string match ${function}_* $elm]} {
	unset fillList($elm)
      }
    }
  }
  unlink top
  catch {unset activeNivau}

  foreach child [array names children] {
    if {[string match ${function}* $child]} {
      unset children($child)
    }
  }

  loadMenu $function
}

############################################################
#               Quit
############################################################
proc quit {} {
  global changed
  if {$changed} {
    set answer [tk_dialog .dialog "Unsaved Information" \
		    "There's information, which haven't been exported what do you want to do" questhead 1 Quit Export]
    if {$answer == 1} exportFile
  }
  exit
}
