/*
   Name:     otools.h
   AUTHOR:   Ole Gunnar Westgaard <olew@har.ifi.uio.no>
   DATE:     Jun  2 1995
             
*/
#ifndef OTOOLS
#define OTOOLS

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xos.h>
#include <X11/Xatom.h>
#include <X11/keysym.h>
#include <stdio.h>
#include <math.h>
#include <stdlib.h>
#include <iostream.h>

#define uint  unsigned int
#define uchar unsigned char

#define ICON  "obitmap"

#define NONE            0x00                      // Different kinds of borders
#define IN              0x01
#define OUT             0x02
#define SINGLE          0x03
#define DOUBLE          0x04
#define HEXAGON         0x05
#define SHADOW          0x06

#define CLICK           0x00                      // Figlet CLASS Button - type
#define HOLD            0x01

#define DIAMOND         0x00
#define FLIP            0x01

#define X               0x00
#define Y               0x01

#define SLIDER          0x00
#define FADER           0x01
#define FANCY           0x02
#define BAR             0x03

//=============================================================================
class Color {
public:
  unsigned long bd,sd,bg,hl,fg,dark,light;              // Values of this class
  Color();                      // Default constructor, leaves all colors black
  Color(Color *);                       // Copy another Color class constructor
  Color(char*,char*,char*,char*,char*,char*,char*);    // Construct with colors
  void Change(char*,char*,char*,char*,char*,char*,char*); // Change Color class
  void Skrive(void );                         // Print the values of this class
};

//=============================================================================
class Figlet {
public:
  Color *color;                                     // Pointer to a Color class
  int flag;
  unsigned int xa,ya,xb,yb;           // Size of figlet, frame outside this box
  unsigned char frame;                       // What does the frame look like ?
  char *message;                              // Text that follows every figlet
  void (*callback) (void *,int ,int );              // Callback defined HERE !!
  Figlet() {};                    // Default constructor of figlet, do nothing!
  Figlet(uint,uint,uint,uint,uchar,Color*,int ,char*);     // Initialize figlet
  virtual void DrawFrame(void );           // Ok, draw this figlet's frame then
  virtual void Draw(void );                       // Draw what is inside figlet
  virtual void Press(int ,int ) {};
  virtual int  Motion(int , int ) {};
  virtual void Release(int ,int ) {};
  virtual void Show(char*);
  virtual char *ShowShort(void );
};

class Button:public Figlet {
public:
  unsigned char type,state;
  Button(uint,uint,uint,uint,uchar,Color*,int ,char*,uchar,uchar,void (*cb)(void*,int ,int ));
  virtual void Draw(void );
  virtual void Press(int ,int );
  virtual int  Motion(int ,int );
  virtual void Release(int ,int );
};

class Switch:public Figlet {
public:
  unsigned char state,width,type;
  Switch(uint,uint,uint,uint,uchar,Color*,int ,char*,uchar,uchar,uchar,void (*cb)(void*,int ,int ));
  virtual void Draw(void );
  virtual void Press(int ,int );
  virtual int  Motion(int , int );
  virtual void Release(int ,int );
};

class Slider:public Figlet {
public:
  unsigned char state,width,type;
  float value;
  Slider(uint,uint,uint,uint,uchar,Color*,int ,char*,uchar,uchar,uchar,void (*cb)(void*,int ,int ),float );
  virtual void Draw(void );
  virtual void Press(int ,int );
  virtual int  Motion(int , int );
};

//=============================================================================
class Chain {
public:
  Figlet *fig;                                        // Pointer to this figlet
  Chain *next;                                    // Next element with a figlet
  Chain();                                  // Default constructor, empty chain
  Chain(Figlet*);                               // Construct with first element
  Chain(Chain*);                                   // Construct copy of a chain
  int Size();                                          // Returns size of chain
  void Add(Figlet *);                             // Add a figlet to this chain
  void Add(Chain *);                               // Add a chain to this chain
  void Draw(void );               // Draw indiscrimenently all figlets in chain
  void IntelligentDraw(int ,int ,int ,int );              // Draw exposed areas
  void Stack(int ,int ,int ,int ,int ,int ,int ,int );      // Stack this chain
  void Show(char*);                             // Show information about chain
  void Remove(char*);             // Remove all references to figlets with name
};

#endif /* OTOOLS */
