#ifndef	  __MEMPOOL_H__
#include <sys_mempool.h>
#endif

#ifndef	NEWS_HASH_SIZE
#include <news_setup.h>
#endif


typedef	struct	_newsgrp
{
	struct	_newsgrp	*ng_link;
	
	char	*ng_path;				/*	path-name	*/
	char	*ng_name;				/*	proper name	*/
	
	time_t	ng_created;
	time_t	ng_modified;
	long	ng_first;
	long	ng_last;
	BOOL	ng_readonly;
	
	/*	.newsrc stuff	*/
	
	BOOL	ng_subscribe;			/* subscribed	*/
	BOOL	ng_recent;				/* recent flag  */
	long	ng_lastread;			/* last read	*/
	long	ng_marker;
}	NEWSGRP;

typedef	struct
{
	MEMPOOL	*ngc_pool;
	BOOL	ngc_loaded;					/* did we load .newsrc? */
	NEWSGRP	*ngc_hash[NEWS_HASH_SIZE];	/* quick hash index		*/
	int		ngc_count;					/* total count			*/
	int		ngc_subscribed;				/* subscription count	*/
	int		ngc_index;					/* search index			*/
	int		ngc_recent;					/* count of recent grps */
	NEWSGRP	*ngc_found;					/* search find marker	*/
}	NEWSGROUPS;

IMPORT	NEWSGROUPS	*create_newsgroups PROTO((char **restrict));
IMPORT	void		save_newsgroups PROTO((NEWSGROUPS *groups));
IMPORT	void		destroy_newsgroups PROTO((NEWSGROUPS *groups));
IMPORT	int			id_newsgroup PROTO((char *grpname));
IMPORT	NEWSGRP		*first_newsgroup PROTO((NEWSGROUPS *groups));
IMPORT	NEWSGRP		*next_newsgroup PROTO((NEWSGROUPS *groups));
IMPORT	NEWSGRP		*find_newsgroup PROTO((NEWSGROUPS *groups, char *grpname));
