#ifndef	__SOCKET_H__
#define	__SOCKET_H__

#ifndef	__PROTOTYPES_H__
#include <prototypes.h>
#endif

#ifndef	__STREAM_H__
#include <sys_stream.h>
#endif

#include <bool.h>

#include <sys/types.h>
#include <sys/socket.h>
#ifdef	COHERENT
#include <netinet/in.h>
#else
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netdb.h>
#endif
#endif

#define	INET_NETSTAT_PORT	15
#define	INET_FTP_PORT		21
#define	INET_TELNET_PORT	23
#define	INET_SNMP_PORT		25
#define	INET_TIME_PORT		37
#define	INET_BIND_PORT		42
#define	INET_WHOIS_PORT		43
#define	INET_FINGER_PORT	79
#define	INET_POP_PORT		109
#define	INET_AUTH_PORT		113
#define	INET_NNTP_PORT		119

#define	disconnect_socket(so)	close(so)

IMPORT	struct	hostent	*get_hostent PROTO((char *host));
IMPORT	int	connect_socket PROTO((char *host, int port));
IMPORT	int	bind_socket PROTO((int port, int backlog));
IMPORT	int	release_socket PROTO((int so));
IMPORT	STREAM	*open_socket PROTO((char *host, int port, int size));
IMPORT	void close_socket PROTO((STREAM *sp));
IMPORT	BOOL iolink_socket PROTO((char *host, int port));
IMPORT	char *name_socket PROTO((int so));

