#ifdef	EU_FAMILY
#define	__MULTINATIONAL
#define	__ENGLISH
#define	__GERMAN
#define	NR_DEFAULT 	NR_ENGLISH
#define	NR_SUPPORT 	0x0003
#define	NR_COUNT	2	
#endif

#ifdef	NA_FAMILY
#define	__MULTINATIONAL
#define	__ENGLISH
#define NR_DEFAULT 	NR_ENGLISH
#define	NR_SUPPORT	0x0001
#define	NR_COUNT	1
#endif

#ifdef	ALL_FAMILY
#define	__MULTINATIONAL
#define	__ENGLISH
#define	__GERMAN
#define	NR_DEFAULT	NR_ENGLISH
#define	NR_SUPPORT	0x0002
#define	NR_COUNT	2
#endif

#ifndef	__MULTINATIONAL
#define	__ENGLISH
#define	NR_DEFAULT	NR_ENGLISH
#define	NR_SUPPORT	0x0001
#define	NR_COUNT	1
#endif

extern	int			replacement_language;
extern	unsigned long	replacement_support;

/*	national replacement language families	*/

enum
{
	NR_ENGLISH = 0,
	NR_GERMAN,
	NR_FRENCH,
	NR_SPANISH,
	NR_ITALIAN
};	

#define	REPLACE_TEXT(str, env)			{CNULL - 1,		 str,0,0,0,0, 0, 0, env},                
#define	REPLACE_ENGLISH(str, a)			{CNULL - 1,      str,0,0,0,0, NR_ENGLISH, 0, a},
#define	REPLACE_FRENCH(str, a)			{CNULL - 1,      str,0,0,0,0, NR_FRENCH, 0, a},
#define	REPLACE_GERMAN(str, a)			{CNULL - 1,      str,0,0,0,0, NR_GERMAN, 0, a},
#define	REPLACE_SPANISH(str, a)			{CNULL - 1,      str,0,0,0,0, NR_SPANISH, 0, a},
#define	REPLACE_ITALIAN(str, a)			{CNULL - 1,      str,0,0,0,0, NR_ITALIAN, 0, a}

#ifdef	__MULTINATIONAL
IMPORT	void	GetVUMulti PROTO((int nr));
IMPORT	unsigned char VUToLower PROTO((unsigned char c));
IMPORT	unsigned char VUToUpper PROTO((unsigned char c));
IMPORT	char	*VUStrLower PROTO((unsigned char *s));
IMPORT	char	*VUStrUpper PROTO((unsigned char *s));
IMPORT	int	VUStrcmp PROTO((unsigned char *s1, unsigned char *s2));
IMPORT	int	VUStrncmp PROTO((unsigned char *s1, unsigned char *s2, int len));
IMPORT	int	VUStricmp PROTO((unsigned char *s1, unsigned char *s2));
IMPORT	int	VUStrnicmp PROTO((unsigned char *s1, unsigned char *s2, int len));
IMPORT	BOOL	VUStrTrue PROTO((unsigned char *s));
IMPORT	BOOL	VUValidText PROTO((unsigned char c));

IMPORT	char	*VUMultiDow PROTO((int d, BOOL abbr));
IMPORT	char	*VUMultiMonth PROTO((int m, BOOL abbr));
IMPORT	char	*VUDateDMY PROTO((time_t *time));
IMPORT	char	*VUDateMDY PROTO((time_t *time));
IMPORT	int	VUMultiCentury PROTO((time_t *time));
IMPORT	struct	tm* VULocalTime PROTO((time_t *time));
#else
#include <ctype.h>
#define	VUToLower(c)	tolower(c)
#define	VUToUpper(c)	toupper(c)
#define	VUStrLower(s)	strlwr(s)
#define	VUStrUpper(s)	strupr(s)
#define	VUStrcmp		strcmp
#define	VUStricmp		stricmp
#define	VUStrncmp		strncmp
#define	VUStrnicmp		strnicmp
#define	VUValidText(p)	((p1 > 31 && p1 < 127))
#define	VULocalTime(time)	localtime(time)
#endif


