/* eerste poging om cm206 Philips/lms aan te sturen */

#include "cm206.h" 

/* #define REALLY_SLOW_IO */

#define TRIES 10000

#include <sys/types.h>
#include <fcntl.h>

#include <asm/io.h>
#include <unistd.h>
#include <stdio.h>

void send_command(int command) 
{
  int tries=TRIES;
  while (!(inw(r_line_status) & ls_transmitter_buffer_empty) && tries>0)
    --tries;
  outw_p(command, r_uart_transmit);
/*  usleep(1000); */
}

int receive_echo() 
{
  int tries=TRIES;
  while (!(inw(r_line_status) & ls_receive_buffer_full) && tries>0) 
    --tries; 
  return inw(r_uart_receive);
/*  usleep(1000); */
}

void reset_drive() 
{
  outw(0x2d01, r_data_control); 
  usleep(1000);
  outw(0x2901, r_data_control);
}

void drive_status() 
{
  int i, e, status[2];
  send_command(c_drive_status);
  e = receive_echo();
  printf("Echo is %x\n", e);
  for (i=0; i<2; i++) {
    send_command(0xf8);
    printf("%d'th byte: %x\n", i, status[i]=receive_echo());
  }
  printf("\n");  
  printf("analyse: ");
  if (status[0] & dsb_error_condition) printf("error condition\n");
  if (status[0] & dsb_play_in_progress) printf("dsb_play_in_progress \n");
  if (status[0] & dsb_possible_media_change) printf("dsb_possible_media_change \n");
  if (status[0] & dsb_disc_present ) printf("disc_present \n");
  if (status[0] & dsb_drive_not_ready ) printf("dsb_drive_not_ready \n");
  if (status[0] & dsb_tray_locked ) printf("dsb_tray_locked \n");
  if (status[0] & dsb_tray_not_closed) printf("dsb_tray_not_closed\n");
}

int send_receive_polled(int command)
{
  send_command(command);
  return receive_echo();
}

int main(int argc, char **argv) {
  
  if (ioperm(CM206_BASE, 16, 1) || ioperm(0x80, 1, 1)) {
    fprintf(stderr, "Can't get iopermission\n");
    return -1;
  }

  reset_drive();
  sleep(5);
  drive_status();
}


