/* stats.c Give some statistics of the cm206-driver. by DvL.
   Prints `time' and reason for stat. 
   Usage typically: stats | sort -n
 */ 
#include "../linux/drivers/block/stats206.h"
#include "../linux/drivers/block/cm206.h"

#include <sys/ioctl.h>

#include <unistd.h>
#include <sys/types.h>
#include <fcntl.h>
#include <string.h>
#include <linux/cdrom.h>

main(int argc, char ** argv) {
  int fd, i, s;
  struct cdrom_multisession ms_info;

  if ((fd = open("/dev/cdrom", O_RDONLY))<0) {
    printf("Can't open /dev/lmscd\n");
    exit(-1);
  }
  for (i=0; i<NR_STATS; i++) {
    printf ("%5d %s: %d\n", ioctl(fd, CM206CTL_GET_LAST_STAT, i), 
	    stats_name[i], ioctl(fd, CM206CTL_GET_STAT, i));
  }
/*
  printf ("ioctl: %d %x\n", i=ioctl(fd, CDROMMULTISESSION, &ms_info),
	  CDROMMULTISESSION) ;
  if (i) {
    printf("No ms-info available\n");
  } else {
    printf("Last session starts at %d\n", ms_info.addr.lba);
    printf("XA-mode %d\n", ms_info.xa_flag);
  }
*/
  close(fd);
}
