/*
 * cursor.c
 * Program to change software cursor color at run time.
 * Written by Bill Paul <ghod@drycas.club.cc.cmu.edu> on 12/5/93
 * Updated on 2/21/94: changed block/underline values to avoid conflict
 * with my Dorio terminal.
 * Updated on 3/20/94 to allow 16 cursor colors
 */


#include <stdio.h>
#define ESC 0x1B
#define MAXCHOICES 22

static char *colors[] = { "black", "blue", "green", "cyan",
		          "red", "magenta", "orange", "white", 
                          "grey", "bblue", "bgreen", "bcyan",
		          "bred", "pink", "yellow", "bwhite", 
			  "noblink", "blink", "underline", "block",
                          "8color", "16color", NULL };

static short values[] = { 100, 116, 132, 148,
                        164, 180, 196, 212,
                        228, 244, 260, 276,
                        292, 308, 324, 340,
                        33, 33, 32, 32, 31, 31 };


main(argc,argv)
int argc;
char *argv[];

{
int val = 0 ;

if (argc != 2) {
	fprintf (stderr, "Usage: %s [ ", argv[0]);
	while (val < MAXCHOICES) {
		fprintf (stderr,"%s %s",
			 colors[val], val < MAXCHOICES - 1 ?  "| " : "");
		val++;
		}
	fprintf (stderr, "]\n");
	exit (-1);
	}

while (strcmp(argv[1],colors[val]) && val < MAXCHOICES )
	val++;

if (val == MAXCHOICES) {
	fprintf(stderr,"`%s' is an illegal keyword.\n",argv[1]);
	exit (-2);
}

if (val < 16)
	printf ("%c[%dm",ESC,values[val]);
else
	printf ("%c[?%d%c",ESC,values[val], (val % 2) ? 'h' : 'l');

exit(0);
}
