/******************************************************************************
 * --- bt.h --- Copyright (C) 1994 by Thomas Weidenfeller
 *
 * File ID:
 *	$Id: bt.h,v 1.3 1994/10/26 18:23:46 root Exp $
 *
 * Purpose:
 * 	User header file for the unofficial BiTronics(tm) (BI-directional
 * 	cenTRONICS) Linux character device driver.
 *
 * Copyright:
 *	Copyright (C) 1994 by T. Weidenfeller. All rights reserved
 *	
 *	You are free to copy, modify and distribute this software as you
 *	see fit, and to use it for any purpose, provided this copyright
 *	notice and the warranty disclaimer are included without any
 *	modification in all copies and modifications. You have to mark all
 *	modifications clearly and you are also commited to give propper
 *	acknowledgment of the original source if you include this software
 *	or parts of it in another software.
 *	
 * Warranty:
 *	The BiTronics device driver and the accompaning material is a free
 *	sample of no commercial value. It comes without any warranty:
 *	
 *	THERE IS NO WARRANTY OF ANY KIND WITH REGARDS TO THIS MATERIAL,
 *	INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 *	MECHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. The author
 *	shall not be liable for errors contained in the material or for
 *	incidental or consequental damage in connection with the
 *	furnishing, performance, or use of this material.
 *	
 * Revisions: $Log: bt.h,v $
 *	Revision 1.3  1994/10/26  18:23:46  root
 *	General harmonisation (prep 1. ALPHA release).
 *
 *	Revision 1.2  1994/10/19  19:08:44  root
 *	Configuration data now in a seperate file.
 *	Name space cleaned up.
 *
 *	Revision 1.1  1994/10/16  07:35:51  root
 *	Initial revision
 *****************************************************************************/

#ifndef BT_DRIVER_H_
#define BT_DRIVER_H_

/******************************************************************************
 * ioctl() calls
 * NOTE: CURRENTLY NON OF THEM IS SUPPORTED!!!
 *****************************************************************************/
#ifdef BT_TRACE
#define	BTDEBUG	(0x01)	/* sets debug-flags if available	*/
#endif

#define BTABORT	(0x02)	/* abort when error, else retry		*/
#define BTDIR	(0x03)	/* get current BiTronics direction	*/
#define BTERR	(0x04)	/* get last BiTronics error		*/
#define BTTERM	(0x05)	/* force BiTronics termination		*/
#define BTRESET	(0x06)	/* force port reset			*/
#define BTRETRY	(0x07)	/* set retry value			*/

#endif	/* BT_DRIVER_H_	*/
