/* dastest.c, M. Welsh (mdw@cs.cornell.edu)
 * Simple test program to read and display samples from DAS1200 A/D
 * conversion.
 *
 * (c)1995 M. Welsh
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 */

/* This program is quite straightforward; let me know if you have
 * questions or problems using it. --mdw */

#include <sys/types.h>
#include <sys/time.h>
#include <unistd.h>
#include <stdio.h>
#include <fcntl.h>
#include <sys/ioctl.h>
#include "das1200.h"

/* Buffer size for reads from device */
#define BUFFER_SIZE 16384

void main(void) {

  unsigned char buf[BUFFER_SIZE];
  int fd;
  int c, i;
  struct das1200_chan chans;

  /* Open device */
  fd = open("/dev/das1200",O_RDONLY);
  if (fd < 0) {
	perror("open");
	exit(-1);
  }

  /* Read the MUX scan register to determine the start and end
   * channels set on the card. */
  if ((c = ioctl(fd,DAS1200_IO_GETCHAN,&chans)) != 0) {
     perror("ioctl: read channels");
     exit (-1);
  }
  fprintf(stderr,"Start channel: %d  End channel: %d\n",
  	chans.das_schan, chans.das_echan);

  /* Set the start and end channels in the MUX scan register. */
  chans.das_schan = 0;
  chans.das_echan = 3;
  if ((c = ioctl(fd,DAS1200_IO_SETCHAN,&chans)) != 0) {
     perror("ioctl: set channels");
     exit (-1);
  }

  /* Infinitely read samples from the A/D convertor. */
  while (1) {

     c = read(fd,buf,BUFFER_SIZE);
     if (c != BUFFER_SIZE) {
       perror("read");
       exit(-1);
     }
     
     /* Display samples in hex, two bytes per sample. They are
      * displayed exactly as returned by the board; a simple
      * calculation using the board's gain will determine the
      * voltage (see dasgraph.c).
      */
     for (i = 0; i < BUFFER_SIZE; i+=2) {
       if (!(i % 32)) fprintf(stderr,"\n");
       fprintf(stderr,"%02x%02x ",buf[i+1],buf[i]);
     }

  }

}
