/* dastime.c, M. Welsh (mdw@cs.cornell.edu)
 * Simple program to read samples from DAS1200 board and time
 * acquisition rate.
 *
 * (c)1995 M. Welsh
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 */

/* See dastest.c and dasgraph.c for more complete code which
 * drives this board. This is used only as a simple tool to
 * gauge the performance of the driver. 
 */

#include <sys/types.h>
#include <sys/time.h>
#include <unistd.h>
#include <stdio.h>
#include <fcntl.h>
#include <assert.h>
#include <stdlib.h>
#include <malloc.h>

void main(int argc, char **argv) {

  unsigned char *buf;
  int fd, c;
  struct timeval tv1, tv2;
  unsigned long calc;

  int NUM_SAMPLES, BUFFER_SIZE;

  if (argc != 2) {
  	fprintf(stderr,"Usage: %s <num_samples>\n",argv[0]);
  	exit(-1);
  }

  NUM_SAMPLES = atoi(argv[1]);
  BUFFER_SIZE = 2*NUM_SAMPLES;

  assert(buf = (unsigned char *)malloc(BUFFER_SIZE));

  fd = open("/dev/das1200",O_RDONLY);
  if (fd < 0) {
	perror("open");
	exit(-1);
  }

  while (1) {

     gettimeofday(&tv1,NULL);
     c = read(fd,buf,BUFFER_SIZE);
     gettimeofday(&tv2,NULL);
     
     if (c != BUFFER_SIZE) {
       perror("read");
       exit(-1);
     }
     
     calc = (1e6*(tv2.tv_sec - tv1.tv_sec)) + (tv2.tv_usec - tv1.tv_usec);
     fprintf(stderr,"Time for %d samples: %lu usec: %f samples/sec\n",
        NUM_SAMPLES,calc,(float)((float)NUM_SAMPLES)/((float)calc*1e-6));

  }

}
