#ifndef __SONIX_H__
#define __SONIX_H__

#ifdef __KERNEL__
#define SONIX_NAME	"PC Arpeggio"
#define SONIX_VERSION	"0.12 ALPHA"

#define SONIX_MEM_LIMIT			8192		/* Maximum queued bytes */
#define SONIX_SELECT_WRITE		2048		/* Bytes that must be free before we select wake */
#define SONIX_IRQ			11		/* Interrupt */
#define SONIX_REGION			0x200		/* I/O space */
#define SONIX_REGION_SIZE		16		/* I/O size */
#define SONIX_MAJOR			29		/* Major to use */

#define SONIX_ICRADD			0x00900013
#define SONIX_REBOOT			0x00900017
#define SONIX_IINTADD			0x0090001B
#define SONIX_OINTADD			0x00900019

/*
 *	Internal driver parameters
 */
 
#define SONIX_IOBASE			SONIX_REGION
#define SONIX_ADDR_TOP			0x1000000
#define WIN_SIZE			512
#define WIN_OFFSET(x)			((x)&0x1FF)
#define WIN_FRAME(x)			((x)>>9)
#define SAP_STRUCT_SIZE			58

#define SAP_OFFSET			18
#define RXSIG_OFFSET			36
#define TXSIG_OFFSET			26
#define BUF_OFFSET			42
#define SIZE_OFFSET			46

struct sonix_sig_control
{
	unsigned char type;
	unsigned char control;	/* Unused for CONN/DISC , windowsize for ACK */
	unsigned char src;
	unsigned char dst;
};

struct sonix_sig_data
{
	unsigned char type __attribute__((packed));
	unsigned char control __attribute__((packed));
	unsigned char src __attribute__((packed));
	unsigned char dst __attribute__((packed));
	unsigned long buffer __attribute__((packed));
	unsigned short size __attribute__((packed));
};

union sonix_signal
{
	struct sonix_sig_control ctrl;
	struct sonix_sig_data data;
};

#endif

#define SAP_UNUSED	0
#define SAP_B1D		1	/* Bearer one data  */
#define SAP_B1V		2	/* Bearer one voice */
#define SAP_B2D		3	/* Bearer two data  */
#define SAP_B2V		4	/* Bearer two voice */
#define SAP_HDST	5	/* Handset 	    */
#define SAP_LS		6	/* Loudspeaker	    */
#define SAP_OMNITEL	7	/* Omnitel ???	    */
#define SAP_LAN		8	/* LAN server ??    */
#define SAP_SER		9	/* Serial channel   */
#define SAP_CFG		10	/* Configuration    */
#define SAP_MODEM	11	/* Modem control    */
#define SAP_MDATA	12	/* Modem data	    */
#define SAP_NETCFG	13	/* Network config   */

/* Signals and errors - urgh */

#define S_NOSIGNAL		0
#define S_DATA			1
#define S_DROPDATALINK		2
#define S_DATALINKDROPPED	3
#define S_CONNECT		4
#define S_DISCONNECT		5
#define S_POLL			6
#define S_WINDOWSIZE		7
#define S_DATAPOLL		8
#define S_DATAAKRQ		9
#define S_ACKNOWLEDGE		10
#define S_NOP			127


#define T_NOERROR		0
#define T_MISSEDPACKET		1
#define T_CONNECTED		2
#define T_DISCONNECTED		3
#define T_SAPUNDEFINED		4
#define T_CONNECTFAIL		5
#define T_DISCONNECTFAIL	6
#define T_MISSEDPOLL		7
#define T_BUFFEROVERFLOW	8
#define T_SENDFAIL		9
#define T_WINDOW		10
#define T_ALLOCFAIL		11
#define T_INVALIDSAP		12
#define T_SAPINUSE		13
#define T_SAPNOTINUSE		14
#define T_INVALIDADDRESS	15
#define T_NOTXSIGNAL		16
#define T_ACKNOWLEDGE		17
#define T_SIGNALPOOLEMPTY	18

#endif
