/* This demo shows the use of a slider. Every time the slider changes
   position it is returned by do_forms() and the text field showing its
   value is adapted.
*/

#include <stdio.h>
#include "forms.h"

int
main(int argc, char *argv[])
{
  FL_FORM *form;
  FL_OBJECT *retobj,*slider, *button, *value;
  char str[30];

   fl_initialize(argv[0], "FormDemo", 0, 0 ,&argc, argv);
  form = fl_bgn_form(FL_UP_BOX,240,400);
     slider = fl_add_slider(FL_VERT_SLIDER,40,40,60,320,"");
     fl_set_slider_bounds(slider,-1,1);
     fl_set_slider_value(slider,0);
     fl_set_object_color(slider,FL_SLIDER_COL1,FL_GREEN);
     value = fl_add_box(FL_DOWN_BOX,120,180,100,30,"");
/*     fl_set_object_color(value,FL_TOP_BCOL,FL_TOP_BCOL); */
     fl_set_object_lalign(value,FL_ALIGN_CENTER);
     button = fl_add_button(FL_RETURN_BUTTON,120,80,100,30,"Exit");
  fl_end_form();

  fl_show_form(form,FL_PLACE_CENTER,FL_NOBORDER,NULL);
  do
  {
    sprintf(str,"%f",fl_get_slider_value(slider));
    fl_set_object_label(value,str);
    retobj = fl_do_forms();
  } while (retobj != button);
  fl_hide_form(form);
  return 0;
}
