/* This demo shows the use of menu's. 
 * The first two are PUSH_MENUs (pop-up).
 * The third one is PULLDOWN_MENU
 * and the last one is TOUCH_MENU
 */

#include "forms.h"

int
main(int argc, char *argv[])
{
  FL_FORM *form;
  FL_OBJECT *obj, *button, *menu[4], *box[4];
  int i, j;
  int col[4];

  fl_initialize(argv[0], "FormDemo", 0, 0 ,&argc, argv);
  form = fl_bgn_form(FL_NO_BOX,440,380);
  obj = fl_add_box(FL_BORDER_BOX,0,0,440,380,"");
    fl_set_object_color(obj,FL_SLATEBLUE,FL_COL1);

  menu[0] = obj = fl_add_menu(FL_PUSH_MENU,0,350,110,30,"Color 1");
  fl_set_object_shortcut(obj, "1#1", 1);
  menu[1] = obj = fl_add_menu(FL_PUSH_MENU,110,350,110,30,"Color 2");
  fl_set_object_shortcut(obj, "2#2", 1);
  menu[2] = obj = fl_add_menu(FL_PULLDOWN_MENU,220,350,110,30,"Color 3");
  fl_set_object_shortcut(obj, "3#3", 1);
  menu[3] = obj = fl_add_menu(FL_TOUCH_MENU,330,350,110,30,"Color 4");
  fl_set_object_shortcut(obj, "4#4", 1);
  box[0] = obj = fl_add_box(FL_SHADOW_BOX,20,70,70,230,"");
  box[1] = obj = fl_add_box(FL_SHADOW_BOX,130,70,70,230,"");
  box[2] = obj = fl_add_box(FL_SHADOW_BOX,240,70,70,230,"");
  box[3] = obj = fl_add_box(FL_SHADOW_BOX,350,70,70,230,"");
  button = obj = fl_add_button(FL_NORMAL_BUTTON,310,20,110,30,"Exit");
  fl_end_form();

  for (i=0; i<4; i++)
  {
    fl_show_menu_symbol(menu[i], 1);
    fl_set_menu(menu[i],"Red|Green|Yellow|Blue|Purple|Cyran|White");
    fl_set_menu_item_shortcut(menu[i], 1, "Rr#R#r");
    fl_set_menu_item_shortcut(menu[i], 2, "Gg#G#g");
    fl_set_menu_item_shortcut(menu[i], 3, "Yy#Y#y");
    fl_set_menu_item_shortcut(menu[i], 4, "Bb#B#b");
    fl_set_menu_item_shortcut(menu[i], 5, "Pp#P#p");
    fl_set_menu_item_shortcut(menu[i], 6, "Cc#C#c");
    fl_set_menu_item_shortcut(menu[i], 7, "Ww#W#w");
    col[i] = i + 1;
    fl_set_object_color(box[i], FL_BLACK+col[i], FL_BLACK);
    for (j=1; j<=4; j++)
       fl_set_menu_item_mode(menu[i], j, FL_PUP_GREY | FL_PUP_BOX);
    for (j=5; j<=7; j++) 
       fl_set_menu_item_mode(menu[i], j, FL_PUP_BOX);
    fl_set_menu_item_mode(menu[i], col[i], FL_PUP_CHECK);
  }

   
  fl_show_form(form,FL_PLACE_CENTER,FL_NOBORDER,NULL);
  do
  {
    obj = fl_do_forms();
    for (i=0; i<4; i++)
      if (obj == menu[i] && fl_get_menu(menu[i]) != -1)
      {
        for (j=0; j<4; j++) 
           fl_set_menu_item_mode(menu[j], col[i], FL_PUP_BOX);
	col[i] = fl_get_menu(menu[i]);
        for (j=0; j<4; j++)
            fl_set_menu_item_mode(menu[j], col[i], FL_PUP_GREY | FL_PUP_BOX);
	fl_set_menu_item_mode(menu[i], col[i], FL_PUP_CHECK);	
	fl_set_object_color(box[i], FL_BLACK+col[i], FL_BLACK);
      }
  } while (obj != button);
  fl_hide_form(form);
  return 0;
}
