/*
 *  forms.h   $Revision: 0.61 $ $State: Beta $
 *            $Date: 1995/01/20 19:22:37 $ $Author: zhao $
 *
 *. All XForms files as distributed in this package are
 *  Copyright(c) 1994 by T.C. Zhao and Mark Overmars.
 *
 *  All rights reserved. Unpublished rights reserved under the
 *  copyright laws of the United States.
 *
 *  Permission to use, copy, and distribute this software verbatim
 *  and in its entirety for non-commercial purposes and without fee,
 *  is hereby granted, provided that the above copyright notice and
 *  this permission notice appear in all copies and their documentation.
 *
 *  This software may be modified for your own use, but modified versions
 *  may not be distributed without prior consent of the authors.
 *
 *  This software is provided "as is" without expressed or implied
 *  warranty of any kind.
 *.
 *
 * ******** This file is generated automatically. DO NOT CHANGE *********
 */

#ifndef FL_FORMS_H
#define FL_FORMS_H

#if defined(__cplusplus) || defined(_LANGUAGE_C_PLUS_PLUS)
# define PLUS_WRAPPER
extern "C"
{
#endif

#include <stdio.h>
#include <string.h>
#include <limits.h>

/*
 * $Id: Basic.h,v 0.61 1995/01/20 19:22:37 zhao Beta $
 *
 *  Basic definitions and limits.
 *  Window system independent prototypes
 *
 *  Modify with care
 *
 */

#ifndef FL_BASIC_H
#define FL_BASIC_H		/* { */

#include <stdio.h>
#include <stdlib.h>
#include <limits.h>

/* Max  directory length  */

#ifndef FL_PATH_MAX
#  ifndef PATH_MAX
#      define FL_PATH_MAX       512
#  else
#      define FL_PATH_MAX       PATH_MAX
#  endif
#endif /* !def FL_PATH_MAX */

/* for compatibilities */
#ifndef FALSE
# define FALSE 0
# define TRUE  1
#endif

/*
 * The screen coordinate unit, FL_Coord, must be of signed type. Without
 * prototype support, a type other than integer might not work right.
 * If FL_Coord is float, FL_CoordIsFloat must be defined to be 1 so that
 * round-off error can be checked. **TODO Float not tested ***
 */

typedef int FL_Coord;
#define FL_CoordIsFloat 0	/* define this if FL_Coord is of type float */

typedef unsigned long FL_COLOR;

/*
 * Coordinates can be in pixels, milli-meters or point (1/72inch)
 * To be implemented.
 */
typedef enum
{
    FL_COORD_PIXEL,		/* default */
    FL_COORD_MM,
    FL_COORD_POINT
} FL_COORD_UNIT;

/*
 * All object classes.
 */

typedef enum
{
    FL_INVALID_CLASS = -1,
    FL_BUTTON, FL_LIGHTBUTTON, FL_ROUNDBUTTON, FL_CHECKBUTTON,
    FL_BITMAPBUTTON, FL_PIXMAPBUTTON,
    FL_BITMAP, FL_PIXMAP,
    FL_BOX, FL_TEXT,
    FL_MENU, FL_CHART, FL_CHOICE,
    FL_COUNTER, FL_SLIDER, FL_VALSLIDER, FL_INPUT,
    FL_BROWSER,
    FL_DIAL,
    FL_TIMER,
    FL_CLOCK,
    FL_POSITIONER,
    FL_FREE,
    FL_XYPLOT,
    FL_FOLDERTAB,
    FL_CANVAS
} FL_CLASS;

/* how to display a form onto screen */

typedef enum
{
    FL_PLACE_FREE,		/* size remain resizable      */
    FL_PLACE_MOUSE,		/* mouse centered on form     */
    FL_PLACE_CENTER,		/* center of the screen       */
    FL_PLACE_POSITION,		/* specific position          */
    FL_PLACE_SIZE,		/* specific size              */
    FL_PLACE_ASPECT,		/* keep aspect ratio          */
    FL_PLACE_FULLSCREEN,	/* scale to fit screen        */
    FL_PLACE_HOTSPOT,		/* so mouse fall on (x,y)     */
    FL_PLACE_FREE_CENTER	/* center & resizable         */
} FL_PLACE;

/* numerical value is important, at least for now */
typedef enum
{
    FL_TRANSIENT = -1,
    FL_NOBORDER = 0,
    FL_FULLBORDER = 1
} FL_DECORATION;

/* All box types */
typedef enum
{
    FL_NO_BOX,
    FL_UP_BOX,
    FL_DOWN_BOX,
    FL_FLAT_BOX,
    FL_BORDER_BOX,
    FL_SHADOW_BOX,
    FL_FRAME_BOX,
    FL_ROUNDED_BOX,
    FL_RFLAT_BOX,
    FL_RSHADOW_BOX,
    FL_OVAL_BOX,
    FL_OSHADOW_BOX
} FL_BOX_TYPE;

/* How to place text relative to a box */
typedef enum
{
    FL_ALIGN_TOP,
    FL_ALIGN_BOTTOM,
    FL_ALIGN_LEFT,
    FL_ALIGN_RIGHT,
    FL_ALIGN_CENTER,
    FL_ALIGN_VERT = 100
} FL_ALIGN;


/*
 *  some special color index for FL private colormap. It does not matter
 *  what the value of each enum is, but it must start from 0 (don't
 *  have to be black). The weird numbers are for compatibilities
 *  with IrisGL version of the FORMS. It may come a time it is not
 *  important anymore but for the time being, leave it as it is.
 */
typedef enum
{
    FL_BLACK,
    FL_RED,
    FL_GREEN,
    FL_YELLOW,
    FL_BLUE,
    FL_MAGENTA,
    FL_CYAN,
    FL_WHITE,

    FL_INDIANRED,
    FL_SLATEBLUE,

    FL_COL1,
    FL_RIGHT_BCOL,
    FL_BOTTOM_BCOL,
    FL_TOP_BCOL,
    FL_LEFT_BCOL,
    FL_MCOL,

    FL_INACTIVE,
    FL_PALEGREEN,
    FL_DARKGOLD,

    FL_FREE_COL1, FL_FREE_COL2,
    FL_FREE_COL3, FL_FREE_COL4,
    FL_FREE_COL5, FL_FREE_COL6,
    FL_FREE_COL7, FL_FREE_COL8,
    FL_FREE_COL9, FL_FREE_COL10,
    FL_FREE_COL11, FL_FREE_COL12,
    FL_FREE_COL13, FL_FREE_COL14,
    FL_FREE_COL15, FL_FREE_COL16
} FL_PD_COL;

#define FL_BUILT_IN_COLS  19
#define FL_INACTIVE_COL  FL_INACTIVE

/* Some aliases for the color */

#define FL_GRAY16           FL_RIGHT_BCOL
#define FL_GRAY35           FL_BOTTOM_BCOL
#define FL_GRAY80           FL_TOP_BCOL
#define FL_GRAY90           FL_LEFT_BCOL
#define FL_GRAY63           FL_COL1
#define FL_GRAY75           FL_MCOL

#define  FL_LCOL            FL_BLACK

/* Pop-up menu item attributes. NOTE if more than 8, need to change
   choice and menu class where mode is kept by a single byte */
enum
{
    FL_PUP_NONE,
    FL_PUP_GREY = 1,
    FL_PUP_BOX = 2,
    FL_PUP_CHECK = 4,
    FL_PUP_INACTIVE = 8
};

#define FL_PUP_GRAY   FL_PUP_GREY
#define FL_PUP_TOGGLE FL_PUP_BOX


/* Events that form reacts to.  */
typedef enum
{
    FL_INVALID = -1,
    FL_DRAW,
    FL_PUSH,
    FL_RELEASE,
    FL_ENTER,
    FL_LEAVE,
    FL_MOUSE,
    FL_FOCUS,
    FL_UNFOCUS,
    FL_KEYBOARD,
    FL_MOTION,
    FL_STEP,
    FL_SHORTCUT,
    FL_FREEMEM,
    FL_OTHER,			/* property, selection etc */
    FL_PS			/* dump a form into EPS    */
} FL_EVENTS;

#define FL_MOVE   FL_MOTION	/* for compatibility */

/* Resize policies */
typedef enum
{
    FL_RESIZE_NONE,
    FL_RESIZE_X,
    FL_RESIZE_Y
} FL_RESIZE_T;

#define FL_RESIZE_ALL  (FL_RESIZE_X | FL_RESIZE_Y)

/* Keyboard focus control */
typedef enum
{
    FL_KEY_NONE = 0,		/* not interested in any keys          */
    FL_KEY_TAB = 1,		/* normal keys + 4 direction cursor    */
    FL_KEY_NORMAL = 2,		/* normal keys(0-255) -tab +left/right */
    FL_KEY_SPECIAL = 4,		/* only needs special keys             */
    FL_KEY_ALL = 7		/* all keys                            */
} FL_KEY;

#define FL_ALT_VAL   128	/* alt + Key --> 128+key */

/* Internal use */

typedef enum
{
    FL_FIND_INPUT,
    FL_FIND_AUTOMATIC,
    FL_FIND_MOUSE,
    FL_FIND_CANVAS,
    FL_FIND_KEYSPECIAL
} FL_FIND;

/*******************************************************************
 * FONTS
 ******************************************************************/

#define FL_MAXFONTS     32	/* max number of fonts */

typedef enum
{
    FL_INVALID_STYLE = -1,
    FL_NORMAL_STYLE,
    FL_BOLD_STYLE,
    FL_ITALIC_STYLE,
    FL_BOLDITALIC_STYLE,

    FL_FIXED_STYLE,
    FL_FIXEDBOLD_STYLE,
    FL_FIXEDITALIC_STYLE,
    FL_FIXEDBOLDITALIC_STYLE,

    FL_TIMES_STYLE,
    FL_TIMESBOLD_STYLE,
    FL_TIMESITALIC_STYLE,
    FL_TIMESBOLDITALIC_STYLE,

    /* following are derived and must differ by multiples of SHADOW, i.e.,
       FL_ENGRAVED%SHADOW == 0. All being 2^n has the benefit that (lstyle |
       FL_SHADOW) == (lstyle + FL_SHADOW). */

    FL_SHADOW_STYLE = 64,
    FL_ENGRAVED_STYLE = 2 * FL_SHADOW_STYLE,
    FL_EMBOSSED_STYLE = 4 * FL_SHADOW_STYLE
} FL_TEXT_STYLE;


#define FL_FONT_STYLE FL_TEXT_STYLE

#define special_style(a)  (a >=FL_SHADOW_STYLE &&\
                           a <= (FL_EMBOSSED_STYLE+FL_MAXFONTS))

#define FL_TINY_SIZE       8
#define FL_SMALL_SIZE      10
#define FL_NORMAL_SIZE     12
#define FL_MEDIUM_SIZE     14
#define FL_LARGE_SIZE      18
#define FL_HUGE_SIZE       24

#define FL_DEFAULT_SIZE   FL_SMALL_SIZE

/* Defines for compatibility */
#define FL_TINY_FONT    FL_TINY_SIZE
#define FL_SMALL_FONT   FL_SMALL_SIZE
#define FL_NORMAL_FONT  FL_NORMAL_SIZE
#define FL_MEDIUM_FONT  FL_MEDIUM_SIZE
#define FL_LARGE_FONT   FL_LARGE_SIZE
#define FL_HUGE_FONT    FL_HUGE_SIZE

#define FL_NORMAL_FONT1   FL_SMALL_FONT
#define FL_NORMAL_FONT2   FL_NORMAL_FONT
#define FL_DEFAULT_FONT   FL_SMALL_FONT

#define FL_BOUND_WIDTH    (FL_Coord)3

#define FL_BEGIN_GROUP    10000
#define FL_END_GROUP      20000

/*
 *  Definition of basic struct that holds an object
 */

struct forms_;
struct fl_pixmap;

typedef struct flobjs_
{
    struct forms_ *form;	/* the form this object belong        */
    struct flobjs_ *prev;	/* prev. obj in form                  */
    struct flobjs_ *next;	/* next. obj in form                  */
    void *u_vdata;		/* anything user likes                */
    long u_ldata;		/* anything user lines                */
    int objclass;		/* class of object, button, slider etc */
    int type;			/* type within the class              */
    int boxtype;		/* what kind of box type              */
    FL_Coord x, y, w, h;	/* obj. location and size             */
    FL_COLOR col1, col2;	/* colors of obj                      */

    char *label;		/* object label                       */
    FL_COLOR lcol;		/* label color                        */
    int align;
    int linside;
    int lsize, lstyle;		/* label size and style               */

    unsigned char *shortcut;

    int (*handle) (struct flobjs_ *, int, FL_Coord, FL_Coord, int, void *);
    void (*object_callback) (struct flobjs_ *, long);
    long argument;

    void *spec;			/* instantiation                     */
    void *flpixmap;		/* pixmap double buffering stateinfo  */
    int use_pixmap;		/* true to use pixmap double buffering */

    /* re-configure preference */
    unsigned int resize;	/* what to do if WM resizes the FORM  */
    unsigned int nwgravity;	/* how to re-position if resized      */
    unsigned int segravity;	/* how to re-position if resized      */

    /* some interaction flags */
    int pushed;
    int focus;
    int belowmouse;
    int active;			/* if accept event */
    int input;
    int wantkey;
    int radio;
    int automatic;
    int redraw;
    int visible;
    int dnd;
} FL_OBJECT;

typedef void (*FL_FORMCALLBACKPTR) (struct flobjs_ *);
typedef void (*FL_CALLBACKPTR) (FL_OBJECT *, long);
typedef int (*FL_RAW_CALLBACK) (struct forms_ *, void *);

extern FL_OBJECT *FL_EVENT;

/*** FORM ****/

typedef struct forms_
{
    char *label;		/* window title            */
    unsigned long window;	/* X resource ID for window */
    FL_Coord x, y, w, h;	/* current geometry info   */
    FL_Coord hotx, hoty;	/* hot-spot of the form    */

    struct flobjs_ *first;
    struct flobjs_ *last;
    struct flobjs_ *focusobj;

    void (*form_callback) (struct flobjs_ *);


    unsigned long compress_mask;
    unsigned long evmask;
    FL_RAW_CALLBACK key_callback;
    FL_RAW_CALLBACK push_callback;
    FL_RAW_CALLBACK crossing_callback;
    FL_RAW_CALLBACK motion_callback;
    FL_RAW_CALLBACK all_callback;

    void *flpixmap;		/* back buffer             */

    /* interaction and other flags */
    int vmode;			/* current X visual class  */
    int deactivated;		/* true if sensitive       */
    int use_pixmap;		/* true if dbl buffering   */
    int frozen;			/* true if sync change     */
    int visible;		/* true if mapped          */
    int wm_border;		/* window manager info     */
    unsigned int prop;		/* other attributes        */
} FL_FORM;

typedef int (*FL_HANDLEPTR) (FL_OBJECT *, int, FL_Coord, FL_Coord, int, void *);

/*  Some utility stuff */

typedef struct
{
    int val;
    const char *name;
} FL_VN_PAIR;

extern int fl_get_vn_value(FL_VN_PAIR *, const char *);
extern const char *fl_get_vn_name(FL_VN_PAIR *, int);

/*
 *  Basic public routine prototypes
 */

/** Generic routines that deal with FORMS **/

extern FL_FORM *fl_bgn_form(int, FL_Coord, FL_Coord);
extern void fl_end_form(void);
extern FL_OBJECT *fl_do_forms(void);
extern FL_OBJECT *fl_check_forms(void);
extern FL_OBJECT *fl_do_only_forms(void);
extern FL_OBJECT *fl_check_only_forms(void);
extern void fl_freeze_form(FL_FORM *);
extern void fl_unfreeze_form(FL_FORM *);
extern void fl_deactivate_form(FL_FORM *);
extern void fl_activate_form(FL_FORM *);
extern void fl_deactivate_all_forms(void);
extern void fl_activate_all_forms(void);
extern void fl_scale_form(FL_FORM *, double, double);
extern void fl_set_form_position(FL_FORM *, FL_Coord, FL_Coord);

extern void fl_set_form_callback(FL_FORM *, FL_FORMCALLBACKPTR);
#define  fl_set_form_call_back    fl_set_form_callback

extern void fl_set_form_size(FL_FORM *, FL_Coord, FL_Coord);
extern void fl_set_form_hotspot(FL_FORM *, FL_Coord, FL_Coord);
extern void fl_set_form_hotobject(FL_FORM *, FL_OBJECT *);
extern void fl_set_form_minsize(FL_FORM *, FL_Coord, FL_Coord);
extern void fl_set_form_maxsize(FL_FORM *, FL_Coord, FL_Coord);
extern void fl_set_form_event_cmask(FL_FORM *, unsigned long);
extern unsigned long fl_get_form_event_cmask(FL_FORM *);

extern void fl_set_initial_placement(FL_FORM *, FL_Coord, FL_Coord,
				     FL_Coord, FL_Coord);
extern long fl_show_form(FL_FORM *, int, int, const char *);
extern void fl_hide_form(FL_FORM *);
extern void fl_free_form(FL_FORM *);
extern void fl_redraw_form(FL_FORM *);
extern void fl_set_form_dblbuffer(FL_FORM *, int);

extern FL_RAW_CALLBACK fl_register_raw_callback(FL_FORM *, unsigned long,
						FL_RAW_CALLBACK);

#define fl_register_call_back fl_register_raw_callback

extern FL_OBJECT *fl_bgn_group(void);
extern FL_OBJECT *fl_end_group(void);

/****** Routines that deal with FL_OBJECTS ********/

extern void fl_set_object_boxtype(FL_OBJECT *, int);
extern void fl_set_object_resize(FL_OBJECT *, unsigned, unsigned, unsigned);
extern void fl_set_object_lsize(FL_OBJECT *, int);
extern void fl_set_object_lstyle(FL_OBJECT *, int);
extern void fl_set_object_lcol(FL_OBJECT *, FL_COLOR);
extern void fl_set_object_dragndrop(FL_OBJECT *, int);
extern void fl_set_object_focus(FL_FORM *, FL_OBJECT *);
extern void fl_redraw_object(FL_OBJECT *);
extern void fl_set_object_lalign(FL_OBJECT *, int);	/* to be removed */

#define  fl_set_object_align fl_set_object_lalign

extern FL_CALLBACKPTR fl_set_object_callback(FL_OBJECT *, FL_CALLBACKPTR, long);
#define fl_set_call_back      fl_set_object_callback

extern void fl_show_object(FL_OBJECT *);
extern void fl_hide_object(FL_OBJECT *);
extern void fl_free_object(FL_OBJECT *);
extern void fl_delete_object(FL_OBJECT *);
extern void fl_set_object_color(FL_OBJECT *, FL_COLOR, FL_COLOR);
extern void fl_set_object_label(FL_OBJECT *, const char *);
extern void fl_activate_object(FL_OBJECT *);
extern void fl_deactivate_object(FL_OBJECT *);
extern void fl_set_object_shortcut(FL_OBJECT *, const char *, int);
extern void fl_set_object_dblbuffer(FL_OBJECT *, int);

extern int fl_enumerate_fonts(void (*)(const char *s), int);
extern void fl_set_font_name(int, const char *);
extern void fl_set_font(int, int);

/* routines that facilitate free object */

extern int fl_get_char_height(int, int, int *, int *);
extern int fl_get_string_height(int, int, const char *, int, int *, int *);
extern int fl_get_string_width(int, int, const char *, int);

extern void fl_drw_text(int, FL_Coord, FL_Coord, FL_Coord, FL_Coord,
			FL_COLOR, int, int, char *);

extern void fl_drw_text_beside(int, FL_Coord, FL_Coord, FL_Coord, FL_Coord,
			       FL_COLOR, int, int, char *);

extern void fl_drw_text_cursor(int, FL_Coord, FL_Coord, FL_Coord, FL_Coord,
			       int, int, int, char *, int, int);

extern void fl_drw_box(int, FL_Coord, FL_Coord, FL_Coord, FL_Coord,
		       FL_COLOR, int);
extern FL_COLOR fl_get_flcolor(FL_COLOR);

typedef void (*FL_DRAWPTR) (FL_Coord x, FL_Coord y, FL_Coord w, FL_Coord h,
			    int, FL_COLOR);
extern int fl_add_symbol(const char *, FL_DRAWPTR, int);
extern int fl_draw_symbol(const char *, FL_Coord, FL_Coord, FL_Coord, FL_Coord,
			  FL_COLOR);
extern void fl_mapcolor(long, int, int, int);
extern void fl_getmcolor(long, int *, int *, int *);
extern void fl_color(FL_COLOR);
extern void fl_bk_color(FL_COLOR);
extern void fl_set_gamma(double, double, double);

extern void fl_show_errors(int);

/* Some macros */
#define FL_max(a,b)      ( (a) > (b) ? (a):(b) )
#define FL_min(a,b)      ( (a) < (b) ? (a):(b) )
#define FL_abs(a)        ( (a) > 0 ? (a):(-(a)))
#define FL_nint(a)       ( (a) > 0 ? ((a) + 0.5):((a) - 0.5))

typedef int (*FL_FSCB) (const char *);
extern FL_FSCB fl_set_fselect_cb(FL_FSCB);

/* utilities for new objects */
extern FL_FORM *fl_current_form;
extern void fl_add_object(FL_FORM *, FL_OBJECT *);
extern void fl_addto_form(FL_FORM *);
extern FL_OBJECT *fl_make_object(int, int, FL_Coord, FL_Coord,
			    FL_Coord, FL_Coord, const char *, FL_HANDLEPTR);

extern void fl_set_coordunit(int);
extern int fl_get_coordunit(void);

/* this gives more flexibility for future change */

#define fl_free       free
#define fl_malloc     malloc
#define fl_calloc     calloc
#define fl_realloc    realloc
#endif /* Basic.h *} */

/*
 * $Id: XBasic.h,v 0.61 1995/01/20 19:22:37 zhao Beta $
 *
 *  X Window dependent stuff
 *
 */

#ifndef FL_XBASIC_H
#define FL_XBASIC_H		/* { */

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xatom.h>
#include <X11/keysym.h>
#include <X11/Xresource.h>

#define FL_MINDEPTH  4

/* FL_xxx does not do anything anymore, but kept for compatibility */
enum
{
    FL_illegalVisual = -1,
    FL_StaticGray = StaticGray,
    FL_GrayScale = GrayScale,
    FL_StaticColor = StaticColor,
    FL_PseudoColor = PseudoColor,
    FL_TrueColor = TrueColor,
    FL_DirectColor = DirectColor,
    FL_DefaultVisual = 10	/* special request */
};

#ifndef GreyScale
#  define GreyScale   GrayScale
#  define StaticGrey  StaticGray
#endif

#define FL_is_gray(v)  (v==GrayScale || v==StaticGray)
#define FL_is_rgb(v)   (v==TrueColor || v==DirectColor)

#define FL_MAX_COLS   256	/* 8 bits worth */

/* XForms internal colormap */
typedef struct
{
    int index;
    const char *name;
    unsigned short r, g, b, a;
    int grayval;
} FL_IMAP;

/*
 * FL state information. Lots of it are redundant
 */

typedef struct
{
    XVisualInfo *xvinfo;
    XFontStruct *cur_fnt;	/* current font in default GC */
    Colormap colormap;
    Window trailblazer;
    GC gc[16];
    int vclass, depth;
    unsigned int rshift, rmask, rbits;
    unsigned int gshift, gmask, gbits;
    unsigned int bshift, bmask, bbits;
    unsigned lut[FL_MAX_COLS];
    int rgb_bits;
    int pcm;
} FL_State;

/***** Global variables ******/

extern Display *fl_display;
extern int fl_screen;
extern int fl_vmode;

/* current version only runs in single visual mode */
#define  fl_get_vclass()        fl_vmode
#define  fl_get_form_vclass(a)  fl_vmode

extern FL_State fl_state[];
extern char *fl_ul_magic_char;


/*
 * All pixmaps used by FL_OBJECT to simulate double buffering have the
 * following entries in the structure. FL_Coord x, y is used to shift
 * the origin of the drawing routines
 */
typedef struct
{
    Pixmap pixmap;
    Window win;
    Visual *visual;
    FL_Coord x, y;
    unsigned int w, h;
    int depth;
} FL_pixmap;


/* fonts related */

#define FL_MAX_FONTSIZES   10

typedef struct
{
    XFontStruct *fs[FL_MAX_FONTSIZES];	/* cached fontstruct */
    short size[FL_MAX_FONTSIZES];	/* cached sizes      */
    short nsize;		/* cached so far     */
    char fname[80];		/* without size info     */
} FL_FONT;

/*
 * Some basic drawing routines
 */

typedef XPoint FL_POINT;

/* rectangles */
extern void fl_rectangle(int, FL_Coord, FL_Coord, FL_Coord, FL_Coord, FL_COLOR);
extern void fl_rectbound(FL_Coord, FL_Coord, FL_Coord, FL_Coord, FL_COLOR);
#define fl_rectf(x,y,w,h,c)   fl_rectangle(1, x,y,w,h,c)
#define fl_rect(x,y,w,h,c)    fl_rectangle(0, x,y,w,h,c)

/* rectangle with rounded-corners */
extern void fl_roundrectangle(int, FL_Coord, FL_Coord, FL_Coord, FL_Coord, FL_COLOR);
#define fl_roundrectf(x,y,w,h,c) fl_roundrectangle(1,x,y,w,h,c)
#define fl_roundrect(x,y,w,h,c) fl_roundrectangle(0,x,y,w,h,c)

/* general polygon and polylines */
extern void fl_polygon(int, FL_POINT *, int n, FL_COLOR);
#define fl_polyf(p,n,c)  fl_polygon(1, p, n, c)
#define fl_polyl(p,n,c)  fl_polygon(0, p, n, c)

extern void fl_lines(FL_POINT *, int n, FL_COLOR);
extern void fl_simple_line(FL_Coord, FL_Coord, FL_Coord, FL_Coord, FL_COLOR);
#define fl_line(x,y,w,h,c) fl_simple_line(x,y,(x)+(w)-1,(y)+(h)-1,c)

/** ellipses **/
extern void fl_oval(int, FL_Coord, FL_Coord, FL_Coord, FL_Coord, FL_COLOR);
extern void fl_ovalbound(FL_Coord, FL_Coord, FL_Coord, FL_Coord, FL_COLOR);
#define fl_ovalf(x,y,w,h,c)     fl_oval(1,x,y,w,h,c)
#define fl_ovall(x,y,w,h,c)     fl_oval(0,x,y,w,h,c)
#define fl_oval_bound           fl_ovalbound

#define fl_circf(x,y,r,col)  fl_oval(1,(x)-(r),(y)-(r),2*(r),2*(r),col)
#define fl_circ(x,y,r,col)   fl_oval(0,(x)-(r),(y)-(r),2*(r),2*(r),col)

/* arcs */
extern void fl_pieslice(int, FL_Coord, FL_Coord, FL_Coord, FL_Coord,
			int, int, FL_COLOR);

#define fl_arcf(x,y,r,a1,a2,c)  fl_pieslice(1,(x)-(r),(y)-(r), (2*r),(2*r),\
                                            a1,a2,c)
#define fl_arc(x,y,r,a1,a2,c)  fl_pieslice(0,(x)-(r),(y)-(r), (2*r),(2*r),\
                                           a1,a2,c)

/* misc. stuff */
extern void fl_add_vertex(FL_Coord, FL_Coord);
extern void fl_add_float_vertex(float, float);
extern void fl_reset_vertex(void);
extern void fl_endline(void), fl_endpolygon(void), fl_endclosedline(void);

#define fl_bgnline       fl_reset_vertex
#define fl_bgnclosedline fl_reset_vertex
#define fl_bgnpolygon    fl_reset_vertex
#define fl_v2s(v)        fl_add_vertex(v[0], v[1])
#define fl_v2i(v)        fl_add_vertex(v[0], v[1])
#define fl_v2f(v)        fl_add_float_vertex(v[0], v[1])
#define fl_v2d(v)        fl_add_float_vertex(v[0], v[1])

/* high level drawing routines */
extern void fl_drw_box(int, FL_Coord, FL_Coord, FL_Coord, FL_Coord, FL_COLOR, int);
extern void fl_drw_checkbox(int, FL_Coord, FL_Coord, FL_Coord, FL_Coord,
			    FL_COLOR, int);


/*
 * Interfaces
 */
extern XFontStruct *fl_get_fntstruct(int, int);
extern Window fl_get_mouse(FL_Coord *, FL_Coord *, unsigned int *);
extern void fl_set_mouse(FL_Coord, FL_Coord);
extern Window fl_get_win_mouse(Window, FL_Coord *, FL_Coord *, unsigned *);
extern Window fl_get_form_mouse(FL_FORM *, FL_Coord *, FL_Coord *, unsigned *);
extern void fl_add_withdrawn_window(Window);
extern void fl_winset(Window);
extern FL_FORM *fl_win_to_form(Window);
extern Window fl_winget(void);

/* convenience functions */
extern void fl_get_win_origin(Window, FL_Coord *, FL_Coord *);
extern void fl_get_win_size(Window, FL_Coord *, FL_Coord *);
extern void fl_get_win_geometry(Window, FL_Coord *, FL_Coord *,
				FL_Coord *, FL_Coord *);

#define fl_get_display()           fl_display
#define FL_FormDisplay(form)       fl_display
#define FL_ObjectDisplay(object)   fl_display

/* the window an object belongs */
#if 0				/* canvas not functioning yet */
#define FL_ObjWin(o)   (o->form->objclass != FL_CANVAS ? \
                        o->form->window : fl_canvas_window(o))
#else
#define FL_ObjWin(o)  (o->form->window )
#endif

#define FL_OBJECT_WID  FL_ObjWin

extern Display *fl_init(void);


/*  all registerable events */
#define FL_ALL_EVENT  (KeyPressMask|KeyReleaseMask|      \
                      ButtonPressMask|ButtonReleaseMask|\
                      EnterWindowMask|LeaveWindowMask|    \
                      ButtonMotionMask|PointerMotionMask)

/* Timer related */

#define FL_TIMER_EVENT 0x40000000L


extern int fl_XNextEvent(XEvent *);
extern int fl_XPeekEvent(XEvent *);
extern int fl_XEventsQueued(int);
extern void fl_XPutBackEvent(XEvent *);

typedef int (*FL_APPEVENT_CB) (XEvent *, void *);
extern FL_APPEVENT_CB fl_set_event_callback(FL_APPEVENT_CB, void *);
extern FL_APPEVENT_CB fl_set_idle_callback(FL_APPEVENT_CB, void *);
extern void fl_handle_idle_callback(XEvent *);

typedef struct
{
    Window win;
    FL_APPEVENT_CB callback[LASTEvent];
    void *user_data[LASTEvent];
    FL_APPEVENT_CB default_callback;
    unsigned long mask;
} FL_WIN;

/*
 * Group some WM stuff into a structure for easy maintainance
 */
enum
{
    FL_WM_SHIFT = 1,
    FL_WM_NORMAL = 2
};

typedef struct
{
    int rpx, rpy;		/* reparenting offset for full border */
    int trpx, trpy;		/* reparenting offset for transient   */
    int bw;			/* additional border                  */
    int rep_method;		/* 1 for shifting, 2 for normal       */
    unsigned pos_request;	/* USPOSITION or PPOSITION            */
} FL_WM_STUFF;

extern void fl_init_callbacks(void);
extern FL_APPEVENT_CB fl_add_event_callback(Window, int,
					    FL_APPEVENT_CB, void *);

extern void fl_remove_event_callback(Window, int, FL_APPEVENT_CB, void *);
extern void fl_activate_event_callbacks(Window);
extern int fl_handle_event_callbacks(XEvent * xev);

extern XEvent *fl_print_xevent_name(const char *, const XEvent *);


#define metakey_down(mask)     ((mask) & Mod1Mask)
#define shiftkey_down(mask)    ((mask) & ShiftMask)
#define controlkey_down(mask)  ((mask) & ControlMask)
#define button_down(mask)      (((mask) & Button1Mask) || \
                               ((mask) & Button2Mask) || \
			       ((mask) & Button3Mask))
#define fl_keypressed          fl_keysym_pressed

/****************** Resources ***************/

/* bool is int */
typedef enum
{
    FL_SHORT = 10, FL_BOOL, FL_INT, FL_LONG, FL_FLOAT, FL_STRING
} FL_RTYPE;

typedef struct
{
    const char *res_name;	/* resource name                        */
    const char *res_class;	/* resource class                       */
    FL_RTYPE type;		/* FL_INT, FL_FLOAT, FL_BOOL,FL_STRING  */
    void *var;			/* address for the variable             */
    const char *defval;		/* default setting in string form       */
    int nbytes;			/* used only for strings                */
} FL_resource;

#define FL_CMD_OPT   XrmOptionDescRec

extern Display *fl_initialize(const char *, const char *,
			      FL_CMD_OPT *, int, int *, char *[]);
extern char *fl_get_resource(const char *, const char *,
			     FL_RTYPE, const char *, void *, int);
extern void fl_get_app_resources(FL_resource *, int n);
extern void fl_set_graphics_mode(int, int);
extern void fl_set_preferred_depth(int);
extern int fl_keysym_pressed(KeySym);
extern int fl_keycodem_pressed(KeyCode);

/* All Form control variables. Named closely as its resource name */
typedef struct
{
    float rgamma, ggamma, bgamma;
    int debug, sync;
    int depth, vclass, doubleBuffer;
    int ulPropWidth, ulThickness;	/* underline stuff       */
    int buttonLabelSize;
    int sliderLabelSize;
    int inputLabelSize;
    int pupFontSize, pupFontStyle;	/* font for pop-up menus */
    int privateColormap;
    int leftScrollBar;
    int backingStore;
    int eraseChar;		/* delete front */
    int deleteChar;		/* delete after */
    int weraseChar;		/* delete word  */
    int killChar;		/* kill line    */
    int coordUnit;
    char *rgbfile;		/* where RGB file is     */
    char vname[24];
} FL_IOPT;

#define FL_SBIT(n)   (1<<(n))

/* program default masks */
enum
{
    FL_PDDepth = FL_SBIT(1),
    FL_PDClass = FL_SBIT(2),
    FL_PDDouble = FL_SBIT(3),
    FL_PDSync = FL_SBIT(4),
    FL_PDPrivateMap = FL_SBIT(5),
    FL_PDLeftScrollBar = FL_SBIT(6),
    FL_PDPupFontSize = FL_SBIT(7),
    FL_PDButtonLabelSize = FL_SBIT(8),
    FL_PDInputLabelSize = FL_SBIT(9),
    FL_PDSliderLabelSize = FL_SBIT(10),
    FL_PDVisual = FL_SBIT(11),
    FL_PDULThickness = FL_SBIT(12),
    FL_PDULPropWidth = FL_SBIT(13),
    FL_PDBS = FL_SBIT(14),
    FL_PDCoordUnit = FL_SBIT(15),
    FL_PDDebug = FL_SBIT(16)
};

#define FL_PDButtonLabel   FL_PDButtonLabelSize

extern void fl_set_defaults(unsigned long, FL_IOPT *);
extern void fl_get_defaults(FL_IOPT *);
extern int fl_get_visual_depth(void);
extern Window fl_create_window(Colormap, char *);
extern const char *fl_vclass_name(int);
extern int fl_vclass_val(const char *);
extern void fl_set_ul_property(int, int);
extern void fl_set_clipping(FL_Coord, FL_Coord, FL_Coord, FL_Coord);
extern void fl_set_gc_clipping(GC, FL_Coord, FL_Coord, FL_Coord, FL_Coord);
extern void fl_set_clippings(XRectangle *, int);
extern void fl_unset_clipping(void);
#endif /* XBasic.h *} */

/*
 * $Id: bitmap.h,v 0.61 1995/01/20 19:22:37 zhao Beta $
 *
 *   Object Class: Bitmap
 */
#ifndef FL_BITMAP_H
#define FL_BITMAP_H		/* { */

#define    FL_NORMAL_BITMAP      0

/***** Defaults *****/

#define FL_BITMAP_BOXTYPE	FL_NO_BOX
#define FL_BITMAP_COL1		FL_BLACK
#define FL_BITMAP_COL2		FL_COL1
#define FL_BITMAP_LCOL		FL_LCOL
#define FL_BITMAP_ALIGN		FL_ALIGN_BOTTOM

/***** Others   *****/

#define FL_BITMAP_MAXSIZE	(128*128)
#define FL_BITMAP_BW		FL_BOUND_WIDTH

/***** Routines *****/
extern FL_OBJECT *fl_create_bitmap(int, FL_Coord, FL_Coord, FL_Coord, FL_Coord,
				   const char *);
extern FL_OBJECT *fl_add_bitmap(int, FL_Coord, FL_Coord, FL_Coord, FL_Coord, const char *);
extern void fl_set_bitmap_data(FL_OBJECT *, int, int, unsigned char *);
extern void fl_set_bitmap_file(FL_OBJECT *, const char *);


/* PIXMAP stuff */

#define FL_NORMAL_PIXMAP   0

extern FL_OBJECT *fl_create_pixmap(int, FL_Coord, FL_Coord, FL_Coord, FL_Coord,
				   const char *);
extern FL_OBJECT *fl_add_pixmap(int, FL_Coord, FL_Coord, FL_Coord, FL_Coord,
				const char *);
extern void fl_set_pixmap_data(FL_OBJECT *, int, int, char **);
extern void fl_set_pixmap_file(FL_OBJECT *, const char *);
#endif /* BITMAP_H  } */

/*
 * $Id: box.h,v 0.10 1994/09/10 07:17:38 zhao Exp $
 *
 */
#ifndef FL_BOX_H
#define FL_BOX_H		/* { */

/* type already defined in Basic.h */

#define FL_BOX_BW    FL_BOUND_WIDTH

extern FL_OBJECT *fl_create_box(int, FL_Coord, FL_Coord, FL_Coord, FL_Coord,
                  const char *);

extern FL_OBJECT *fl_add_box(int,FL_Coord,FL_Coord,FL_Coord,FL_Coord, const char *);
#endif /* !def TEXT_H } */

/*
 * $Id: browser.h,v 0.61 1995/01/20 19:22:37 zhao Beta $
 *
 *  Object class Browser
 */
#ifndef FL_BROWSER_H
#define FL_BROWSER_H		/* { */

/***** Types    *****/
typedef enum
{
    FL_NORMAL_BROWSER,
    FL_SELECT_BROWSER,
    FL_HOLD_BROWSER,
    FL_MULTI_BROWSER
} FL_BROWSER_TYPE;

/***** Defaults *****/

#define FL_BROWSER_BOXTYPE	FL_DOWN_BOX
#define FL_BROWSER_COL1		FL_COL1
#define FL_BROWSER_COL2		FL_YELLOW
#define FL_BROWSER_LCOL		FL_LCOL
#define FL_BROWSER_ALIGN	FL_ALIGN_BOTTOM

/***** Others   *****/

#define FL_BROWSER_SLCOL	FL_COL1
#define FL_BROWSER_BW		FL_BOUND_WIDTH
#define FL_BROWSER_LINELENGTH	128
#define FL_BROWSER_MAXLINE	4096
#define FL_BROWSER_FONTSIZE     FL_SMALL_FONT

/***** Routines *****/

extern FL_OBJECT *fl_create_browser(int, FL_Coord, FL_Coord, FL_Coord,
				    FL_Coord, const char *);
extern FL_OBJECT *fl_add_browser(int, FL_Coord, FL_Coord, FL_Coord,
				 FL_Coord, const char *);
extern void fl_clear_browser(FL_OBJECT *);
extern void fl_add_browser_line(FL_OBJECT *, const char *);
extern void fl_addto_browser(FL_OBJECT *, const char *);
extern void fl_insert_browser_line(FL_OBJECT *, int, const char *);
extern void fl_delete_browser_line(FL_OBJECT *, int);
extern void fl_replace_browser_line(FL_OBJECT *, int, const char *);
extern const char *fl_get_browser_line(FL_OBJECT *, int);
extern int fl_load_browser(FL_OBJECT *, const char *);

extern void fl_select_browser_line(FL_OBJECT *, int);
extern void fl_deselect_browser_line(FL_OBJECT *, int);
extern void fl_deselect_browser(FL_OBJECT *);
extern int fl_isselected_browser_line(FL_OBJECT *, int);

extern int fl_get_browser_topline(FL_OBJECT *);
extern int fl_get_browser(FL_OBJECT *);
extern int fl_get_browser_maxline(FL_OBJECT *);

extern void fl_set_browser_topline(FL_OBJECT *, int);
extern void fl_set_browser_fontsize(FL_OBJECT *, int);
extern void fl_set_browser_fontstyle(FL_OBJECT *, int);
extern void fl_set_browser_specialkey(FL_OBJECT *, int);
extern void fl_set_browser_leftslider(FL_OBJECT *, int);
#endif /* BROWSER_H } */

/*
 * $Id: button.h,v 0.61 1995/01/20 19:22:37 zhao Beta $
 *
 * All Buttons: regular button, light button and round button
 *
 */

#ifndef FL_BUTTON_H
#define FL_BUTTON_H		/* { */

typedef enum
{
    FL_NORMAL_BUTTON,
    FL_PUSH_BUTTON,
    FL_RADIO_BUTTON,
    FL_HIDDEN_BUTTON,
    FL_TOUCH_BUTTON,
    FL_INOUT_BUTTON,
    FL_RETURN_BUTTON,
    FL_HIDDEN_RET_BUTTON
} FL_BUTTON_TYPE;

typedef struct
{
    Pixmap pixmap;
    unsigned bits_w, bits_h;
    int val;			/* whether on */
    int mousebut;		/* mouse button that caused the push     */
    int timdel;			/* time since last touch (TOUCH buttons) */
    int event;			/* what event triggers redraw            */
    int cspec;			/* reserved for class specfic stuff      */
} FL_BUTTON_STRUCT;

typedef void (*DrawButton) (FL_OBJECT *);

/*
 *  normal button default
 */
#define FL_BUTTON_BOXTYPE	FL_UP_BOX
#define FL_BUTTON_COL1		FL_COL1
#define FL_BUTTON_COL2		FL_COL1
#define FL_BUTTON_LCOL		FL_LCOL
#define FL_BUTTON_ALIGN		FL_ALIGN_CENTER

#define FL_BUTTON_MCOL1		FL_MCOL
#define FL_BUTTON_MCOL2		FL_MCOL
#define FL_BUTTON_BW		FL_BOUND_WIDTH

/*
 *  light button defaults
 */
#define FL_LIGHTBUTTON_BOXTYPE	FL_UP_BOX
#define FL_LIGHTBUTTON_COL1	FL_COL1
#define FL_LIGHTBUTTON_COL2	FL_YELLOW
#define FL_LIGHTBUTTON_LCOL	FL_LCOL
#define FL_LIGHTBUTTON_ALIGN	FL_ALIGN_CENTER

/***** Others   *****/

#define FL_LIGHTBUTTON_TOPCOL	FL_COL1
#define FL_LIGHTBUTTON_MCOL	FL_MCOL
#define FL_LIGHTBUTTON_BW1	FL_BUTTON_BW
#define FL_LIGHTBUTTON_BW2	(FL_Coord)2
#define FL_LIGHTBUTTON_MINSIZE	(FL_Coord)12

/** round button defaults ***/

#define FL_ROUNDBUTTON_BOXTYPE	FL_NO_BOX
#define FL_ROUNDBUTTON_COL1	FL_MCOL
#define FL_ROUNDBUTTON_COL2	FL_YELLOW
#define FL_ROUNDBUTTON_LCOL	FL_LCOL
#define FL_ROUNDBUTTON_ALIGN	FL_ALIGN_CENTER

#define FL_ROUNDBUTTON_TOPCOL	FL_COL1
#define FL_ROUNDBUTTON_MCOL	FL_MCOL
#define FL_ROUNDBUTTON_BW	FL_BUTTON_BW

/** check button defaults ***/

#define FL_CHECKBUTTON_BOXTYPE	FL_NO_BOX
#define FL_CHECKBUTTON_COL1	FL_COL1
#define FL_CHECKBUTTON_COL2	FL_YELLOW
#define FL_CHECKBUTTON_LCOL	FL_LCOL
#define FL_CHECKBUTTON_ALIGN	FL_ALIGN_CENTER

#define FL_CHECKBUTTON_TOPCOL	FL_COL1
#define FL_CHECKBUTTON_MCOL	FL_MCOL
#define FL_CHECKBUTTON_BW	FL_BUTTON_BW

/** bitmap button defaults **/
#define FL_BITMAPBUTTON_BOXTYPE	FL_UP_BOX
#define FL_BITMAPBUTTON_COL1	FL_COL1	/* box col    */
#define FL_BITMAPBUTTON_COL2	FL_BLACK	/* bitmap col */
#define FL_BITMAPBUTTON_LCOL	FL_LCOL
#define FL_BITMAPBUTTON_ALIGN	FL_ALIGN_BOTTOM
#define FL_BITMAPBUTTON_BW	FL_BUTTON_BW

/** bitmap button defaults **/
#define FL_PIXMAPBUTTON_BOXTYPE	FL_UP_BOX
#define FL_PIXMAPBUTTON_COL1	FL_COL1	/* box col    */
#define FL_PIXMAPBUTTON_COL2	FL_YELLOW	/* bound rect */
#define FL_PIXMAPBUTTON_LCOL	FL_LCOL
#define FL_PIXMAPBUTTON_ALIGN	FL_ALIGN_BOTTOM
#define FL_PIXMAPBUTTON_BW	FL_BUTTON_BW

/***** Routines *****/

extern FL_OBJECT *fl_create_button(int, FL_Coord, FL_Coord, FL_Coord, FL_Coord,
				   const char *);
extern FL_OBJECT *fl_create_roundbutton(int, FL_Coord, FL_Coord, FL_Coord,
					FL_Coord, const char *);
extern FL_OBJECT *fl_create_lightbutton(int, FL_Coord, FL_Coord, FL_Coord,
					FL_Coord, const char *);
extern FL_OBJECT *fl_create_checkbutton(int, FL_Coord, FL_Coord, FL_Coord,
					FL_Coord, const char *);
extern FL_OBJECT *fl_create_bitmapbutton(int, FL_Coord, FL_Coord, FL_Coord,
					 FL_Coord, const char *);
extern FL_OBJECT *fl_create_pixmapbutton(int, FL_Coord, FL_Coord, FL_Coord,
					 FL_Coord, const char *);

extern FL_OBJECT *fl_add_roundbutton(int, FL_Coord, FL_Coord,
				     FL_Coord, FL_Coord, const char *);
extern FL_OBJECT *fl_add_lightbutton(int, FL_Coord, FL_Coord,
				     FL_Coord, FL_Coord, const char *);
extern FL_OBJECT *fl_add_checkbutton(int, FL_Coord, FL_Coord,
				     FL_Coord, FL_Coord, const char *);
extern FL_OBJECT *fl_add_button(int, FL_Coord, FL_Coord, FL_Coord,
				FL_Coord, const char *);

extern FL_OBJECT *fl_add_bitmapbutton(int, FL_Coord, FL_Coord, FL_Coord,
				      FL_Coord, const char *);
extern void fl_set_bitmapbutton_data(FL_OBJECT *, int, int, unsigned char *);
extern void fl_set_bitmapbutton_datafile(FL_OBJECT *, const char *);

# define fl_set_pixmapbutton_datafile  fl_set_pixmapbutton_file
extern FL_OBJECT *fl_add_pixmapbutton(int, FL_Coord, FL_Coord, FL_Coord,
				      FL_Coord, const char *);
extern void fl_set_pixmapbutton_data(FL_OBJECT *, char **);
extern void fl_set_pixmapbutton_file(FL_OBJECT *, const char *);

extern int fl_get_button(FL_OBJECT *);
extern void fl_set_button(FL_OBJECT *, int);
extern int fl_get_button_numb(FL_OBJECT *);

#define fl_set_button_shortcut  fl_set_object_shortcut

extern FL_OBJECT *fl_create_generic_button(int, int, FL_Coord, FL_Coord,
					   FL_Coord, FL_Coord, const char *);
extern void fl_add_button_class(int, DrawButton);
#endif /* Button.h  } */

/*
 * $Id: chart.h,v 0.61 1995/01/20 19:22:37 zhao Beta $
 *
 * Object Class: Chart
 *
 */
#ifndef FL_CHART_H
#define FL_CHART_H		/* { */

typedef enum
{
    FL_BAR_CHART,
    FL_HORBAR_CHART,
    FL_LINE_CHART,
    FL_FILLED_CHART,
    FL_SPIKE_CHART,
    FL_PIE_CHART,
    FL_SPECIALPIE_CHART
} FL_CHART_TYPE;

/***** Defaults *****/

#define FL_CHART_BOXTYPE	FL_BORDER_BOX
#define FL_CHART_COL1		FL_COL1
#define FL_CHART_LCOL		FL_LCOL
#define FL_CHART_ALIGN		FL_ALIGN_BOTTOM

/***** Others   *****/

#define FL_CHART_BW		FL_BOUND_WIDTH
#define FL_CHART_MAX		256

/***** Routines *****/

extern FL_OBJECT *fl_create_chart(int, FL_Coord, FL_Coord, FL_Coord, FL_Coord,
				  const char *);
extern FL_OBJECT *fl_add_chart(int, FL_Coord, FL_Coord, FL_Coord, FL_Coord,
			       const char *);

extern void fl_clear_chart(FL_OBJECT *);
extern void fl_add_chart_value(FL_OBJECT *, double, char[], int);
extern void fl_insert_chart_value(FL_OBJECT *, int, double, char[], int);
extern void fl_replace_chart_value(FL_OBJECT *, int, double, char[], int);
extern void fl_set_chart_bounds(FL_OBJECT *, double, double);
extern void fl_set_chart_maxnumb(FL_OBJECT *, int);
extern void fl_set_chart_autosize(FL_OBJECT *, int);
#endif /* !def CHART_H } */

/*
 * $Id: choice.h,v 0.61 1995/01/20 19:22:37 zhao Beta $
 *
 */
#ifndef FL_CHOICE_H
#define FL_CHOICE_H		/* { */

typedef enum
{
    FL_NORMAL_CHOICE,
    FL_DROPLIST_CHOICE
} FL_CHOICE_TYPE;

#define  FL_SIMPLE_CHOICE  FL_NORMAL_CHOICE

/***** Defaults *****/

#define FL_CHOICE_BOXTYPE	FL_ROUNDED_BOX
#define FL_CHOICE_COL1		FL_COL1
#define FL_CHOICE_COL2		FL_LCOL
#define FL_CHOICE_LCOL		FL_LCOL
#define FL_CHOICE_ALIGN		FL_ALIGN_LEFT

/***** Others   *****/

#define FL_CHOICE_BW		FL_BOUND_WIDTH
#define FL_CHOICE_MCOL		FL_MCOL
#define FL_CHOICE_MAXITEMS	63
#define FL_CHOICE_MAXSTR	32

/***** Routines *****/

extern FL_OBJECT *fl_create_choice(int, FL_Coord, FL_Coord, FL_Coord, FL_Coord,
				   const char *);

extern FL_OBJECT *fl_add_choice(int, FL_Coord, FL_Coord, FL_Coord, FL_Coord, const char *);
extern void fl_clear_choice(FL_OBJECT *);
extern void fl_addto_choice(FL_OBJECT *, const char *);
extern void fl_replace_choice(FL_OBJECT *, int, const char *);
extern void fl_delete_choice(FL_OBJECT *, int);
extern void fl_set_choice(FL_OBJECT *, int);
extern int fl_get_choice(FL_OBJECT *);
extern char *fl_get_choice_text(FL_OBJECT *);
extern void fl_set_choice_fontsize(FL_OBJECT *, int);
extern void fl_set_choice_fontstyle(FL_OBJECT *, int);
extern void fl_set_choice_item_mode(FL_OBJECT *, int, unsigned);
extern void fl_set_choice_item_shortcut(FL_OBJECT *, int, const char *);
#endif /* !def CHOICE_H } */

/*
 * $Id: clock.h,v 0.61 1995/01/20 19:22:37 zhao Beta $
 *
 */
#ifndef FL_CLOCK_H
#define FL_CLOCK_H		/* { */

enum
{
    FL_ANALOG_CLOCK,
    FL_DIGITAL_CLOCK
};

#define FL_CLOCK_BOXTYPE   FL_UP_BOX
#define FL_CLOCK_COL1   FL_INACTIVE_COL
#define FL_CLOCK_COL2   FL_BOTTOM_BCOL
#define FL_CLOCK_LCOL   FL_BLACK
#define FL_CLOCK_ALIGN  FL_ALIGN_BOTTOM

#define FL_CLOCK_TOPCOL  FL_COL1
#define FL_CLOCK_BW      FL_BOUND_WIDTH

extern FL_OBJECT *fl_create_clock(int, FL_Coord, FL_Coord, FL_Coord, FL_Coord,
				  const char *);

FL_OBJECT *fl_add_clock(int, FL_Coord, FL_Coord, FL_Coord, FL_Coord, const char *);
extern void fl_get_clock(FL_OBJECT *, int *, int *, int *);
#endif /* !def CLOCK_H } */

/*
 * $Id: counter.h,v 0.61 1995/01/20 19:22:37 zhao Beta $
 *
 */

#ifndef FL_COUNTER_H
#define FL_COUNTER_H		/* { */

/***** Types    *****/

typedef enum
{
    FL_NORMAL_COUNTER,
    FL_SIMPLE_COUNTER
} FL_COUNTER_TYPE;

/***** Defaults *****/

#define FL_COUNTER_BOXTYPE	FL_UP_BOX
#define FL_COUNTER_COL1		FL_COL1
#define FL_COUNTER_COL2		FL_BLUE	/* ct label     */
#define FL_COUNTER_LCOL		FL_LCOL	/* ct reporting */
#define FL_COUNTER_ALIGN	FL_ALIGN_BOTTOM

/***** Others   *****/

#define FL_COUNTER_BW		(FL_BOUND_WIDTH-1)

/***** Routines *****/
extern FL_OBJECT *fl_create_counter(int, FL_Coord, FL_Coord, FL_Coord,
				    FL_Coord, const char *);

extern FL_OBJECT *fl_add_counter(int, FL_Coord, FL_Coord, FL_Coord, FL_Coord,
				 const char *);

extern void fl_set_counter_value(FL_OBJECT *, double);
extern void fl_set_counter_bounds(FL_OBJECT *, double, double);
extern void fl_set_counter_step(FL_OBJECT *, double, double);
extern void fl_set_counter_precision(FL_OBJECT *, int);
extern double fl_get_counter_value(FL_OBJECT *);
extern void fl_set_counter_return(FL_OBJECT *, int);
#endif /* !def  COUNTER_H } */

/*
 * $Id: cursor.h,v 0.61 1995/01/20 19:22:37 zhao Beta $
 *
 * Cursor defs and prototypes
 *
 */

#ifndef FL_CURSOR_H
#define FL_CURSOR_H		/* { */

#include <X11/cursorfont.h>

extern void fl_init_cursors(void);
extern void fl_set_cursor(Window, int);
extern void fl_reset_cursor(Window);
extern Cursor fl_get_cursor_byname(int);
#endif /* cursor.h   *} */

/*
 * $Id: dial.h,v 0.61 1995/01/20 19:22:37 zhao Beta $
 */
#ifndef FL_DIAL_H
#define FL_DIAL_H		/* { */

typedef enum
{
    FL_NORMAL_DIAL,
    FL_LINE_DIAL
} FL_DIAL_TYPE;

/***** Defaults *****/

#define FL_DIAL_BOXTYPE		FL_NO_BOX
#define FL_DIAL_COL1		FL_COL1
#define FL_DIAL_COL2		FL_RIGHT_BCOL
#define FL_DIAL_LCOL		FL_LCOL
#define FL_DIAL_ALIGN		FL_ALIGN_BOTTOM

/***** Others   *****/

#define FL_DIAL_TOPCOL		FL_COL1
#define FL_DIAL_BW		FL_BOUND_WIDTH

/***** Routines *****/

extern FL_OBJECT *fl_create_dial(int, FL_Coord, FL_Coord, FL_Coord, FL_Coord,
				 const char *);
extern FL_OBJECT *fl_add_dial(int, FL_Coord, FL_Coord, FL_Coord, FL_Coord,
			      const char *);

extern void fl_set_dial_value(FL_OBJECT *, double);
extern double fl_get_dial_value(FL_OBJECT *);
extern void fl_set_dial_bounds(FL_OBJECT *, double, double);
extern void fl_get_dial_bounds(FL_OBJECT *, double *, double *);

extern void fl_set_dial_step(FL_OBJECT *, double);
extern void fl_set_dial_return(FL_OBJECT *, int);
#endif /* !def DIAL_H } */

/*
 * $Id: free.h,v 0.61 1995/01/20 19:22:37 zhao Beta $
 *
 *  Object Class: Free
 */
#ifndef FL_FREE_H
#define FL_FREE_H		/* { */

typedef enum
{
    FL_NORMAL_FREE,
    FL_INACTIVE_FREE,
    FL_INPUT_FREE,
    FL_CONTINUOUS_FREE,
    FL_ALL_FREE
} FL_FREE_TYPE;

#define FL_SLEEPING_FREE  FL_INACTIVE_FREE

extern FL_OBJECT *fl_create_free(int, FL_Coord, FL_Coord, FL_Coord, FL_Coord,
				 const char *, FL_HANDLEPTR);
extern FL_OBJECT *fl_add_free(int, FL_Coord, FL_Coord, FL_Coord, FL_Coord,
			      const char *, FL_HANDLEPTR);
#endif /* !def FREE_H } */

/*
 * $Id: goodies.h,v 0.61 1995/01/20 19:22:37 zhao Beta $
 */
#ifndef FL_GOODIES_H
#define FL_GOODIES_H		/* { */

/* from goodies.c */
extern void fl_show_message(const char *, const char *, const char *);
extern void fl_show_alert(const char *, const char *, const char *, int);
extern int fl_show_question(const char *, const char *, const char *);
extern const char *fl_show_input(const char *, const char *);
extern int fl_show_colormap(int);
extern int fl_show_choice(const char *, const char *, const char *, int,
			  const char *, const char *, const char *);
extern void fl_set_choices_shortcut(const char *, const char *, const char
				    *);

/******* from file selector *****************/

extern const char *fl_show_fselector(const char *, const char *,
				     const char *, const char *);
extern void fl_set_fselector_placement(int);
extern void fl_set_fselector_callback(int (*)(const char *));
extern const char *fl_get_directory(void);
extern const char *fl_get_pattern(void);
extern const char *fl_get_filename(void);
extern void fl_refresh_fselector(void);
extern void fl_add_fselector_appbutton(const char *, void (*)(void));
extern void fl_disable_fselector_cache(int);
extern void fl_invalidate_fselector_cache(void);

#define fl_show_file_selector   fl_show_fselector
#define fl_set_fselector_cb     fl_set_fselector_callback
#endif /* } */

/*
 * $Id: input.h,v 0.61 1995/01/20 19:22:37 zhao Beta $
 *
 */
#ifndef FL_INPUT_H
#define FL_INPUT_H		/* { */

/***** Types    *****/

typedef enum
{
    FL_NORMAL_INPUT,
    FL_FLOAT_INPUT,
    FL_INT_INPUT,
    FL_HIDDEN_INPUT,
    FL_MULTILINE_INPUT,
    FL_SECRET_INPUT
} FL_INPUT_TYPE;

/***** Defaults *****/

#define FL_INPUT_BOXTYPE	FL_DOWN_BOX
#define FL_INPUT_COL1		FL_COL1
#define FL_INPUT_COL2		FL_MCOL
#define FL_INPUT_LCOL		FL_LCOL
#define FL_INPUT_ALIGN		FL_ALIGN_LEFT

/***** Others   *****/

#define FL_INPUT_TCOL		FL_LCOL
#define FL_INPUT_CCOL		FL_BLUE
#define FL_INPUT_BW		2

/***** Routines *****/

extern FL_OBJECT *fl_create_input(int, FL_Coord, FL_Coord, FL_Coord, FL_Coord,
				  const char *);

extern FL_OBJECT *fl_add_input(int, FL_Coord, FL_Coord, FL_Coord, FL_Coord, const char *);

extern void fl_set_input(FL_OBJECT *, const char *);
extern void fl_set_input_color(FL_OBJECT *, int, int);
extern const char *fl_get_input(FL_OBJECT *);
extern void fl_set_input_return(FL_OBJECT *, int);

#define fl_set_input_shortcut fl_set_object_shortcut
#define ringbell()  XBell(fl_display, 0)
#endif /* Input_H  } */

/*
 * $Id: menu.h,v 0.61 1995/01/20 19:22:37 zhao Beta $
 *
 */
#ifndef FL_MENU_H
#define FL_MENU_H		/* { */

/************   Object Class: Menu         ************/

typedef enum
{
    FL_TOUCH_MENU,
    FL_PUSH_MENU,
    FL_PULLDOWN_MENU
} FL_MENU_TYPE;

/***** Defaults *****/

#define FL_MENU_BOXTYPE		FL_BORDER_BOX
#define FL_MENU_COL1		FL_COL1
#define FL_MENU_COL2		FL_MCOL
#define FL_MENU_LCOL		FL_LCOL
#define FL_MENU_ALIGN		FL_ALIGN_CENTER

/***** Others   *****/

#define FL_MENU_BW		FL_BOUND_WIDTH
#define FL_MENU_MAXITEMS	128
#define FL_MENU_MAXSTR		64

/***** Routines *****/

extern FL_OBJECT *fl_create_menu(int, FL_Coord, FL_Coord, FL_Coord, FL_Coord,
				 const char *);

extern FL_OBJECT *fl_add_menu(int, FL_Coord, FL_Coord, FL_Coord, FL_Coord,
			      const char *);

extern void fl_clear_menu(FL_OBJECT *);
extern void fl_set_menu(FL_OBJECT *, char[]);
extern void fl_addto_menu(FL_OBJECT *, char[]);
extern void fl_replace_menu_item(FL_OBJECT *, int, char[]);
extern void fl_delete_menu_item(FL_OBJECT *, int);

extern void fl_set_menu_item_shortcut(FL_OBJECT *, int, char[]);
extern void fl_set_menu_item_mode(FL_OBJECT *, int, unsigned);
extern void fl_show_menu_symbol(FL_OBJECT *, int);

extern int fl_get_menu(FL_OBJECT *);
extern char *fl_get_menu_text(FL_OBJECT *);
#endif /* MENU } */

/*
 *  $Id: pattern.h,v 0.61 1995/01/20 19:22:37 zhao Beta $
 *
 */
/*
 * $Id: popup.h,v 0.61 1995/01/20 19:22:37 zhao Beta $
 *
 *  Prototypes for pop-up menus
 */

#ifndef FL_POPUP_H
#define FL_POPUP_H		/* { */

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xatom.h>

#define FL_MAXPUP     10	/* max pups to keep   */
#define FL_MAXPUPI    32	/* max item each pup  */

typedef int (*FL_PUP_CB) (int);	/* call back prototype  */

extern int fl_newpup(Window);
extern int fl_defpup(Window, const char *,...);
extern int fl_addtopup(int, const char *,...);
extern int fl_setpup(int, int, unsigned);
extern void fl_freepup(int);
extern int fl_dopup(int);

extern void fl_setpup_shortcut(int, int, const char *);
extern void fl_setpup_position(int, int);
extern void fl_setpup_selection(int, int);
extern void fl_setpup_fontsize(int);
extern void fl_setpup_fontstyle(int);
extern void fl_setpup_shadow(int, int);
extern void fl_setpup_title(int, const char *);

#define fl_setpup_hotkey    fl_setpup_shortcut

extern FL_PUP_CB fl_setpup_itemcb(int, int, FL_PUP_CB);
extern FL_PUP_CB fl_setpup_menucb(int, int, FL_PUP_CB);
extern void fl_setpup_submenu(int, int, int);

#define fl_setpup_mode    fl_setpup
#endif /* Xpopup } */

/*
 * $Id: positioner.h,v 0.61 1995/01/20 19:22:37 zhao Beta $
 *
 */
#ifndef FL_POSITIONER_H
#define FL_POSITIONER_H		/* { */

/************   Object Class: Positioner   ************/

#define FL_NORMAL_POSITIONER	0

/***** Defaults *****/

#define FL_POSITIONER_BOXTYPE	FL_DOWN_BOX
#define FL_POSITIONER_COL1	FL_COL1
#define FL_POSITIONER_COL2	FL_RED
#define FL_POSITIONER_LCOL	FL_LCOL
#define FL_POSITIONER_ALIGN	FL_ALIGN_BOTTOM

/***** Others   *****/

#define FL_POSITIONER_BW	FL_BOUND_WIDTH

/***** Routines *****/

extern FL_OBJECT *fl_create_positioner(int, FL_Coord, FL_Coord, FL_Coord,
				       FL_Coord, const char *);

extern FL_OBJECT *fl_add_positioner(int, FL_Coord, FL_Coord, FL_Coord,
				    FL_Coord, const char *);

extern void fl_set_positioner_xvalue(FL_OBJECT *, double);
extern double fl_get_positioner_xvalue(FL_OBJECT *);
extern void fl_set_positioner_xbounds(FL_OBJECT *, double, double);
extern void fl_get_positioner_xbounds(FL_OBJECT *, double *, double *);
extern void fl_set_positioner_yvalue(FL_OBJECT *, double);
extern double fl_get_positioner_yvalue(FL_OBJECT *);
extern void fl_set_positioner_ybounds(FL_OBJECT *, double, double);
extern void fl_get_positioner_ybounds(FL_OBJECT *, double *, double *);
extern void fl_set_positioner_xstep(FL_OBJECT *, double);
extern void fl_set_positioner_ystep(FL_OBJECT *, double);
extern void fl_set_positioner_return(FL_OBJECT *, int);
#endif /* Positioner.H } */

/*
 * $Id: slider.h,v 0.61 1995/01/20 19:22:37 zhao Beta $
 *
 * Object Class: Slider
 *
 */
#ifndef FL_SLIDER_H
#define FL_SLIDER_H		/* { */

/***** Types    *****/

typedef enum
{
    FL_VERT_SLIDER,
    FL_HOR_SLIDER,
    FL_VERT_FILL_SLIDER,
    FL_HOR_FILL_SLIDER,
    FL_VERT_NICE_SLIDER,
    FL_HOR_NICE_SLIDER,
    FL_BROWSER_SLIDER,		/* for internal use only */
    FL_BROWSER_SLIDER2		/* for internal use only */
} FL_SLIDER_TYPE;


/***** Defaults *****/

#define FL_SLIDER_BOXTYPE	FL_DOWN_BOX
#define FL_SLIDER_COL1		FL_COL1
#define FL_SLIDER_COL2		FL_COL1
#define FL_SLIDER_LCOL		FL_LCOL
#define FL_SLIDER_ALIGN		FL_ALIGN_BOTTOM

/***** Others   *****/

#define FL_SLIDER_BW1		FL_BOUND_WIDTH
#define FL_SLIDER_BW2		2

#define FL_SLIDER_FINE		0.05
#define FL_SLIDER_WIDTH		0.08


/***** Routines *****/

extern FL_OBJECT *fl_create_slider(int, FL_Coord, FL_Coord, FL_Coord, FL_Coord,
				   const char *);
extern FL_OBJECT *fl_add_slider(int, FL_Coord, FL_Coord, FL_Coord, FL_Coord,
				const char *);

extern FL_OBJECT *fl_create_valslider(int, FL_Coord, FL_Coord, FL_Coord,
				      FL_Coord, const char *);
extern FL_OBJECT *fl_add_valslider(int, FL_Coord, FL_Coord, FL_Coord,
				   FL_Coord, const char *);

extern void fl_set_slider_value(FL_OBJECT *, double);
extern double fl_get_slider_value(FL_OBJECT *);
extern void fl_set_slider_bounds(FL_OBJECT *, double, double);
extern void fl_get_slider_bounds(FL_OBJECT *, double *, double *);

extern void fl_set_slider_return(FL_OBJECT *, int);

extern void fl_set_slider_step(FL_OBJECT *, double);
extern void fl_set_slider_size(FL_OBJECT *, double);
extern void fl_set_slider_precision(FL_OBJECT *, int);
#endif /* } */

/*
 * $Id: text.h,v 0.10 1994/09/10 07:17:38 zhao Exp $
 *
 */
#ifndef FL_TEXT_H
#define FL_TEXT_H		/* { */

enum
{
    FL_NORMAL_TEXT
};

#define FL_TEXT_BOXTYPE    FL_BORDER_BOX
#define FL_TEXT_BW         FL_BOUND_WIDTH

extern FL_OBJECT *fl_create_text(int, FL_Coord, FL_Coord, FL_Coord,
                  FL_Coord, const char *);

extern FL_OBJECT *fl_add_text(int, FL_Coord, FL_Coord, FL_Coord, FL_Coord, 
                  const char *);
#endif /* !def TEXT_H } */

/*
 * $Id: timer.h,v 0.61 1995/01/20 19:22:37 zhao Beta $
 *
 *  Object Class: Timer
 *
 */
#ifndef FL_TIMER_H
#define FL_TIMER_H		/* { */

typedef enum
{
    FL_NORMAL_TIMER,
    FL_VALUE_TIMER,
    FL_HIDDEN_TIMER
} FL_TIMER_TYPE;

/***** Defaults *****/

#define FL_TIMER_BOXTYPE	FL_DOWN_BOX
#define FL_TIMER_COL1		FL_COL1
#define FL_TIMER_COL2		FL_RED
#define FL_TIMER_LCOL		FL_LCOL
#define FL_TIMER_ALIGN		FL_ALIGN_CENTER

/***** Others   *****/

#define FL_TIMER_BW		FL_BOUND_WIDTH
#define FL_TIMER_BLINKRATE	0.2

/***** Routines *****/

extern FL_OBJECT *fl_create_timer(int, FL_Coord, FL_Coord, FL_Coord,
				  FL_Coord, const char *);

extern FL_OBJECT *fl_add_timer(int, FL_Coord, FL_Coord, FL_Coord, FL_Coord,
			       const char *);

extern void fl_set_timer(FL_OBJECT *, double);
extern double fl_get_timer(FL_OBJECT *);
#endif /* TIMER_H } */

/*
 * $Id: xyplot.h,v 0.61 1995/01/20 19:22:37 zhao Beta $
 *
 */
#ifndef FL_XYPLOT_H
#define FL_XYPLOT_H		/* { */

/*
 * Class FL_XYPLOT
 */

typedef enum
{
    FL_NORMAL_XYPLOT,		/* solid line                        */
    FL_SQUARE_XYPLOT,		/* with added square                 */
    FL_CIRCLE_XYPLOT,		/* with added circle                 */
    FL_FILL_XYPLOT,		/* fill completely                   */
    FL_POINTS_XYPLOT,		/* only data points                  */
    FL_DASHED_XYPLOT,		/* dashed line                       */
    FL_ACTIVE_XYPLOT		/* accepts interactive manipulations */
} FL_XYPLOT_TYPE;

/***** Defaults *****/

#define FL_XYPLOT_BOXTYPE       FL_FLAT_BOX
#define FL_XYPLOT_COL1          FL_COL1
#define FL_XYPLOT_LCOL          FL_LCOL
#define FL_XYPLOT_ALIGN         FL_ALIGN_BOTTOM

/***** Others   *****/

#define FL_XYPLOT_BW            FL_BOUND_WIDTH

extern void fl_set_xyplot_return(FL_OBJECT *, int);
extern void fl_set_xyplot_xtics(FL_OBJECT *, int, int);
extern void fl_set_xyplot_ytics(FL_OBJECT *, int, int);
extern void fl_set_xyplot_xbounds(FL_OBJECT *, float, float);
extern void fl_set_xyplot_ybounds(FL_OBJECT *, float, float);
extern void fl_get_xyplot(FL_OBJECT *, float *, float *, int *);
extern void fl_get_xyplot_data(FL_OBJECT *, float *, float *, int *);

extern FL_OBJECT *fl_create_xyplot(int, FL_Coord, FL_Coord, FL_Coord, FL_Coord,
				   const char *);

extern FL_OBJECT *fl_add_xyplot(int, FL_Coord, FL_Coord, FL_Coord, FL_Coord, const char *);

extern void fl_set_xyplot_data(FL_OBJECT *, float *, float *, int,
			       const char *, const char *, const char *);
extern void fl_set_xyplot_datafile(FL_OBJECT *, const char *,
				   const char *, const char *, const char *);
#endif /* FORM_XYPLOT_H  } */

#ifdef MAKING_FORMS
#include "flinternal.h"
#endif      /* MAKING_FORMS */

#if defined(PLUS_WRAPPER)
# undef PLUS_WRAPPER
   }
#endif

#endif /* FL_FORMS_H */
