#ifndef lint
static char yysccsid[] = "@(#)yaccpar	1.8 (Berkeley) 01/20/90";
#endif
#define YYBYACC 1
#line 2 "yacc_config.y"
/*
 * yacc_config.y v1.14: 1995/04/06 20:02:33 (David Hinds)\n"
 */
    
#include <stdlib.h>
#include <stdarg.h>
#include <stdio.h>
#include <string.h>
#include <syslog.h>
#include <sys/types.h>

#include "cs_types.h"
#include "cs.h"
#include "cistpl.h"
#include "ds.h"
    
#include "cardmgr.h"

extern int config_lineno;

#line 29 "yacc_config.y"
typedef union {
    char *str;
    int num;
    struct device_info_t *device;
    struct card_info_t *card;
    struct adjust_list_t *adjust;
} YYSTYPE;
#line 35 "y.tab.c"
#define DEVICE 257
#define CARD 258
#define ANONYMOUS 259
#define TUPLE 260
#define VERSION 261
#define FUNCTION 262
#define BIND 263
#define MODULE 264
#define OPTS 265
#define START 266
#define STOP 267
#define INCLUDE 268
#define EXCLUDE 269
#define RESERVE 270
#define IRQ_NO 271
#define PORT 272
#define MEMORY 273
#define STRING 274
#define NUMBER 275
#define YYERRCODE 256
short yylhs[] = {                                        -1,
    0,    0,    0,    0,    0,    1,    1,    1,    1,    2,
    2,    2,    3,    3,    3,    3,    7,    7,    7,    7,
    7,    7,    8,    9,   10,   10,   11,   12,   12,    4,
    4,    4,    5,    6,
};
short yylen[] = {                                         2,
    0,    2,    2,    2,    2,    2,    2,    2,    3,    2,
    4,    4,    2,    1,    1,    1,    2,    1,    1,    1,
    1,    1,    2,    7,    3,    3,    3,    3,    3,    3,
    3,    3,    3,    3,
};
short yydefred[] = {                                      1,
    0,    5,    0,    0,    0,    0,    0,    0,    0,    0,
   15,   16,    0,   18,   19,    0,   21,    0,   13,   17,
    0,    0,    0,    6,    7,    8,    0,    0,    0,    0,
    0,    0,   23,    0,    0,    0,    0,    0,    0,   10,
    0,    0,    9,   30,   33,   34,   32,   31,    0,   25,
   27,   28,   26,   29,    0,    0,    0,   11,   12,    0,
    0,   24,
};
short yydgoto[] = {                                       1,
    8,   24,    9,   10,   11,   12,   13,   14,   15,   16,
   17,   18,
};
short yysindex[] = {                                      0,
 -251,    0, -270, -266, -242, -242, -242,  -30, -239,  -44,
    0,    0, -250,    0,    0,  -29,    0,  -24,    0,    0,
 -254, -253, -249,    0,    0,    0, -242, -241, -240, -238,
 -237, -236,    0, -243, -234, -232, -233, -230, -228,    0,
  -10,    2,    0,    0,    0,    0,    0,    0,    4,    0,
    0,    0,    0,    0, -226, -225, -224,    0,    0,    8,
 -221,    0,
};
short yyrindex[] = {                                      0,
    0,    0,    0,    0,    0,    0,    0,   39,   42,   24,
    0,    0,   45,    0,    0,    1,    0,   16,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,
};
short yygindex[] = {                                      0,
    0,   -4,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,
};
#define YYTABLESIZE 315
short yytable[] = {                                      32,
   20,   25,   26,   19,    2,    3,    4,   20,   33,   34,
   35,   36,   37,   27,   38,   22,    5,    6,    7,   39,
   40,   41,   43,   14,   28,   42,   29,   30,   21,   22,
   23,   49,   44,   45,   55,   46,   47,   48,    2,   50,
   52,    3,   51,   53,    4,   54,   56,   57,   58,   59,
   60,   61,   62,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
   31,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,   20,   20,   20,   20,
   20,   20,   20,   20,    0,    0,    0,    0,   20,   20,
   20,   22,   22,   22,   22,   22,   22,   22,   22,   14,
   14,   14,    0,   22,   22,   22,    0,   14,    0,   14,
   14,   14,   14,   14,    2,    2,    2,    3,    3,    3,
    4,    4,    4,    0,    0,    0,    2,    2,    2,    3,
    3,    3,    4,    4,    4,
};
short yycheck[] = {                                      44,
    0,    6,    7,  274,  256,  257,  258,  274,  259,  260,
  261,  262,  263,   44,   44,    0,  268,  269,  270,   44,
  275,  275,   27,    0,  264,  275,  266,  267,  271,  272,
  273,  275,  274,  274,   45,  274,  274,  274,    0,  274,
  274,    0,  275,  274,    0,  274,   45,   44,  275,  275,
  275,   44,  274,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  265,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  256,  257,  258,  259,
  260,  261,  262,  263,   -1,   -1,   -1,   -1,  268,  269,
  270,  256,  257,  258,  259,  260,  261,  262,  263,  256,
  257,  258,   -1,  268,  269,  270,   -1,  264,   -1,  266,
  267,  268,  269,  270,  256,  257,  258,  256,  257,  258,
  256,  257,  258,   -1,   -1,   -1,  268,  269,  270,  268,
  269,  270,  268,  269,  270,
};
#define YYFINAL 1
#ifndef YYDEBUG
#define YYDEBUG 0
#endif
#define YYMAXTOKEN 275
#if YYDEBUG
char *yyname[] = {
"end-of-file",0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,"','","'-'",0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,"DEVICE","CARD",
"ANONYMOUS","TUPLE","VERSION","FUNCTION","BIND","MODULE","OPTS","START","STOP",
"INCLUDE","EXCLUDE","RESERVE","IRQ_NO","PORT","MEMORY","STRING","NUMBER",
};
char *yyrule[] = {
"$accept : list",
"list :",
"list : list adjust",
"list : list device",
"list : list card",
"list : list error",
"adjust : INCLUDE resource",
"adjust : EXCLUDE resource",
"adjust : RESERVE resource",
"adjust : adjust ',' resource",
"resource : IRQ_NO NUMBER",
"resource : PORT NUMBER '-' NUMBER",
"resource : MEMORY NUMBER '-' NUMBER",
"device : DEVICE STRING",
"device : module",
"device : start",
"device : stop",
"card : CARD STRING",
"card : anonymous",
"card : tuple",
"card : version",
"card : function",
"card : bind",
"anonymous : card ANONYMOUS",
"tuple : card TUPLE NUMBER ',' NUMBER ',' STRING",
"version : card VERSION STRING",
"version : version ',' STRING",
"function : card FUNCTION NUMBER",
"bind : card BIND STRING",
"bind : bind ',' STRING",
"module : device MODULE STRING",
"module : module ',' STRING",
"module : module OPTS STRING",
"start : device START STRING",
"stop : device STOP STRING",
};
#endif
#define yyclearin (yychar=(-1))
#define yyerrok (yyerrflag=0)
#ifdef YYSTACKSIZE
#ifndef YYMAXDEPTH
#define YYMAXDEPTH YYSTACKSIZE
#endif
#else
#ifdef YYMAXDEPTH
#define YYSTACKSIZE YYMAXDEPTH
#else
#define YYSTACKSIZE 500
#define YYMAXDEPTH 500
#endif
#endif
int yydebug;
int yynerrs;
int yyerrflag;
int yychar;
short *yyssp;
YYSTYPE *yyvsp;
YYSTYPE yyval;
YYSTYPE yylval;
short yyss[YYSTACKSIZE];
YYSTYPE yyvs[YYSTACKSIZE];
#define yystacksize YYSTACKSIZE
#line 304 "yacc_config.y"
void yyerror(char *msg, ...)
{
     va_list ap;
     char str[256];

     va_start(ap, msg);
     sprintf(str, "config error, line %d: ", config_lineno);
     vsprintf(str+strlen(str), msg, ap);
#ifdef DEBUG
     fprintf(stderr, "%s\n", str);
#else
     syslog(LOG_INFO, "%s", str);
#endif
     va_end(ap);
}

void parse_configfile(FILE *f)
{
     extern FILE *yyin;
     yyin = f;
     config_lineno = 1;
     yyparse();
     if (root_device == NULL)
	 syslog(LOG_INFO, "no device drivers defined");
     if (root_card == NULL)
	 syslog(LOG_INFO, "no cards defined");
}

#ifdef DEBUG
adjust_list_t *root_adjust = NULL;
device_info_t *root_device = NULL;
card_info_t *root_card = NULL;
void main(void)
{
    parse_configfile(stdin);
}
#endif
#line 290 "y.tab.c"
#define YYABORT goto yyabort
#define YYACCEPT goto yyaccept
#define YYERROR goto yyerrlab
int
yyparse()
{
    register int yym, yyn, yystate;
#if YYDEBUG
    register char *yys;
    extern char *getenv();

    if (yys = getenv("YYDEBUG"))
    {
        yyn = *yys;
        if (yyn >= '0' && yyn <= '9')
            yydebug = yyn - '0';
    }
#endif

    yynerrs = 0;
    yyerrflag = 0;
    yychar = (-1);

    yyssp = yyss;
    yyvsp = yyvs;
    *yyssp = yystate = 0;

yyloop:
    if (yyn = yydefred[yystate]) goto yyreduce;
    if (yychar < 0)
    {
        if ((yychar = yylex()) < 0) yychar = 0;
#if YYDEBUG
        if (yydebug)
        {
            yys = 0;
            if (yychar <= YYMAXTOKEN) yys = yyname[yychar];
            if (!yys) yys = "illegal-symbol";
            printf("yydebug: state %d, reading %d (%s)\n", yystate,
                    yychar, yys);
        }
#endif
    }
    if ((yyn = yysindex[yystate]) && (yyn += yychar) >= 0 &&
            yyn <= YYTABLESIZE && yycheck[yyn] == yychar)
    {
#if YYDEBUG
        if (yydebug)
            printf("yydebug: state %d, shifting to state %d\n",
                    yystate, yytable[yyn]);
#endif
        if (yyssp >= yyss + yystacksize - 1)
        {
            goto yyoverflow;
        }
        *++yyssp = yystate = yytable[yyn];
        *++yyvsp = yylval;
        yychar = (-1);
        if (yyerrflag > 0)  --yyerrflag;
        goto yyloop;
    }
    if ((yyn = yyrindex[yystate]) && (yyn += yychar) >= 0 &&
            yyn <= YYTABLESIZE && yycheck[yyn] == yychar)
    {
        yyn = yytable[yyn];
        goto yyreduce;
    }
    if (yyerrflag) goto yyinrecovery;
#ifdef lint
    goto yynewerror;
#endif
yynewerror:
    yyerror("syntax error");
#ifdef lint
    goto yyerrlab;
#endif
yyerrlab:
    ++yynerrs;
yyinrecovery:
    if (yyerrflag < 3)
    {
        yyerrflag = 3;
        for (;;)
        {
            if ((yyn = yysindex[*yyssp]) && (yyn += YYERRCODE) >= 0 &&
                    yyn <= YYTABLESIZE && yycheck[yyn] == YYERRCODE)
            {
#if YYDEBUG
                if (yydebug)
                    printf("yydebug: state %d, error recovery shifting\
 to state %d\n", *yyssp, yytable[yyn]);
#endif
                if (yyssp >= yyss + yystacksize - 1)
                {
                    goto yyoverflow;
                }
                *++yyssp = yystate = yytable[yyn];
                *++yyvsp = yylval;
                goto yyloop;
            }
            else
            {
#if YYDEBUG
                if (yydebug)
                    printf("yydebug: error recovery discarding state %d\n",
                            *yyssp);
#endif
                if (yyssp <= yyss) goto yyabort;
                --yyssp;
                --yyvsp;
            }
        }
    }
    else
    {
        if (yychar == 0) goto yyabort;
#if YYDEBUG
        if (yydebug)
        {
            yys = 0;
            if (yychar <= YYMAXTOKEN) yys = yyname[yychar];
            if (!yys) yys = "illegal-symbol";
            printf("yydebug: state %d, error recovery discards token %d (%s)\n",
                    yystate, yychar, yys);
        }
#endif
        yychar = (-1);
        goto yyloop;
    }
yyreduce:
#if YYDEBUG
    if (yydebug)
        printf("yydebug: state %d, reducing by rule %d (%s)\n",
                yystate, yyn, yyrule[yyn]);
#endif
    yym = yylen[yyn];
    yyval = yyvsp[1-yym];
    switch (yyn)
    {
case 2:
#line 46 "yacc_config.y"
{
		    adjust_list_t **tail = &root_adjust;
		    while (*tail != NULL) tail = &(*tail)->next;
		    *tail = yyvsp[0].adjust;
		}
break;
case 3:
#line 52 "yacc_config.y"
{
		    yyvsp[0].device->next = root_device;
		    root_device = yyvsp[0].device;
		}
break;
case 4:
#line 57 "yacc_config.y"
{
		    if (yyvsp[0].card->ident_type == 0) {
			yyerror("no ID method for this card");
			YYERROR;
		    }
		    if (yyvsp[0].card->functions == 0) {
			yyerror("no function bindings");
			YYERROR;
		    }
		    if (yyvsp[0].card->ident_type == FUNC_IDENT) {
			yyvsp[0].card->next = root_func;
			root_func = yyvsp[0].card;
		    }
		    else {
			yyvsp[0].card->next = root_card;
			root_card = yyvsp[0].card;
		    }
		}
break;
case 6:
#line 79 "yacc_config.y"
{
		    yyvsp[0].adjust->adj.Action = ADD_MANAGED_RESOURCE;
		    yyval.adjust = yyvsp[0].adjust;
		}
break;
case 7:
#line 84 "yacc_config.y"
{
		    yyvsp[0].adjust->adj.Action = REMOVE_MANAGED_RESOURCE;
		    yyval.adjust = yyvsp[0].adjust;
		}
break;
case 8:
#line 89 "yacc_config.y"
{
		    yyvsp[0].adjust->adj.Action = ADD_MANAGED_RESOURCE;
		    yyvsp[0].adjust->adj.Attributes |= RES_RESERVED;
		    yyval.adjust = yyvsp[0].adjust;
		}
break;
case 9:
#line 95 "yacc_config.y"
{
		    yyvsp[0].adjust->adj.Action = yyvsp[-2].adjust->adj.Action;
		    yyvsp[0].adjust->adj.Attributes = yyvsp[-2].adjust->adj.Attributes;
		    yyvsp[0].adjust->next = yyvsp[-2].adjust;
		    yyval.adjust = yyvsp[0].adjust;
		}
break;
case 10:
#line 104 "yacc_config.y"
{
		    yyval.adjust = calloc(sizeof(adjust_list_t), 1);
		    yyval.adjust->adj.Resource = RES_IRQ;
		    yyval.adjust->adj.resource.irq.IRQ = yyvsp[0].num;
		}
break;
case 11:
#line 110 "yacc_config.y"
{
		    if ((yyvsp[0].num < yyvsp[-2].num) || (yyvsp[0].num > 0xffff)) {
			yyerror("invalid port range");
			YYERROR;
		    }
		    yyval.adjust = calloc(sizeof(adjust_list_t), 1);
		    yyval.adjust->adj.Resource = RES_IO_RANGE;
		    yyval.adjust->adj.resource.io.BasePort = yyvsp[-2].num;
		    yyval.adjust->adj.resource.io.NumPorts = yyvsp[0].num - yyvsp[-2].num + 1;
		}
break;
case 12:
#line 121 "yacc_config.y"
{
		    if (yyvsp[0].num < yyvsp[-2].num) {
			yyerror("invalid address range");
			YYERROR;
		    }
		    yyval.adjust = calloc(sizeof(adjust_list_t), 1);
		    yyval.adjust->adj.Resource = RES_MEMORY_RANGE;
		    yyval.adjust->adj.resource.memory.Base = (caddr_t)yyvsp[-2].num;
		    yyval.adjust->adj.resource.memory.Size = yyvsp[0].num - yyvsp[-2].num + 1;
		}
break;
case 13:
#line 134 "yacc_config.y"
{
		    yyval.device = calloc(sizeof(device_info_t), 1);
		    strcpy(yyval.device->dev_info, yyvsp[0].str);
		    free(yyvsp[0].str);
		}
break;
case 17:
#line 145 "yacc_config.y"
{
		    yyval.card = calloc(sizeof(card_info_t), 1);
		    yyval.card->name = yyvsp[0].str;
		}
break;
case 23:
#line 157 "yacc_config.y"
{
		    if (yyvsp[-1].card->ident_type != 0) {
			yyerror("ID method already defined");
			YYERROR;
		    }
		    if (blank_card) {
			yyerror("Anonymous card already defined");
			YYERROR;
		    }
		    yyvsp[-1].card->ident_type = BLANK_IDENT;
		    blank_card = yyvsp[-1].card;
		}
break;
case 24:
#line 172 "yacc_config.y"
{
		    if (yyvsp[-6].card->ident_type != 0) {
			yyerror("ID method already defined");
			YYERROR;
		    }
		    yyvsp[-6].card->ident_type = TUPLE_IDENT;
		    yyvsp[-6].card->tuple.code = yyvsp[-4].num;
		    yyvsp[-6].card->tuple.ofs = yyvsp[-2].num;
		    yyvsp[-6].card->tuple.info = yyvsp[0].str;
		}
break;
case 25:
#line 185 "yacc_config.y"
{
		    if (yyvsp[-2].card->ident_type != 0) {
			yyerror("ID method already defined\n");
			YYERROR;
		    }
		    yyvsp[-2].card->ident_type = VERS_1_IDENT;
		    yyvsp[-2].card->vers.ns = 1;
		    yyvsp[-2].card->vers.pi[0] = yyvsp[0].str;
		}
break;
case 26:
#line 195 "yacc_config.y"
{
		    if (yyvsp[-2].card->vers.ns == 4) {
			yyerror("too many version strings");
			YYERROR;
		    }
		    yyvsp[-2].card->vers.pi[yyvsp[-2].card->vers.ns] = yyvsp[0].str;
		    yyvsp[-2].card->vers.ns++;
		}
break;
case 27:
#line 206 "yacc_config.y"
{
		    if (yyvsp[-2].card->ident_type != 0) {
			yyerror("ID method already defined\n");
			YYERROR;
		    }
		    yyvsp[-2].card->ident_type = FUNC_IDENT;
		    yyvsp[-2].card->func.funcid = yyvsp[0].num;
		}
break;
case 28:
#line 217 "yacc_config.y"
{
		    device_info_t *dev = root_device;
		    if (yyvsp[-2].card->functions == MAX_FUNCTIONS) {
			yyerror("too many bindings\n");
			YYERROR;
		    }
		    for (; dev; dev = dev->next)
			if (strcmp((char *)dev->dev_info, yyvsp[0].str) == 0) break;
		    if (dev == NULL) {
			yyerror("unknown device: %s", yyvsp[0].str);
			YYERROR;
		    }
		    yyvsp[-2].card->device[yyvsp[-2].card->functions] = dev;
		    yyvsp[-2].card->functions++;
		    free(yyvsp[0].str);
		}
break;
case 29:
#line 234 "yacc_config.y"
{
		    device_info_t *dev = root_device;
		    if (yyvsp[-2].card->functions == MAX_FUNCTIONS) {
			yyerror("too many bindings\n");
			YYERROR;
		    }
		    for (; dev; dev = dev->next)
			if (strcmp((char *)dev->dev_info, yyvsp[0].str) == 0) break;
		    if (dev == NULL) {
			yyerror("unknown device: %s", yyvsp[0].str);
			YYERROR;
		    }
		    yyvsp[-2].card->device[yyvsp[-2].card->functions] = dev;
		    yyvsp[-2].card->functions++;
		    free(yyvsp[0].str);
		}
break;
case 30:
#line 253 "yacc_config.y"
{
		    if (yyvsp[-2].device->modules == MAX_MODULES) {
			yyerror("too many modules");
			YYERROR;
		    }
		    yyvsp[-2].device->module[yyvsp[-2].device->modules] = yyvsp[0].str;
		    yyvsp[-2].device->opts[yyvsp[-2].device->modules] = NULL;
		    yyvsp[-2].device->modules++;
		}
break;
case 31:
#line 263 "yacc_config.y"
{
		    if (yyvsp[-2].device->modules == MAX_MODULES) {
			yyerror("too many modules");
			YYERROR;
		    }
		    yyvsp[-2].device->module[yyvsp[-2].device->modules] = yyvsp[0].str;
		    yyvsp[-2].device->opts[yyvsp[-2].device->modules] = NULL;
		    yyvsp[-2].device->modules++;
		}
break;
case 32:
#line 273 "yacc_config.y"
{
		    if (yyvsp[-2].device->opts[yyvsp[-2].device->modules-1] == NULL)
			yyvsp[-2].device->opts[yyvsp[-2].device->modules-1] = yyvsp[0].str;
		    else {
			yyerror("too many options");
			YYERROR;
		    }
		}
break;
case 33:
#line 284 "yacc_config.y"
{
		    if (yyvsp[-2].device->start_cmd != NULL) {
			yyerror("extra start command");
			YYERROR;
		    }
		    yyvsp[-2].device->start_cmd = yyvsp[0].str;
		}
break;
case 34:
#line 294 "yacc_config.y"
{
		    if (yyvsp[-2].device->stop_cmd != NULL) {
			yyerror("extra stop command");
			YYERROR;
		    }
		    yyvsp[-2].device->stop_cmd = yyvsp[0].str;
		}
break;
#line 701 "y.tab.c"
    }
    yyssp -= yym;
    yystate = *yyssp;
    yyvsp -= yym;
    yym = yylhs[yyn];
    if (yystate == 0 && yym == 0)
    {
#if YYDEBUG
        if (yydebug)
            printf("yydebug: after reduction, shifting from state 0 to\
 state %d\n", YYFINAL);
#endif
        yystate = YYFINAL;
        *++yyssp = YYFINAL;
        *++yyvsp = yyval;
        if (yychar < 0)
        {
            if ((yychar = yylex()) < 0) yychar = 0;
#if YYDEBUG
            if (yydebug)
            {
                yys = 0;
                if (yychar <= YYMAXTOKEN) yys = yyname[yychar];
                if (!yys) yys = "illegal-symbol";
                printf("yydebug: state %d, reading %d (%s)\n",
                        YYFINAL, yychar, yys);
            }
#endif
        }
        if (yychar == 0) goto yyaccept;
        goto yyloop;
    }
    if ((yyn = yygindex[yym]) && (yyn += yystate) >= 0 &&
            yyn <= YYTABLESIZE && yycheck[yyn] == yystate)
        yystate = yytable[yyn];
    else
        yystate = yydgoto[yym];
#if YYDEBUG
    if (yydebug)
        printf("yydebug: after reduction, shifting from state %d \
to state %d\n", *yyssp, yystate);
#endif
    if (yyssp >= yyss + yystacksize - 1)
    {
        goto yyoverflow;
    }
    *++yyssp = yystate;
    *++yyvsp = yyval;
    goto yyloop;
yyoverflow:
    yyerror("yacc stack overflow");
yyabort:
    return (1);
yyaccept:
    return (0);
}
