/* 
 * All buttons
 */

#include "forms.h"

FL_FORM *buttons;
FL_OBJECT *readyobj;

#include "nomail.xbm"
#include "newmail.xbm"
#include "crab.xpm"
#include "crab45.xpm"

static void
bitmapbutton(FL_OBJECT *ob, long q)
{
  int set = fl_get_button(ob);
  fl_set_bitmapbutton_data(ob, newmail_width, newmail_height,
                           set ? nomail_bits:newmail_bits); 
}

static  void
pixmapbutton(FL_OBJECT *ob, long q)
{
   int set = fl_get_button(ob);
   fl_set_pixmapbutton_data(ob, set ? crab45:crab);
}


void create_form_buttons(void)
{
  FL_OBJECT *obj;

  if (buttons)
     return;

  buttons = fl_bgn_form(FL_NO_BOX,320,380);
  obj = fl_add_box(FL_UP_BOX,0,0,320,380,"");

  readyobj = obj = fl_add_button(FL_NORMAL_BUTTON,190,15,110,30,"READY");

  obj = fl_add_button(FL_NORMAL_BUTTON,125,315,150,35,"Button");
  fl_set_object_boxtype(obj,FL_SHADOW_BOX);
  fl_set_object_color(obj,FL_GREEN,FL_RED);

  obj = fl_add_bitmapbutton(FL_PUSH_BUTTON,180,100,80,70,"");
  fl_set_object_boxtype(obj,FL_NO_BOX);
  fl_set_object_callback(obj, bitmapbutton,0);
  fl_set_bitmapbutton_data(obj,newmail_width, newmail_height, newmail_bits);

  obj = fl_add_pixmapbutton(FL_PUSH_BUTTON,200,60,45,40,"");
  fl_set_object_callback(obj, pixmapbutton,0);
  fl_set_pixmapbutton_data(obj,crab);

  fl_bgn_group();
  obj = fl_add_roundbutton(FL_RADIO_BUTTON,25,300,40,50,"");
  fl_set_object_boxtype(obj,FL_BORDER_BOX);
  fl_set_object_color(obj,FL_MCOL,FL_RED);

  obj = fl_add_roundbutton(FL_RADIO_BUTTON,25,255,40,45,"");
  fl_set_object_boxtype(obj,FL_BORDER_BOX);
  fl_set_object_color(obj,FL_MCOL,FL_GREEN);

  obj = fl_add_roundbutton(FL_RADIO_BUTTON,25,205,40,50,"");
  fl_set_object_boxtype(obj,FL_BORDER_BOX);
  fl_set_object_color(obj,FL_MCOL,FL_BLUE);
  fl_end_group();

  fl_bgn_group();
  obj = fl_add_box(FL_FRAME_BOX,115,205,75,95,"");
  obj = fl_add_box(FL_FLAT_BOX,125,295,40,10,"CheckB");
  obj = fl_add_checkbutton(FL_RADIO_BUTTON,120,265,55,30,"Red");
  fl_set_object_color(obj,FL_MCOL,FL_RED);
  obj = fl_add_checkbutton(FL_RADIO_BUTTON,120,235,55,30,"Green");
  fl_set_object_color(obj,FL_MCOL,FL_GREEN);
  obj = fl_add_checkbutton(FL_RADIO_BUTTON,120,210,55,30,"Blue");
  fl_set_object_color(obj,FL_MCOL,FL_BLUE);
  fl_end_group();

  fl_bgn_group();

  obj = fl_add_lightbutton(FL_RADIO_BUTTON,20,130,125,35,"  Red");
  fl_set_object_color(obj,FL_COL1,FL_RED);

  obj = fl_add_lightbutton(FL_RADIO_BUTTON,20,95,125,35,"  Green");
  fl_set_object_color(obj,FL_COL1,FL_GREEN);

  obj = fl_add_lightbutton(FL_RADIO_BUTTON,20,60,125,35,"  Blue");
  fl_set_object_color(obj,FL_COL1,FL_BLUE);

  fl_end_group();

  fl_bgn_group();

  obj = fl_add_roundbutton(FL_RADIO_BUTTON,230,265,55,30,"Red");
  fl_set_object_color(obj,FL_MCOL,FL_RED);

  obj = fl_add_box(FL_SHADOW_BOX,225,205,70,95,"");

  obj = fl_add_roundbutton(FL_RADIO_BUTTON,230,210,55,30,"Blue");
  fl_set_object_color(obj,FL_MCOL,FL_BLUE);

  obj = fl_add_roundbutton(FL_RADIO_BUTTON,230,235,55,30,"Green");
  fl_set_object_color(obj,FL_MCOL,FL_GREEN);

  obj = fl_add_roundbutton(FL_RADIO_BUTTON,230,265,55,30,"Red");
  fl_set_object_color(obj,FL_MCOL,FL_RED);

  fl_end_group();

  fl_end_form();
}

int
main(int argc, char *argv[])
{
    fl_initialize(argv[0],"FormDemo",0,0,&argc, argv);
    create_form_buttons();
    fl_show_form(buttons, FL_PLACE_CENTER, FL_NOBORDER, 0);
    while (fl_do_forms() != readyobj);
      ;
    return 0;
}
