/* This demo shows the use of a browser.  */

#include <stdio.h>
#include "forms.h"

FL_FORM *form;
FL_OBJECT *br, *but, *obj;

void load_file(FL_OBJECT *ob, long arg)
{
  if (! fl_load_browser(br,fl_show_input("Filename to load","")))
    fl_add_browser_line(br,"NO SUCH FILE!");
}
 
void set_size(FL_OBJECT *ob, long arg)
{
  if (arg == 0) fl_set_browser_fontsize(br,FL_SMALL_SIZE);
  if (arg == 1) fl_set_browser_fontsize(br,FL_NORMAL_SIZE);
  if (arg == 2) fl_set_browser_fontsize(br,FL_LARGE_SIZE);
}

int
main(int argc, char *argv[])
{
  fl_initialize(argv[0], "FormDemo", 0, 0 ,&argc, argv);
  form = fl_bgn_form(FL_UP_BOX,130.0,100.0);
  br = fl_add_browser(FL_NORMAL_BROWSER,5.0,5.0,95.0,90.0,"");
  but = fl_add_button(FL_NORMAL_BUTTON,105.0,5.0,20.0,8.0,"Exit");
  obj = fl_add_button(FL_NORMAL_BUTTON,105.0,75.0,20.0,8.0,"Load");
  fl_set_object_callback(obj,load_file,0);
  obj = fl_add_lightbutton(FL_RADIO_BUTTON,105.0,60.0,20.0,8.0,"Small");
  fl_set_object_callback(obj,set_size,0);
  obj = fl_add_lightbutton(FL_RADIO_BUTTON,105.0,50.0,20.0,8.0,"Normal");
  fl_set_object_callback(obj,set_size,1);
  fl_set_button(obj,1);
  obj = fl_add_lightbutton(FL_RADIO_BUTTON,105.0,40.0,20.0,8.0,"Large");
  fl_set_object_callback(obj,set_size,2);
  fl_end_form();

  fl_clear_browser(br);
  fl_add_browser_line(br,"LOAD A FILE.");

  fl_scale_form(form, 4.0, 4.0);
  fl_show_form(form,FL_PLACE_FREE,FL_TRANSIENT,"Browser");
  do { obj = fl_do_forms(); }  while (obj != but);
  fl_hide_form(form);
  return 0;
}
