/* Demo showing the use of the buttonbox.  */

#include <stdio.h>
#include "forms.h"

FL_FORM *form;
FL_OBJECT *brobj, *exitobj;
enum
{
  SW0,
  SW31 = 31
 } ;

void create_form(void)
{
  form = fl_bgn_form(FL_UP_BOX,440,230);
  brobj = fl_add_browser(FL_NORMAL_BROWSER,20,60,400,150,"");
  exitobj = fl_add_button(FL_NORMAL_BUTTON,160,20,130,30,"Exit");
  fl_end_form();
}

int
main(int argc, char *argv[])
{
  FL_OBJECT *obj;
  int i;
  char str[100];

  fl_initialize(argv[0], "FormDemo", 0, 0 ,&argc, argv);
  fl_show_buttonbox();
  create_form();

  fl_show_form(form,FL_PLACE_SIZE,FL_NOBORDER,NULL);
  for (i=0; i<32; i++)
    { sprintf(str,"%d",i); fl_set_buttonbox_label(i,str);}
  do
  {
    obj = fl_do_forms();
    if ( obj == FL_EVENT)
    {
      XEvent xev;

      fl_XNextEvent(&xev);
      switch(xev.type)
      {
       case ButtonPress:
	sprintf(str,"Button %d was pressed.",xev.xbutton.button);
        fl_addto_browser(brobj,str);
	break;
       case ButtonRelease:
	sprintf(str,"Button %d was released.",xev.xbutton.button);
        fl_addto_browser(brobj,str);
	break;
      }
    }
  } while (obj != exitobj);
  fl_hide_buttonbox();
  fl_hide_form(form);
  return 0;
}
