/*
 * cs.h v1.28: 1995/04/07 18:18:44 (David Hinds)
 */

#ifndef _LINUX_CS_H
#define _LINUX_CS_H

/* For AccessConfigurationRegister */
typedef struct conf_reg_t {
    u_long	Action;
    off_t	Offset;
    u_long	Value;
} conf_reg_t;

/* Actions */
#define CS_READ		1
#define CS_WRITE	2

/* for AdjustResourceInfo */
typedef struct adjust_t {
    u_long	Action;
    u_long	Resource;
    u_long	Attributes;
    union {
	struct memory {
	    caddr_t	Base;
	    u_long	Size;
	} memory;
	struct io {
	    ioaddr_t	BasePort;
	    ioaddr_t	NumPorts;
	    u_long	IOAddrLines;
	} io;
	struct irq {
	    u_long	IRQ;
	} irq;
    } resource;
} adjust_t;

/* Action field */
#define REMOVE_MANAGED_RESOURCE		1
#define ADD_MANAGED_RESOURCE		2
#define GET_FIRST_MANAGED_RESOURCE	3
#define GET_NEXT_MANAGED_RESOURCE	4
/* Resource field */
#define RES_MEMORY_RANGE		1
#define RES_IO_RANGE			2
#define RES_IRQ				3
/* Attribute field */
#define RES_IRQ_TYPE			0x03
#define RES_IRQ_TYPE_EXCLUSIVE		0
#define RES_IRQ_TYPE_TIME		1
#define RES_IRQ_TYPE_DYNAMIC		2
#define RES_IRQ_CSC			0x04
#define RES_SHARED			0x08
#define RES_RESERVED			0x10
#define RES_ALLOCATED			0x20
#define RES_REMOVED			0x40

typedef struct servinfo_t {
    char	Signature[2];
    u_long	Count;
    u_long	Revision;
    u_long	CSLevel;
    char	*VendorString;
} servinfo_t;

typedef struct event_callback_args_t {
    client_handle_t client_handle;
    void	*info;
    void	*mtdrequest;
    void	*buffer;
    void	*misc;
    void	*client_data;
} event_callback_args_t;

#ifdef __KERNEL__

#define CLIENT_MAGIC 	0x51E6

typedef struct client_t {
    u_long	client_magic;
    socket_t	Socket;
    dev_info_t	*dev_info;
    u_long	Attributes;
    u_long	state;
    u_long	EventMask, PendingEvents;
    int (*event_handler)(event_t event, int priority,
			 event_callback_args_t *);
    event_callback_args_t event_callback_args;
    struct client_t *next;
} client_t;

/* Flags in client state */
#define CLIENT_CONFIG_LOCKED	0x01
#define CLIENT_IRQ_REQ		0x02
#define CLIENT_IO_REQ		0x04
#define CLIENT_UNBOUND		0x08
#define CLIENT_STALE		0x10
#define CLIENT_WIN_REQ(i)	(0x20<<(i))
#endif /* __KERNEL__ */

/* for GetConfigurationInfo */
typedef struct config_t {
    u_long	Attributes;
    u_long	Vcc, Vpp1, Vpp2;
    u_long	IntType;
    caddr_t	ConfigBase;
    u_char	Status, Pin, Copy, Option;
    u_long	Present;
    u_long	FirstDevType, FuncCode;
    u_long	SysInitMask;
    u_long	ManufCode, ManufInfo;
    u_long	CardValues;
    u_long	AssignedIRQ;
    u_long	IRQAttributes;
    ioaddr_t	BasePort1;
    ioaddr_t	NumPorts1;
    u_long	Attributes1;
    ioaddr_t	BasePort2;
    ioaddr_t	NumPorts2;
    u_long	Attributes2;
    u_long	IOAddrLines;
} config_t;

/* For CardValues field */
#define CV_OPTION_VALUE		0x01
#define CV_STATUS_VALUE		0x02
#define CV_PIN_REPLACEMENT	0x04
#define CV_COPY_VALUE		0x08

/* For GetFirst/NextClient */
typedef struct client_req_t {
    socket_t	Socket;
    u_long	Attributes;
} client_req_t;

#define CLIENT_THIS_SOCKET	0x01

/* For RegisterClient */
typedef struct client_reg_t {
    dev_info_t	*dev_info;
    u_long	Attributes;
    u_long	EventMask;
    int		(*event_handler)(event_t event, int priority,
				 event_callback_args_t *);
    event_callback_args_t event_callback_args;
    u_long	Version;
} client_reg_t;

/* ModifyConfiguration */
typedef struct modconf_t {
    u_long Attributes;
    u_long Vcc, Vpp1, Vpp2;
} modconf_t;

/* Attributes for ModifyConfiguration */
#define CONF_IRQ_CHANGE_VALID	0x100
#define CONF_VCC_CHANGE_VALID	0x200
#define CONF_VPP1_CHANGE_VALID	0x400
#define CONF_VPP2_CHANGE_VALID	0x800

/* For RequestConfiguration */
typedef struct config_req_t {
    u_long	Attributes;
    u_long	Vcc, Vpp1, Vpp2;
    u_long	IntType;
    caddr_t	ConfigBase;
    u_char	Status, Pin, Copy;
    u_char	ConfigIndex;
    u_long	Present;
} config_req_t;

/* Attributes for RequestConfiguration */
#define CONF_ENABLE_IRQ		0x01
#define CONF_ENABLE_DMA		0x02
#define CONF_ENABLE_SPKR	0x04

/* IntType field */
#define INT_MEMORY		0x01
#define INT_MEMORY_AND_IO	0x02

/* For RequestIO and ReleaseIO */
typedef struct io_req_t {
    ioaddr_t	BasePort1;
    ioaddr_t	NumPorts1;
    u_long	Attributes1;
    ioaddr_t	BasePort2;
    ioaddr_t	NumPorts2;
    u_long	Attributes2;
    u_long	IOAddrLines;
} io_req_t;

/* Attributes for RequestIO and ReleaseIO */
#define IO_SHARED		0x01
#define IO_FIRST_SHARED		0x02
#define IO_FORCE_ALIAS_ACCESS	0x04
#define IO_DATA_PATH_WIDTH	0x18
#define IO_DATA_PATH_WIDTH_8	0x00
#define IO_DATA_PATH_WIDTH_16	0x08
#define IO_DATA_PATH_WIDTH_AUTO	0x10

/* For RequestIRQ and ReleaseIRQ */
typedef struct irq_req_t {
    u_long	Attributes;
    u_long	AssignedIRQ;
    u_long	IRQInfo1, IRQInfo2;
} irq_req_t;

/* Attributes for RequestIRQ and ReleaseIRQ */
#define IRQ_TYPE		0x03
#define IRQ_TYPE_EXCLUSIVE	0x00
#define IRQ_TYPE_TIME		0x01
#define IRQ_TYPE_DYNAMIC_SHARING 0x02
#define IRQ_FORCED_PULSE	0x04
#define IRQ_FIRST_SHARED	0x08
#define IRQ_PULSE_ALLOCATED	0x10

/* Bits in IRQInfo1 field */
#define IRQ_MASK		0x0F
#define IRQ_NMI_ID		0x01
#define IRQ_IOCK_ID		0x02
#define IRQ_BERR_ID		0x04
#define IRQ_VEND_ID		0x08
#define IRQ_INFO2_VALID		0x10
#define IRQ_LEVEL_ID		0x20
#define IRQ_PULSE_ID		0x40
#define IRQ_SHARE_ID		0x80

typedef struct eventmask_t {
    u_long	Attributes;
    u_long	EventMask;
} eventmask_t;

#define CONF_EVENT_MASK_VALID	0x01

/* Configuration registers present */
#define PRESENT_OPTION		0x01
#define PRESENT_STATUS		0x02
#define PRESENT_PIN_REPLACE	0x04
#define PRESENT_COPY		0x08

/* Attributes for Request/GetConfiguration */
#define CONF_ENABLE_IRQ		0x01
#define EXCLUSIVE_USE		0x02
#define VALID_CLIENT		0x04

/* For MapMemPage */
typedef struct memreq_t {
    u_long	CardOffset;
    page_t	Page;
} memreq_t;

/* For ModifyWindow */
typedef struct modwin_t {
    u_long	Attributes;
    u_long	AccessSpeed;
} modwin_t;

/* For RequestWindow */
typedef struct win_req_t {
    u_long	Attributes;
    caddr_t	Base;
    u_long	Size;
    u_long	AccessSpeed;
} win_req_t;

/* Attributes for RequestWindow */
#define WIN_MEMORY_TYPE		0x0001
#define WIN_MEMORY_TYPE_CM	0x0000
#define WIN_MEMORY_TYPE_AM	0x0001
#define WIN_ENABLE		0x0002
#define WIN_DATA_WIDTH		0x0004
#define WIN_DATA_WIDTH_16	0x0004
#define WIN_DATA_WIDTH_8	0x0000
#define WIN_PAGED		0x0008
#define WIN_SHARED		0x0010
#define WIN_FIRST_SHARED	0x0020
#define WIN_USE_WAIT		0x0040

/* Attributes for RegisterClient */
#define INFO_DRIVER_SERVICES	0x01
#define INFO_IO_CLIENT		0x02
#define INFO_MTD_CLIENT		0x04
#define INFO_MEM_CLIENT		0x08
#define MAX_NUM_CLIENTS		3

#define INFO_CARD_SHARE		0x10
#define INFO_CARD_EXCL		0x20

typedef struct tuple_t {
    u_long	Attributes;
    cisdata_t 	DesiredTuple;
    u_long	Flags;		/* internal use */
    u_long	LinkOffset;	/* internal use */
    u_long	CISOffset;	/* internal use */
    cisdata_t	TupleCode;
    cisdata_t	TupleLink;
    cisdata_t	TupleOffset;
    cisdata_t	TupleDataMax;
    cisdata_t	TupleDataLen;
    cisdata_t	*TupleData;
} tuple_t;

/* Special cisdata_t value */
#define RETURN_FIRST_TUPLE	0xff

/* Attributes for tuple calls */
#define TUPLE_RETURN_LINK	0x01

typedef struct status_t {
    u_long 	CardState;
    u_long	SocketState;
} status_t;

typedef struct cisinfo_t {
    u_long	Chains;
} cisinfo_t;

/* Special stuff for binding drivers to sockets */
typedef struct bind_req_t {
    socket_t	Socket;
    dev_info_t	*dev_info;
} bind_req_t;

/* Calls to set up low-level "Socket Services" drivers */

typedef int (*ss_entry_t)(u_int sock, u_int cmd, void *arg);

int register_ss_entry(int nsock, ss_entry_t entry);
void unregister_ss_entry(ss_entry_t entry);

/* Events */
#define CS_EVENT_PRI_LOW		0
#define CS_EVENT_PRI_HIGH		1

#define CS_EVENT_WRITE_PROTECT		0x0001
#define CS_EVENT_CARD_LOCK		0x0002
#define CS_EVENT_CARD_INSERTION		0x0004
#define CS_EVENT_CARD_REMOVAL		0x0008
#define CS_EVENT_BATTERY_DEAD		0x0010
#define CS_EVENT_BATTERY_LOW		0x0020
#define CS_EVENT_READY_CHANGE		0x0040
#define CS_EVENT_CARD_DETECT		0x0080
#define CS_EVENT_RESET_REQUEST		0x0100
#define CS_EVENT_RESET_PHYSICAL		0x0200
#define CS_EVENT_CARD_RESET		0x0400
#define CS_EVENT_REGISTRATION_COMPLETE	0x0800
#define CS_EVENT_RESET_COMPLETE		0x1000
#define CS_EVENT_PM_SUSPEND		0x2000
#define CS_EVENT_PM_RESUME		0x4000
#define CS_EVENT_INSERTION_REQUEST	0x8000
#define CS_EVENT_EJECTION_REQUEST	0x10000

/* Return codes */
#define CS_SUCCESS		0x00
#define CS_BAD_ADAPTER		0x01
#define CS_BAD_ATTRIBUTE	0x02
#define CS_BAD_BASE		0x03
#define CS_BAD_EDC		0x04
#define CS_BAD_IRQ		0x06
#define CS_BAD_OFFSET		0x07
#define CS_BAD_PAGE		0x08
#define CS_READ_FAILURE		0x09
#define CS_BAD_SIZE		0x0a
#define CS_BAD_SOCKET		0x0b
#define CS_BAD_TYPE		0x0d
#define CS_BAD_VCC		0x0e
#define CS_BAD_VPP		0x0f
#define CS_BAD_WINDOW		0x11
#define CS_WRITE_FAILURE	0x12
#define CS_NO_CARD		0x14
#define CS_UNSUPPORTED_FUNCTION	0x15
#define CS_UNSUPPORTED_MODE	0x16
#define CS_BAD_SPEED		0x17
#define CS_BUSY			0x18
#define CS_GENERAL_FAILURE	0x19
#define CS_WRITE_PROTECTED	0x1a
#define CS_BAD_ARG_LENGTH	0x1b
#define CS_BAD_ARGS		0x1c
#define CS_CONFIGURATION_LOCKED	0x1d
#define CS_IN_USE		0x1e
#define CS_NO_MORE_ITEMS	0x1f
#define CS_OUT_OF_RESOURCE	0x20
#define CS_BAD_HANDLE		0x21

#define CS_BAD_TUPLE		0x40

#ifdef __KERNEL__

enum service {
    AccessConfigurationRegister, AddSocketServices,
    AdjustResourceInfo, CheckEraseQueue, CloseMemory, CopyMemory,
    DeregisterClient, DeregisterEraseQueue, GetCardServicesInfo,
    GetClientInfo, GetConfigurationInfo, GetEventMask,
    GetFirstClient, GetFirstPartion, GetFirstRegion, GetFirstTuple,
    GetNextClient, GetNextPartition, GetNextRegion, GetNextTuple,
    GetStatus, GetTupleData, MapLogSocket, MapLogWindow, MapMemPage,
    MapPhySocket, MapPhyWindow, ModifyConfiguration, ModifyWindow,
    OpenWindow, ParseTuple, ReadMemory, RegisterClient,
    RegisterEraseQueue, RegisterMTD, RegisterTimer,
    ReleaseConfiguration, ReleaseExclusive, ReleaseIO, ReleaseIRQ,
    ReleaseSocketMask, ReleaseWindow, ReplaceSocketServices,
    RequestConfiguration, RequestExclusive, RequestIO, RequestIRQ,
    RequestSocketMask, RequestWindow, ResetCard, ReturnSSEntry,
    SetEventMask, SetRegion, ValidateCIS, VendorSpecific,
    WriteMemory, BindDevice, ReportError, SuspendCard, ResumeCard,
    EjectCard, InsertCard
};

int CardServices(int func, ...);

#endif /* __KERNEL__ */

#endif /* _LINUX_CARD_SERVICES_H */
