/* common.c - common utility routines */

/* Written 1994,1995 by Werner Almesberger */


#include <stdlib.h>
#include <stdio.h>
#include <stdarg.h>
#include <string.h>
#include <errno.h>

#include "common.h"
#include "screen.h"


void *alloc(size_t size)
{
    void *tmp;

    if (!(tmp = malloc(size))) die("malloc: %s",strerror(errno));
    return tmp;
}


char *stralloc(const char *str)
{
    return strcpy(alloc(strlen(str)+1),str);
}


void die(const char *msg,...)
{
    va_list ap;

    scr_end();
    va_start(ap,msg);
    vfprintf(stderr,msg,ap);
    va_end(ap);
    fprintf(stderr,"\n");
    exit(1);
}
