/* write.c - variable assignment writer */

/* Written 1994,1995 by Werner Almesberger */


#include <stdio.h>
#include <string.h>
#include <errno.h>

#include "scend.h"
#include "common.h"
#include "descr.h"


static int write_list(FILE *file,char *buffer,const ITEM *curr);


static int write_multi(FILE *file,char *buffer,int values,const VALUE *value,
  unsigned long mask)
{
    const char *str;
    char *temp;
    int i;

    strcat(buffer,":");
    temp = strchr(buffer,0);
    for (i = 0; i < values; i++) {
	str = value[i].value;
	if (temp-buffer+strlen(str) >= MAX_BUFFER-1) die("MAX_BUFFER exceeded");
	strcpy(temp,str);
	if (mask & (1 << i))
	    if (fprintf(file,"%s\n",buffer) == EOF) return 0;
	strcat(temp,".");
	if (!write_list(file,buffer,value[i].section)) return 0;
    }
    return 1;
}


static int write_list(FILE *file,char *buffer,const ITEM *curr)
{
    const ITEM *walk;
    char *here;

    here = strchr(buffer,0);
    for (walk = curr; walk; walk = walk->next) {
	if (walk->flags != FLAG_SEEN) continue;
	if (walk->var) {
	    if (here-buffer+strlen(walk->var) >= MAX_BUFFER-1)
		die("MAX_BUFFER exceeded");
	    strcpy(here,walk->var);
	}
	switch (walk->type) {
	    case it_comment:
		*here = 0;
		if (!write_list(file,buffer,walk->u.comment.section)) return 0;
		break;
	    case it_bool:
		if (fprintf(file,"%s%s\n",walk->u.bool.on ? "" : "!",buffer)
		  == EOF) return 0;
		*here = 0;
		if (!write_list(file,buffer,walk->u.bool.section)) return 0;
		break;
	    case it_number:
		if (walk->u.number.value == walk->u.number.off) {
		    if (fprintf(file,"!%s\n",buffer) == EOF) return 0;
		}
		else if (fprintf(file,"%s=%d\n",buffer,walk->u.number.value) ==
		      EOF) return 0;
		*here = 0;
		if (!write_list(file,buffer,walk->u.number.section)) return 0;
		break;
	    case it_choice:
		if (fprintf(file,"%s=%s\n",buffer,CURR_VALUE(walk).value) ==
		  EOF) return 0;
		if (!write_multi(file,buffer,walk->u.choice.values,
		  walk->u.choice.value,0)) return 0;
		break;
	    case it_set:
		if (!walk->u.set.set)
		    if (fprintf(file,"!%s\n",buffer) == EOF) return 0;
		if (!write_multi(file,buffer,walk->u.set.values,
		  walk->u.set.value,walk->u.set.set)) return 0;
		break;
	    case it_if:
		*here = 0;
		if (!write_list(file,buffer,walk->u.cond.true)) return 0;
		if (!write_list(file,buffer,walk->u.cond.false)) return 0;
		break;
	    default:
		;
	}
    }
    return 1;
}


static int write_unused(FILE *file)
{
    UNUSED *walk;

    if (fprintf(file,"# The following variables did not occur in the most "
      "recently used\n# description file. They may be obsolete.\n") == EOF)
	return 0;
    for (walk = unused; walk; walk = walk->next)
	if (fprintf(file,"%s%s%s%s\n",walk->value || !walk->on ? "" : "!",
	  walk->var,walk->value ? "=" : "",walk->value ? walk->value : "") ==
	  EOF) return 0;
    return 1;
}


const char *write_cfg(const char *name)
{
    FILE *file;
    char buffer[MAX_BUFFER+1];

    if (!(file = fopen(name,"w"))) return strerror(errno);
    *buffer = 0;
    if (!write_list(file,buffer,descr)) return strerror(errno);
    if (unused)
	if (!write_unused(file)) return strerror(errno);
    if (fclose(file) == EOF) return strerror(errno);
    return NULL;
}
