
# Makefile for the sound card driver, on SCO UNIX and ISC
#

VERSION		= 2.5

TARGET_OS	= sco
HOSTCC		= cc
#HOSTCC		= gcc
CC=cc
#CC=gcc
CFLAGS = -O -DSCO -DINKERNEL -fpcc-struct-return

SHELL=/bin/sh
INCLSYS = /usr/include/sys
LKDRVRDIR = /etc/conf/pack.d/sound
LKSCONFDIR = /etc/conf/sdevice.d
LKNCONFDIR = /etc/conf/node.d
LKICONFDIR = /etc/conf/init.d
LKKCONFDIR = /etc/conf/kconfig.d
DRVRNAME = sco/Driver.o
CONFNAME = snd

OBJS   = soundcard.o audio.o dmabuf.o sb_dsp.o dev_table.o patmgr.o \
	 opl3.o sequencer.o midibuf.o sb_card.o pas2_card.o adlib_card.o \
	 pas2_pcm.o pas2_mixer.o pas2_midi.o gus_card.o gus_wave.o mpu401.o \
	 gus_midi.o gus_vol.o sb_midi.o sb_mixer.o sb16_dsp.o sb16_midi.o \
	 sound_switch.o ics2101.o

all: local.h os.h $(DRVRNAME) $(INCLSYS)/soundcard.h

os.h:
	@$(MAKE) setup-$(TARGET_OS)
	@$(MAKE) config

$(DRVRNAME): $(INCLSYS)/soundcard.h makefile $(OBJS)
	$(LD) -r -o $(DRVRNAME) $(OBJS)

clean:
	rm -f core *.o *.a tmp_make
	rm -f configure Makefile sound_stub.c
	for i in *.c;do rm -f `basename $$i .c`.s;done
	rm -f sco/Driver.o

purge:	clean
	rm -f makefile local.h os.h soundcard.c
	ln -s makefile.linux makefile

indent:
	for n in *.c;do echo indent $$n;indent $$n;done

local.h:
	$(MAKE) clean
	$(MAKE) setup-$(TARGET_OS)
	$(MAKE) config

soundcard.c: $(TARGET_OS)/soundcard.c
	-ln  $(TARGET_OS)/soundcard.c soundcard.c

config: os.h configure
	@./configure > local.h
	@echo \#define SOUND_VERSION_STRING \"$(VERSION)\" >> local.h
	@echo \#define SOUND_CONFIG_DATE \"`date`\" >> local.h
	@echo \#define SOUND_CONFIG_BY \"`who am i`\" >> local.h
#	@echo \#define SOUND_CONFIG_HOST \"`hostname`\" >> local.h
#	@echo \#define SOUND_CONFIG_DOMAIN \"`domainname`\" >> local.h
	@echo \#define SOUND_CONFIG_HOST \"unknown\" >> local.h
	@echo \#define SOUND_CONFIG_DOMAIN \"unknown\" >> local.h

clrconf:
	rm -f local.h .depend os.h soundcard.c

configure: configure.c 
	$(HOSTCC) -DSCO -o configure configure.c

setup-linux:
	@echo Compiling Sound Driver v $(VERSION) for Linux
	@ln -s linux/soundcard.c soundcard.c
	@ln -s linux/os.h os.h

setup-sco:
	@echo Compiling Sound Driver v $(VERSION) for SCO
	-@ln -s sco/soundcard.c soundcard.c
	-@ln -s sco/os.h os.h

setup-386bsd:
	@echo Compiling Sound Driver v $(VERSION) for 386bsd 
	-@ln -s 386bsd/soundcard.c soundcard.c
	-@ln -s 386bsd/os.h os.h

# install: $(LKDRVRDIR) $(LKDRVRDIR)/$(DRVRNAME) $(LKDRVRDIR)/space.c \
#	$(INCLSYS)/soundcard.h
# OLD install, now done manually
# install: Driver.o $(INCLSYS)/sb.h Master System Space.c Node
# 	/etc/insdriver
# 	/etc/kconfig
install:
	@echo To install the sound driver on SCO UNIX, you must
	@echo go to the sco subdirectory and type \"./Install\".

$(LKDRVRDIR):
	-mkdir $(LKDRVRDIR) 2> /dev/null
	chmod 755 $(LKDRVRDIR)

$(INCLSYS)/soundcard.h: soundcard.h
	@echo /bin/cp soundcard.h $(INCLSYS)/soundcard.h
	/bin/cp soundcard.h $(INCLSYS)/soundcard.h

$(LKDRVRDIR)/Driver.o: Driver.o
	cp Driver.o $(LKDRVRDIR)/$(DRVRNAME)
	chmod 644 $(LKDRVRDIR)/$(DRVRNAME)

$(LKDRVRDIR)/space.c: Space.c
	cp Space.c $(LKDRVRDIR)/space.c
	chmod 644 $(LKDRVRDIR)/space.c
#
# include a dependency file if one exists
#
#ifeq (.depend,$(wildcard .depend))
#include .depend
#endif

