
/*
*	gmod.c	- Module player for GUS and Linux.
*		(C) Hannu Savolainen, 1993
*
*	NOTE!	This program doesn't try to be a complete module player.
*		It's just a too I used while developing the driver. In
*		addition it can be used as an example on programming
*		the VoxWare Sound Driver with GUS.
*/

/*
* Many modifications have been done by Andrew J. Robinson.
* Refer to the ChangeLog for details.
*/


#include <sys/types.h>
#include <fcntl.h>
#include <unistd.h>
#include <sys/soundcard.h>
#include <sys/ultrasound.h>
#include <stdio.h>

#include "defines.h"
#include "structs.h"
#include "tables.h"
#include "protos.h"

SEQ_DEFINEBUF (2048);

int pattern_len[MAX_POSITION];
int pattern_tempo[MAX_POSITION];
pattern *pattern_table[MAX_PATTERN];

struct voice_info voices[MAX_TRACK];

int nr_channels, nr_patterns, songlength;
int tune[MAX_POSITION];
double tick_duration;

int seqfd;
int sample_ok[128], sample_vol[128];
int tmp, gus_dev;
double this_time, next_time;
int ticks_per_division;
double clock_rate;		/* HZ */

int main_volume = 255;
char loop_breaker = 0;

struct effect_info effects;

int
main (int argc, char *argv[])
{
  int i, n, j, name_start;
  struct synth_info info;

  printf ("GMOD V1.0\n");
  printf ("Original source (C) Hannu Savolainen, 1993\n");
  printf ("Modifications by Andrew J. Robinson\n\n");

  name_start = parse_args (argc, argv);

  if (name_start == argc)
    {
      printf ("\nUsage: %s [options] modfile . . .\n", argv[0]);
      printf ("Use %s -h for help.\n\n", argv[0]);
      exit (50);
    }

  if ((seqfd = open ("/dev/sequencer", O_WRONLY, 0)) == -1)
    {
      perror ("/dev/sequencer");
      exit (-1);
    }

  if (ioctl (seqfd, SNDCTL_SEQ_NRSYNTHS, &n) == -1)
    {
      perror ("/dev/sequencer");
      exit (-1);
    }

  for (i = 0; i < n; i++)
    {
      info.device = i;

      if (ioctl (seqfd, SNDCTL_SYNTH_INFO, &info) == -1)
	{
	  perror ("/dev/sequencer");
	  exit (-1);
	}

      if (info.synth_type == SYNTH_TYPE_SAMPLE
	  && info.synth_subtype == SAMPLE_TYPE_GUS)
	gus_dev = i;
    }

  if (gus_dev == -1)
    {
      fprintf (stderr, "Gravis Ultrasound not detected\n");
      exit (-1);
    }

  GUS_NUMVOICES (gus_dev, 14);

  for (i = name_start; i < argc; i++)
    {
      for (j = 0; j < MAX_PATTERN; j++)
	pattern_table[j] = NULL;

      if (load_module (argv[i]))
	{
	  tick_duration = 100.0 / clock_rate;
	  play_module (argv[i]);
	}

    }

  SEQ_DUMPBUF ();
  close (seqfd);

  exit (0);
}
