/* This file is part of the GMOD package */

struct note_info
{
  unsigned char note;
  unsigned char vol;
  unsigned char sample;
  unsigned char command;
  short parm1, parm2;
  int period;			/* period of note */
};

struct voice_info
{
  int sample;
  int note;
  int volume;
  int pitchbender;

  /* Pitch sliding */

  int slide_pitch;
  int slide_goal;
  int slide_rate;
  int last_rate;		/* last rate of slide */
  int slide_period;
  int slide_period_goal;
  int glissando;

  int volslide;
  int finevol;

  int position;			/* for "pattern-loop" command */
  int pattern;			/* for "pattern-loop" command */
  int loop_times;		/* for "pattern-loop" command */

  int cut_count;		/* for "note cut" command */
  int delay_count;		/* for "note delay" command */

  int arpeg_num;		/* for arpeggio */
  int arpeg_curr;		/* for arpeggio */
  int arpeg_note[3];		/* for arpeggio */

  int retrigger;		/* for note retrigger */
  int retrig_count;		/* for note retrigger */

  int vibra_rate;		/* vibrato rate */
  int vibra_old_rate;		/* previous vibrato rate */
  int vibra_depth;		/* vibrato depth */
  int vibra_position;		/* vibrato position */
  int vibra_wave;		/* vibrato waveform */

  int tremolo;			/* tremolo rate */
  int tremolo_old;		/* previous tremolo rate */
  int tremolo_depth;		/* tremolo depth */
  int tremolo_position;		/* tremolo position */
  int tremolo_wave;		/* tremolo waveform */
};

struct effect_info
{
  int delay_notes;		/* for "pattern delay" command */
  int loop_chan;		/* for "pattern loop" command */
  int pattern;			/* position in pattern for jumps, etc */
  int position;			/* position in song for jumps, etc */
};

typedef struct note_info pattern[MAX_TRACK][64];
