/*
 * cnvt-2-to-3.c -- convert a version 2 database to a version 3 database
 *
 * Lars Wirzenius
 * "@(#)lsmtool:cnvt-2-to-3.c,v 1.3 1994/11/11 19:13:22 wirzeniu Exp"
 */

 
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <publib.h>
#include "lsm.h"


/* The database and the current location in it */
static struct lsm_database db;


static void convert(struct lsm_entry *);


int main(int argc, char **argv) {
	size_t i;

	__set_liberror(__exit_on_error | __complain_on_error);
	set_progname(argv[0], "lsmtool");

	if (lsm_read_database(stdin, &db) == -1)
		errormsg(1, 0, "error in database");

	for (i = 0; i < db.nentries; ++i)
		convert(&db.entries[i]);

	lsm_write_database(stdout, &db);

	return 0;
}



static char *field(struct lsm_entry *e, const char *name) {
	char *p;

	p = e->fields[lsm_field_to_index(name)];
	if (p == NULL)
		return "";
	return p;
}


static void delete(struct lsm_entry *e, const char *name) {
	size_t i;
	i = lsm_field_to_index(name);
	free(e->fields[i]);
	e->fields[i] = NULL;
}


static void set(struct lsm_entry *e, const char *name, const char *val) {
	size_t i;
	i = lsm_field_to_index(name);
	free(e->fields[i]);
	e->fields[i] = xstrdup(val);
}


static void siteconv(struct lsm_entry *e, const char *result, int n) {
	char sitef[] = "SiteX";
	char pathf[] = "PathX";
	char filef[] = "FileX";
	char sizef[] = "FileSizeX";
	char *site, *path, *file, *size;
	char buf[10240];
	int siten, pathn, filen, sizen;

	*strchr(sitef, 'X') = n + '0';
	*strchr(pathf, 'X') = n + '0';
	*strchr(filef, 'X') = n + '0';
	*strchr(sizef, 'X') = n + '0';

	site = field(e, sitef); siten = strcspn(site, "\n");
	path = field(e, pathf); pathn = strcspn(path, "\n");
	file = field(e, filef); filen = strcspn(file, "\n");
	size = field(e, sizef); sizen = strcspn(size, "\n");

	if (*site == '\0' || *file == '\0') return;

	sprintf(buf, "%.*s %.*s\n\t\t%.*s %.*s\n",
		siten, *site == '\0' ? "unknown" : site,
		pathn, *path == '\0' ? "unknown" : path,
		sizen, *size == '\0' ? "" : size,
		filen, *file == '\0' ? "unknown" : file);

	set(e, result, buf);
}


static void append(struct lsm_entry *e, const char *to, const char *prefix) {
	char f[100];
	char buf[10240];
	int i;

	strcpy(buf, field(e, to));
	for (i = 0; i < 10; ++i) {
		sprintf(f, "%s%d", prefix, i);
		strcat(buf, field(e, f));
		delete(e, f);
	}
	set(e, to, buf);
}

static void convert(struct lsm_entry *e) {
	char *p, buf[10240];

	if (strstr(field(e, "AuthorEmail"), "No address") == NULL) {
		sprintf(buf, "%s (%s)", field(e, "AuthorEmail"),
			field(e, "Author"));
		strgsub(buf, "\n", "", sizeof(buf));
		strcat(buf, "\n");
		set(e, "Author", buf);
	} else
		delete(e, "Author");
	delete(e, "AuthorEmail");

	if (strstr(field(e, "MaintEmail"), "No address") == NULL) {
		sprintf(buf, "%s (%s)", field(e, "MaintEmail"),
			field(e, "Maintainer"));
		strgsub(buf, "\n", "", sizeof(buf));
		strcat(buf, "\n");
		set(e, "Maintained-by", buf);
	}
	delete(e, "MaintEmail");
	delete(e, "Maintainer");

	append(e, "Description", "Comment");
	append(e, "Description", "Required");

	if (field(e, "CopyPolicy1")[0] != '\0')
		set(e, "Copying-policy", field(e, "CopyPolicy1"));
	delete(e, "CopyPolicy1");
	delete(e, "CopyPolicy2");
	delete(e, "CopyPolicy3");
	delete(e, "CopyPolicy4");

	siteconv(e, "Primary-site", 1);
	siteconv(e, "Alternate-site", 2);
	delete(e, "Site1");
	delete(e, "Site2");
	delete(e, "Site3");
	delete(e, "Site4");
	delete(e, "Path1");
	delete(e, "Path2");
	delete(e, "Path3");
	delete(e, "Path4");
	delete(e, "File1");
	delete(e, "File2");
	delete(e, "File3");
	delete(e, "File4");
	delete(e, "FileSize1");
	delete(e, "FileSize2");
	delete(e, "FileSize3");
	delete(e, "FileSize4");

	p = field(e, "Entered");
	if (*p != '\0')
		set(e, "Entered-date", p);
	delete(e, "Entered");

	delete(e, "EmailEntered");
	delete(e, "RelFiles1");
	delete(e, "RelFiles2");
	delete(e, "RelFiles3");
	delete(e, "RelFiles4");
	delete(e, "EnteredBy");
	delete(e, "CheckedEmail");

	if (field(e, "Title")[0] == '\0')
		set(e, "Title", "?\n");
	if (field(e, "Version")[0] == '\0')
		set(e, "Version", "?\n");
	if (field(e, "Primary-site")[0] == '\0')
		set(e, "Primary-site", "?\n\t?\n");
	if (field(e, "Description")[0] == '\0')
		set(e, "Description", "?\n");
}
