/*
 * lsmextract.c -- extract LSM entries from input
 *
 * Usage: lsmextract [file ...]
 * lsmextract reads the named files, or the standard input if none were
 * named, searches for LSM entries, extracts them, and appends them to
 * the two files "lsmextract.good" and "lsmextract.bad", depending on
 * whether they seemed to fulfill all the syntactic and other requirements
 * or not.  A report is printed to the standard output.  The report
 * contains lines like:
 *	title version
 * where version and title come from the * version and title fields of
 * the LSM entry.  Only good entries are included in the report.
 *
 * Lars Wirzenius
 * "@(#)lsmtool:lsmextract.c,v 1.2 1994/11/11 19:16:53 wirzeniu Exp"
 */

 
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <publib.h>
#include "lsm.h"

int main(int argc, char **argv) {
	static struct lsm_database db;
	size_t i;
	FILE *good, *bad;
	struct lsm_entry *e;

	__set_liberror(__exit_on_error | __complain_on_error);
	set_progname(argv[0], "lsmextract");

	if (lsm_read_database(stdin, &db) == -1)
		errormsg(1, 0, "error in input");

	good = xfopen("lsmextract.good", "a");
	bad = xfopen("lsmextract.bad", "a");

	for (i = 0; i < db.nentries; ++i) {
		e = &db.entries[i];
		if (lsm_check_entry(e, "") == -1)
			lsm_write_one_entry(bad, e);
		else {
			lsm_write_one_entry(good, e);
			printf("%s", e->fields[lsm_field_to_index("Title")]);
		}
	}

	return 0;
}
