#include <stdio.h>
#include "dos.h"
#include "set.h"

extern inline void outportb(unsigned short port, char value);
extern inline unsigned int inportb(unsigned short port);

unsigned _bin, _mul, _div, _gen;
unsigned long _value;

/*
	This function use integer arithmetic instead of floating point.
*/

unsigned long _Cdecl setfreq(unsigned long freq, unsigned quarz)
{
   register unsigned i;
   unsigned _err=32767;

#define MUL		1000
#define QUARZ		(2*14318lu)
#define QUARZMUL	(MUL*QUARZ)

   if (quarz == 2) {
      /* Determines binary divider _bin */
      _bin=0;
      while (freq<40000lu && _bin<7) freq <<= 1, _bin++;

      /* Determines _mul and _div */
      for (i=0; i<128; i++) {
	 register unsigned long t1=QUARZMUL*(i+3)/freq;
	 register unsigned long t2=(t1+MUL/2)/MUL;
	 register unsigned long t3=t1-t2*MUL;
	 t2 -= 2;
	 t3=(long)t3 > 0 ? t3 : -t3;
	 t3=t3*127/(i+3);
	 if (t2 > 127) continue;
	 if (t3 < _err) _err=(unsigned)t3, _mul=i, _div=(unsigned)t2;
      }

      /* Determines the range variable _gen */
      if (freq<40000l) _gen=0;
      else if (freq<50000l) _gen=1;
      else if (freq<72000l) _gen=3;
      else		    _gen=7;

      /* Calculates the value to set */
      _value=((unsigned long)quarz<<21) |
             ((unsigned long)_gen <<17) |
             ((unsigned long)_mul <<10) | (_bin<<7) | _div;

      /* And set it */
      setdotclock(&_value);
      outportb(0x3C2,(inportb(0x3CC) & 0xF3) | ((quarz << 2) & 0x0C));
      /* returns the real frequency set */
      return (((2*QUARZ*(_mul+3)/(_div+2))>>_bin)+1)>>1;
   } else {
      /* if quarz < 2, then change clock only PC */
      outportb(0x3C2,(inportb(0x3CC) & 0xF3) | ((quarz << 2) & 0x0C));
      return 0;
   }
#undef MUL
#undef QUARZ
#undef QUARZMUL

}

/* End of SETFREQ.C */
