/******************************************************************\
 *                                                                *
 *      xscdemo                                                   *
 *      version 2.2b                                              *
 *      07-27-1992  06-15-1995(linux)                             *
 *                                                                *
 *      By Sudarshan Karkada                                      *
 *         University of Alabama                                  *
 *         Tuscaloosa.                                            *
 *         (skarkada@buster.eng.ua.edu)                           *
 *                                                                *
 *      You may copy xscdemo in part or whole.                    *
 *      But, you should not try to make money off it              *
 *      and you should not claim that you developed               *
 *      the program.                                              *
 *                                                                *
 *        Copyright (c) 1992, Sudarshan Karkada                   *
 *                                                                *
 *      I thank the developers of X, spaceout, grabchars          *
 *      and egademo for the inspiration/helping me with           *
 *      ideas to write this program.                              *
 *                                                                *
 *      				                          *
 *                                                                *
 * Porting to Linux Operating System By Alexandre Dulaunoy 	  *
 * [adulau@cyberspace.org]					  *
 * Works without problems on Linux 1.0.9 to 1.2.8		  *
 * with Xfree 2.1,3.1,3.1.1 X11R5/X11R6				  *
\******************************************************************/


#include <stdio.h>
#include <math.h>
#include <unistd.h>
#include <X11/Xatom.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>

#define xscdemo_width 50
#define xscdemo_height 50
static char xscdemo_bits[] = {
   0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x02, 0x00,
   0x00, 0x00, 0x00, 0x00, 0xe0, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18,
   0x04, 0x00, 0x10, 0x01, 0x00, 0x00, 0xfe, 0x0f, 0x00, 0xa0, 0x00, 0x00,
   0x00, 0x01, 0x08, 0x00, 0x40, 0x00, 0x00, 0xc0, 0xff, 0x1f, 0x00, 0xa0,
   0x00, 0x00, 0x30, 0x00, 0x10, 0x00, 0x10, 0x01, 0x00, 0xfc, 0xff, 0x3f,
   0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x20, 0x00, 0xf0, 0x01, 0x80, 0xff,
   0xff, 0x7f, 0x00, 0x10, 0x00, 0x80, 0x00, 0x00, 0x40, 0x00, 0xf0, 0x01,
   0x80, 0xff, 0xff, 0xff, 0x00, 0x00, 0x01, 0x80, 0x02, 0x00, 0x00, 0x01,
   0xf0, 0x01, 0x80, 0xfe, 0xff, 0xff, 0x01, 0x00, 0x00, 0x80, 0x06, 0x00,
   0x00, 0x02, 0xf0, 0x01, 0x80, 0xfe, 0xff, 0xff, 0x03, 0x10, 0x00, 0x80,
   0x0a, 0x00, 0x00, 0x04, 0x10, 0x00, 0x80, 0xfa, 0xff, 0xff, 0x07, 0x10,
   0x00, 0x80, 0x1a, 0x00, 0x00, 0x07, 0xf0, 0x01, 0x80, 0xfa, 0xff, 0xff,
   0x04, 0x00, 0x00, 0x80, 0x2a, 0x00, 0x30, 0x05, 0xf0, 0x00, 0x80, 0xea,
   0xff, 0x4f, 0x04, 0x10, 0x01, 0x80, 0x6a, 0x00, 0x13, 0x05, 0x10, 0x01,
   0x80, 0xea, 0xff, 0x44, 0x04, 0x10, 0x01, 0x80, 0xaa, 0x30, 0x11, 0x05,
   0xf0, 0x00, 0x80, 0xaa, 0x4f, 0x44, 0x04, 0x00, 0x00, 0x80, 0xaa, 0x13,
   0x11, 0x05, 0xf0, 0x01, 0x00, 0xab, 0x46, 0x44, 0x04, 0x10, 0x00, 0x00,
   0xab, 0x12, 0x11, 0x05, 0x70, 0x00, 0x00, 0xaa, 0x46, 0x44, 0x04, 0x10,
   0x00, 0x00, 0xaa, 0x12, 0x11, 0x05, 0xf0, 0x01, 0x00, 0xac, 0x46, 0x44,
   0x04, 0x00, 0x00, 0x00, 0xa8, 0x12, 0x11, 0x03, 0x10, 0x01, 0x00, 0xa8,
   0x46, 0xc4, 0x00, 0xb0, 0x01, 0x00, 0xb0, 0x12, 0x31, 0x00, 0x50, 0x01,
   0x00, 0xb0, 0x46, 0x0c, 0x00, 0x10, 0x01, 0x00, 0xa0, 0x12, 0x02, 0x00,
   0x10, 0x01, 0x00, 0xc0, 0x86, 0x01, 0x00, 0x00, 0x00, 0x00, 0xc0, 0x62,
   0x00, 0x00, 0xf0, 0x01, 0x00, 0x80, 0x1a, 0x00, 0x00, 0x10, 0x01, 0x00,
   0x80, 0x0f, 0x00, 0x00, 0x10, 0x01, 0x00, 0x00, 0x03, 0x00, 0x00, 0x10,
   0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf0, 0x01, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00};

void usage(), initialize();
void demo1(), demo2(), demo3(), demo4(), demo5(), demo6();
void drawcube(), Draw_it();
int check_event();

#define TRUE (1)
#define FALSE (0)

Pixmap		pixmap;
Display 	*display;
GC 		gc1, gc2;
Window		window, root, parent;
int 		depth, screen, visibility;
XPoint		box1[5], box2[5], box3[5];
float 		con;

int rootwin = FALSE;
int reverse = FALSE;
int mode    = FALSE;
char *host  = NULL;

int demotype     = 2;
int windowwidth  = 400;
int windowheight = 300;
int window_x_pos = 100;
int window_y_pos = 100;
int cubesize     = 75;
int delay        = 1000;

/******************************************************  main  ****/
main(argc, argv)
 int argc;
 char *argv[] ;
{
  int argument;                       /* for using getopt() */
  extern char *optarg;                /*                    */
  extern int optind, opterr, optopt;  /*                    */

  fprintf(stdout, "\n\
               xscdemo\n\
             version 2.2\n\n\
         xscdemo -h for help\n");

  while ((argument = getopt (argc, argv, "RH:bd:g:hrs:t:")) != EOF)
  { 
    switch(argument)
    {
      case 'd': demotype = atoi(optarg);
                fprintf(stdout, "Demotype: %d\n", demotype);
                break;
      case 's': cubesize = atoi(optarg);
                fprintf(stdout, "Cubesize: %d\n", cubesize);
                break;
      case 'g': sscanf(optarg, "%dx%d", &windowwidth,
                       &windowheight);
                fprintf(stdout, "Screensize: %dx%d\n", windowwidth,
                        windowheight);
                break;
      case 't': delay = atoi(optarg);
                fprintf(stdout, "Delay: %d\n", delay);
                break;
      case 'H': host = optarg;
                break;
      case 'b': mode = TRUE;
                break;
      case 'r': reverse = TRUE;
                break;
      case 'R': rootwin = TRUE;
                break;
      case 'h': usage();
		break;
      case '?':
      default : usage();
                exit(1);
		break;
    }
  }

  if(host == NULL)
   if(( host = (char *) getenv("DISPLAY")) == NULL)
   { fprintf(stderr, "%s", "Error: No environment variable DISPLAY\n");
     usage();
   }

  initialize();

  gc1 = XCreateGC(display, window, 0, NULL);
  gc2 = XCreateGC(display, window, 0, NULL);

  XSetForeground(display, gc1, BlackPixel(display, screen));
  con = cubesize*0.81649658;

  switch(demotype)
  {
    case 1: demo1();
	    break;

    case 2: demo2();
	    break;

    case 3: demo3();
            break;

    case 4: demo4();
            break;

    case 5: demo5();
            break;

    case 6: demo6();
            break;
  }
}


/******************************************************  usage  ****/
void usage()
{  fprintf(stdout,
        "Usage   : xscdemo [-d demo] [-g geometry] [-s cubesize] \\\n\
          [-H host:screen] [-t delay] [-R] [-r]\n\
     -d : demo type 1, 2, 3, 4, 5 or 6 <2>\n\
     -g : size of the window           <400x300>\n\
     -s : size of the spinning cube    <75>\n\
     -H : display on different terminal \n\
     -t : time delay between movements <1000 usec>\n\
     -R : display on root window \n\
     -r : display in reverse video (white background) \n\
Example : xscdemo -d 1 -g 300x220 -s 50 \\\n\
          -H ho03:hft/0 -t 10000 -R -r\n\n"
       );
}

/*************************************************  initialize  ****/
void initialize()
{
   XSetWindowAttributes attr;
   char *name;
   Pixmap iconPixmap;
   XWMHints xwmhints;

   if((display = XOpenDisplay(host)) == NULL) 
   {
     fprintf(stderr,"Error: Connection could not be made.\n");
     exit(1);
   }

   screen = DefaultScreen(display);
   parent = root = RootWindow(display,screen);
   depth  = DefaultDepth(display,screen);

   XSelectInput(display,root,SubstructureNotifyMask);

   attr.event_mask = StructureNotifyMask | SubstructureNotifyMask
                   | VisibilityChangeMask | ExposureMask;

   if(reverse == TRUE) 
           attr.background_pixel = WhitePixel(display,screen);
   else
           attr.background_pixel = BlackPixel(display,screen);

   if(rootwin == TRUE) 
   {
      window = root;
      windowwidth = XDisplayWidth(display, screen);
      windowheight = XDisplayHeight(display, screen);
      XChangeWindowAttributes(display,window,
               CWEventMask|CWBackPixel,&attr);
   }
   else
   {
     window = XCreateWindow(display,root,window_x_pos,
		window_y_pos,windowwidth,windowheight,
                0,depth,InputOutput, DefaultVisual(display,screen),
                CWEventMask|CWBackPixel,&attr);

     name   = "Spinning Cube Demo";

     XChangeProperty(display,window,XA_WM_NAME,XA_STRING,8,
              PropModeReplace,name,strlen(name));
                XMapWindow(display,window);
   }

   iconPixmap = XCreateBitmapFromData(display, window,
                xscdemo_bits, xscdemo_width, xscdemo_height );

   xwmhints.icon_pixmap   = iconPixmap;
   xwmhints.initial_state = NormalState;
   xwmhints.flags         = IconPixmapHint | StateHint;

   XSetWMHints(display, window, &xwmhints );

   XClearWindow(display,window);
   XSync(display, 0);

}

/****************************************************  demo1  *****/
void demo1()
{ int i=0;
  int x_position;
  int y_position;
  
  pixmap=XCreatePixmap(display,window,2*cubesize,2*cubesize,depth);

  while(TRUE)
  { check_event();
    x_position = windowwidth/2-cubesize;
    y_position = windowheight/2-cubesize;

    if(reverse == TRUE)
     XSetForeground(display, gc2, WhitePixel(display,screen));
    else
     XSetForeground(display, gc2, BlackPixel(display,screen));
    XFillRectangle(display, pixmap, gc2, 0, 0, 2*cubesize, 2*cubesize);
     
    drawcube(pixmap, i, cubesize, cubesize);
    XCopyArea(display, pixmap, window, gc1, 0, 0, 2*cubesize,
		2*cubesize, x_position, y_position);
    if(++i >= 359)
     i=0;
    usleep(delay);
  }
}

/****************************************************  demo2  *****/
void demo2()
{ int i=0, x_position = windowwidth/2-cubesize;
  int y_position = windowheight/2-cubesize, xflag=1, yflag=1;

  pixmap=XCreatePixmap(display,window,2*cubesize,2*cubesize,depth);

  while(TRUE)
  { check_event();

    if(reverse == TRUE)
     XSetForeground(display, gc2, WhitePixel(display,screen));
    else
     XSetForeground(display, gc2, BlackPixel(display,screen));
    XFillRectangle(display, pixmap, gc2, 0, 0, 2*cubesize, 2*cubesize);
	
    drawcube(pixmap, i, cubesize, cubesize);
    XCopyArea(display, pixmap, window, gc1, 0, 0, 2*cubesize,
		2*cubesize, x_position, y_position);
    if(++i >= 359)
     i=0;
    if(x_position >= windowwidth-cubesize) xflag = 0;
    if(x_position <= 0-cubesize) xflag = 1;
    if(y_position >= windowheight-cubesize) yflag = 0;
    if(y_position <= 0-cubesize) yflag = 1;
    xflag == 0 ? x_position-- : x_position++ ;
    y_position = (yflag == 0 ? y_position-2: y_position+3);

    usleep(delay);
  }
}

/****************************************************  demo3  *****/
void demo3()
{ int i1, i2, i3, i4, x1, x2, x3, x4, y1, y2, y3, y4;
  int x1flag, x2flag, x3flag, x4flag;
  int y1flag, y2flag, y3flag, y4flag;
  int store = cubesize;
  
  x1flag = x3flag = y2flag = y4flag = 0;
  x2flag = x4flag = y1flag = y3flag = 1;
  x1 = x2 = x3 = x4 = windowwidth/2;
  y1 = y2 = y3 = y4 = windowheight/2;
  i1 = i2 = 0;
  i3 = i4 = 360;

  mode = 3;

  while(TRUE)
  { check_event();

    cubesize = store;
    con = cubesize*0.81649658;
    drawcube(window, i1, x1, y1);
    cubesize = store/2;
    con = cubesize*0.81649658;
    drawcube(window, i2, x2, y2);
    cubesize = store/2;
    con = cubesize*0.81649658;
    drawcube(window, i3, x3, y3);
    cubesize = store*.7;
    con = cubesize*0.81649658;
    drawcube(window, i4, x4, y4);

    if(x1 >= windowwidth) x1flag = 0;
    if(x1 <= 0) x1flag = 1;
    if(y1 >= windowheight) y1flag = 0;
    if(y1 <= 0) y1flag = 1;
    x1 = (x1flag == 0 ? x1-3 : x1+2);
    y1flag == 0 ? y1-- : y1++;

    if(x2 >= windowwidth) x2flag = 0;
    if(x2 <= 0) x2flag = 1;
    if(y2 >= windowheight) y2flag = 0;
    if(y2 <= 0) y2flag = 1;
    x2 = (x2flag == 0 ? x2-3 : x2+2);
    y2 = (y2flag == 0 ? y2-2 : y2+4);

    if(x3 >= windowwidth) x3flag = 0;
    if(x3 <= 0) x3flag = 1;
    if(y3 >= windowheight) y3flag = 0;
    if(y3 <= 0) y3flag = 1;
    x3 = (x3flag == 0 ? x3-1 : x3+2);
    y3 = (y3flag == 0 ? y3-4 : y3+2);

    if(x4 >= windowwidth) x4flag = 0;
    if(x4 <= 0) x4flag = 1;
    if(y4 >= windowheight) y4flag = 0;
    if(y4 <= 0) y4flag = 1;
    x4 = (x4flag == 0 ? x4-4 : x4+2);
    y4flag == 0 ? y4-- : y4++;

    i1+=3;
    i2+=2;
    i3--;
    i4-=2;
    if(i1 >= 359) i1 = 0;
    if(i2 >= 359) i2 = 0;
    if(i3 <= 0) i3 = 360;
    if(i4 <= 0) i4 = 360;
    
    usleep(delay);
  }
}

/****************************************************  demo4  *****/
void demo4()
{ int i=0, x_position=windowwidth/2-cubesize;
  int y_position=windowheight/2-cubesize, xflag=1, yflag=1;

  mode = 3;

  pixmap=XCreatePixmap(display,window,windowwidth,windowheight,depth);

  while(TRUE)
  { check_event();
	
    drawcube(window, i, x_position, y_position);

    if(++i >= 359)
     i=0;
    if(x_position >= windowwidth) xflag = 0;
    if(x_position <= 0) xflag = 1;
    if(y_position >= windowheight) yflag = 0;
    if(y_position <= 0) yflag = 1;
    xflag == 0 ? x_position-- : x_position++ ;
    y_position = (yflag == 0 ? y_position-2: y_position+3);

    usleep(delay);
  }
}

/****************************************************  demo5  *****/
void demo5()
{ int i=0, x_position=windowwidth/2-cubesize;
  int y_position=windowheight/2-cubesize;
  int store = cubesize, sizeflag=0;

  pixmap=XCreatePixmap(display,window,2*cubesize,2*cubesize,depth);

  while(TRUE)
  { check_event();
    if(reverse == TRUE)
     XSetForeground(display, gc2, WhitePixel(display,screen));
    else
     XSetForeground(display, gc2, BlackPixel(display,screen));
    XFillRectangle(display, pixmap, gc2, 0, 0, 2*store, 2*store);
    con = cubesize*0.81649658;
	
    drawcube(pixmap, i, store, store);
    XCopyArea(display, pixmap, window, gc1, 0, 0, 2*store,
		2*store, x_position, y_position);

    if(++i >= 359)
     i=0;

    if(cubesize == 0) sizeflag = 1;
    if(cubesize == store) sizeflag = 0;

    if(sizeflag == 1) cubesize++;
    if(sizeflag == 0) cubesize--;
    
    usleep(delay);
  }
}

/****************************************************  demo6  *****/
void demo6()
{ int i1=0, i2=0;
  int x_position, y_position;
  int x_position_planet=3*cubesize, y_position_planet=cubesize;
  int x_increment=cubesize, y_increment=0, flag=0, store=cubesize;
  float floatvar=0;
 
  pixmap=XCreatePixmap(display,window,6*cubesize,2*cubesize,depth);
  mode = 3;

  while(TRUE)
  { check_event();
    x_position= windowwidth/2-3*store;
    y_position= windowheight/2-store;

    if(reverse == TRUE)
     XSetForeground(display, gc2, WhitePixel(display,screen));
    else
     XSetForeground(display, gc2, BlackPixel(display,screen));
    XFillRectangle(display, pixmap, gc2, 0, 0, 6*store, 2*store);
    if(flag == 1) 
    { 
      cubesize = store/5;
      con = cubesize*0.81649658;
      drawcube(pixmap, i2, x_position_planet, y_position_planet);
      cubesize = store;
      con = cubesize*0.81649658;
      drawcube(pixmap, i1, 3*store, store);
    }
    else
    { 
      cubesize = store;
      con = cubesize*0.81649658;
      drawcube(pixmap, i1, 3*store, store);
      cubesize /= 5;
      con = cubesize*0.81649658;
      drawcube(pixmap, i2, x_position_planet, y_position_planet);
    }

    XCopyArea(display, pixmap, window, gc1, 0, 0, 6*store,
		2*store, x_position, y_position);
    if((i1+=3) >= 359)
     i1=0;
    if(--i2 <= 0)
     i2=360;

    if(i2%2)  /* SLOW DOWN !! */
    { if( flag == 0) /* forward movement */
      { if(x_position_planet < 3*store)
         x_increment *= 1.5;
        else
         x_increment /= 1.5;
        
        x_position_planet += x_increment;
        if(x_increment == 0)
        { flag = 1;
          x_increment = -2;
        }
      }
      else /* backward movement */
      { if(x_position_planet > 3*store)
         x_increment *= 1.5;
        else
         x_increment /= 1.5;
        
        x_position_planet += x_increment;
        if(x_increment == 0)
        { flag = 0;
          x_increment = 2;
        }
      }
    }
    usleep(delay);
  }
}

/***********************************************  check_event  *****/
int check_event()
{
  XEvent event;
  int block = FALSE;
  int status = 0;

  while((XPending(display) > 0) || (block == TRUE))
  {
     XNextEvent(display,&event);
     switch(event.type) 
     {
        case ReparentNotify:
           if(event.xreparent.window != window ) break;
           XSelectInput(display,event.xreparent.parent,
                             StructureNotifyMask);
           XSelectInput(display,parent,0);
           parent = event.xreparent.parent;
           break;

        case UnmapNotify:
           if((event.xunmap.window != window) &&
              (event.xunmap.window != parent)) break;
           block = TRUE;
           break;
  
        case VisibilityNotify:
           if(event.xvisibility.window != window) break;
           if(event.xvisibility.state == VisibilityFullyObscured)
	   {
              block = TRUE;
              break;
           }
           if((event.xvisibility.state == VisibilityUnobscured) && 
                 (visibility == 1))
	   {
             visibility = 0;
             block = FALSE;
             break;
           }
           if(event.xvisibility.state == VisibilityPartiallyObscured)
  	   {
             visibility = 1;
             block = FALSE;
           }
           break;
  
        case Expose:
           block = FALSE;
           break;

        case MapNotify:
           if((event.xmap.window != window) &&
              (event.xmap.window != parent)) break;
           block = FALSE;
           break;

        case ConfigureNotify:
           if(event.xconfigure.window != window) break;
           if((windowwidth == event.xconfigure.width) &&
              (windowheight == event.xconfigure.height))
              break;
           windowwidth = event.xconfigure.width;
           windowheight = event.xconfigure.height;
	   XClearWindow(display, window);
           block = FALSE;
	   status = 1;
           break;

        default:
           break;
     }
  }
  return(status);
}

/***************************************************  drawcube  *****/
void drawcube( scratch_pad, i, x, y)
int i, x, y;
Drawable scratch_pad;
{ 
  int cnum;
  
  box1[0].x=box1[4].x=box2[1].x=box3[0].x=box3[4].x=x;
  box1[0].y=box1[4].y=(int) (y-0.87*cubesize);
  box1[1].y=box1[3].y=box2[3].y=(int) (y-0.29*cubesize);
  box1[2].y=box2[0].y=box2[2].y=box2[4].y=(int) (y+0.29*cubesize);
  box2[1].y=(int) (y+0.87*cubesize);

  if(i<=120) cnum=1; /* To fix colors for faces depending on i */
   else if(i<=240) cnum=2;
    else cnum=3;

  i-=30;  /* Cube works with a range of is -30 to +90 only */
  while(i>90) i -= 120;

  if(i <= 30) 
   {box3[2].y=(int) (y+0.29*cubesize);
    box3[1].y=box3[3].y=(int) (y-0.29*cubesize);
    box3[0].y=box3[4].y=(int) (y-0.87*cubesize);
    box1[2].x=box2[0].x=box2[4].x=
	      (int) x-cos((double)(3.1415/180*(30+i)))*con; /* p4 */
    box1[3].x=box2[3].x=box3[1].x=
	      (int) x+sin((double)(3.1415/180*i))*con; /* p5 */
    box3[2].x=box2[2].x=
	      (int) x+cos((double)(3.1415/180*(30-i)))*con; /* p6 */
    box1[1].x=(int) x-cos((double)(3.1415/180*(30-i)))*con; /* p3 */
    box3[3].x=(int) x+cos((double)(3.1415/180*(30+i)))*con; /* p7 */

    switch(cnum)
    {case 1: 
             XSetForeground(display, gc2, 2);
	     Draw_it( scratch_pad, box1);
             XSetForeground(display, gc2, 3);
	     Draw_it( scratch_pad, box2);
             XSetForeground(display, gc2, 4);
	     Draw_it( scratch_pad, box3);
	     break;
	   
     case 2:
             XSetForeground(display, gc2, 7);
	     Draw_it( scratch_pad, box1);
             XSetForeground(display, gc2, 8);
	     Draw_it( scratch_pad, box2);
             XSetForeground(display, gc2, 2);
	     Draw_it( scratch_pad, box3);
	     break;
	   
     case 3: 
	     XSetForeground(display, gc2, 4);
	     Draw_it( scratch_pad, box1);
             XSetForeground(display, gc2, 6);
	     Draw_it( scratch_pad, box2);
             XSetForeground(display, gc2, 7);
	     Draw_it( scratch_pad, box3);
	     break;
     } /* switch */
   }   /*   if   */

   else
   {
    box3[2].y=(int) (double)(y-0.29*cubesize);
    box3[0].y=box3[4].y=(int) (y+0.87*cubesize);
    box3[1].y=box3[3].y=(int) (y+0.29*cubesize);
    box1[1].x=box3[2].x=
	  (int) x-cos((double)(3.1415/180*(i-30)))*con; /* p3 */
    box1[2].x=box2[0].x=box2[4].x=box3[3].x=
	  (int) x+sin((double)(3.1415/180*(i-60)))*con; /* p4 */
    box1[3].x=box2[3].x=
	  (int) x+cos((double)(3.1415/180*(90-i)))*con; /* p5 */
    box2[2].x=(int) x+cos((double)(3.1415/180*(i-30)))*con; /* p6 */
    box3[1].x=(int) x-cos((double)(3.1415/180*(90-i)))*con; /* p8 */

    switch(cnum)
    {case 1: 
             XSetForeground(display, gc2, 2);
	     Draw_it( scratch_pad, box1);
             XSetForeground(display, gc2, 3);
	     Draw_it( scratch_pad, box2);
             XSetForeground(display, gc2, 8);
	     Draw_it( scratch_pad, box3);
	     break;
	   
     case 2: 
             XSetForeground(display, gc2, 7);
	     Draw_it( scratch_pad, box1);
             XSetForeground(display, gc2, 8);
	     Draw_it( scratch_pad, box2);
             XSetForeground(display, gc2, 6);
	     Draw_it( scratch_pad, box3);
	     break;
	   
     case 3: 
             XSetForeground(display, gc2, 4);
	     Draw_it( scratch_pad, box1);
             XSetForeground(display, gc2, 6);
	     Draw_it( scratch_pad, box2);
             XSetForeground(display, gc2, 3);
	     Draw_it( scratch_pad, box3);
	     break;
    }
   }   /*   else   */
}

/******************************************** Draw_it ***********/
void Draw_it(scratchpad, points)
Drawable scratchpad;
XPoint *points;
{
  if(mode == TRUE)
   XDrawLines(display, scratchpad, gc1, points, 5, CoordModeOrigin);
  else if(mode == FALSE)
   XFillPolygon(display, scratchpad, gc2, points, 5, Convex,
                CoordModeOrigin);
  else
  {
   XDrawLines(display, scratchpad, gc1, points, 5, CoordModeOrigin);
   XFillPolygon(display, scratchpad, gc2, points, 5, Convex,
                CoordModeOrigin);
  }
}

