-- ***************************************************************
-- CoLibri
-- ---------------------------------------------------------------
--
-- Bcd.cs -- BCD Arithmetic
-- 
--   Copyright (C) sietec Systemtechnik GmbH & Co OHG 1994
--   All rights reserved
-- 
-- Author          : Kalle Koester
-- 
-- PURPOSE 
--      |>Description of modules purpose<|
--
-- REFER
--      |>Documents with client documentation<|
--
-- ---------------------------------------------------------------
--
-- Created On      : Wed Jan 12 14:57:15 1994
-- Last Modified By: Karl-Heinz Koester
-- Last Modified On: Thu Feb 17 13:44:14 1994
-- Update Count    : 8
-- 
-- ***************************************************************

SPECIFICATION Bcd

TYPE BCD = (* only for compiler *) ARRAY [4] OF INT;

VAR (* CONST *) max      : BCD;
VAR (* CONST *) min      : BCD;
VAR (* CONST *) smallest : BCD;
VAR (* CONST *) zero     : BCD;
VAR (* CONST *) one      : BCD;
  
-------------------------------------------------------------------------
-- Arithmetic operations
-------------------------------------------------------------------------

PROCEDURE Add
  (IN left_operand  : BCD,
   IN right_operand : BCD)
                    : BCD;

PROCEDURE Sub
  (IN left_operand  : BCD,
   IN right_operand : BCD)
                    : BCD;

PROCEDURE Mul
  (IN left_operand  : BCD,
   IN right_operand : BCD)
                    : BCD;

PROCEDURE Div
  (IN dividend : BCD,
   IN divisor  : BCD)
               : BCD;

PROCEDURE Mod
  (IN dividend : BCD,
   IN divisor  : BCD)
               : BCD;

PROCEDURE Abs
  (IN value : BCD)
            : BCD;

PROCEDURE Negate
  (IN value : BCD)
            : BCD;

-------------------------------------------------------------------------
-- Comparisons 
-------------------------------------------------------------------------

PROCEDURE IsEqual
  (IN left_operand  : BCD,
   IN right_operand : BCD)
                    : BOOL;

PROCEDURE IsNotEqual
  (IN left_operand  : BCD,
   IN right_operand : BCD)
                    : BOOL;

PROCEDURE IsLess
  (IN left_operand  : BCD,
   IN right_operand : BCD)
                    : BOOL;

PROCEDURE IsLessEqual
  (IN left_operand  : BCD,
   IN right_operand : BCD)
                    : BOOL;

PROCEDURE IsGreater
  (IN left_operand  : BCD,
   IN right_operand : BCD)
                    : BOOL;

PROCEDURE IsGreaterEqual
  (IN left_operand  : BCD,
   IN right_operand : BCD)
                    : BOOL;

PROCEDURE IsNegative
  (IN value : BCD)
            : BOOL;

PROCEDURE IsInteger
  (IN value : BCD)
            : BOOL;

-------------------------------------------------------------------------
-- Accessing Parts 
-------------------------------------------------------------------------
  
PROCEDURE GetIntegralPart (IN value : BCD) : BCD;
PROCEDURE GetFractionalPart (IN value : BCD) : BCD;
PROCEDURE GetExponent (IN value : BCD) : INT;
  
PROCEDURE Trunc
  (IN value    : BCD,
   IN position : INT)
               : BCD;

PROCEDURE Round
  (IN value    : BCD,
   IN position : INT)
               : BCD;

-------------------------------------------------------------------------
-- Error Handling
-------------------------------------------------------------------------
  
EXCEPTION ResultIsOutOfRange;
EXCEPTION ZeroDivision;

(* Internally  ***************************************************** *)

PROCEDURE Prelude ();
  
-- ***************************************************************
CONST spec_vid : STRING = 
   "@(#) $__Header$" ;

END SPECIFICATION (* Bcd *);
