(*
-------------------------------------------------------------------------------
-- Name of the source		: Date.t
-- Author(s)			: SNI
-- Date of creation		: 5 Feb 1992
-- Defined Objects		: Date
-- Description of the contents	: 
-- Document reference		: 
-- Copyright 1993, TAO S.A., Barcelona, Spain
-- This software was produced as part of the ESPRIT project ITHACA-IT.
-------------------------------------------------------------------------------
-- Modification log	:
-- Version	Date	Author	Description
-- ----------- -------- ------- -----------------------------------------------
--             13/05/93 JLA     All Methods that have to do with Duration object
--                              have been modified (i.e. Add, Subtract and
--                              Distance).
--                              Auxiliar procedures that were in the original
--                              Date.t file, created by SNI, have been moved
--                              to the file DatePR.t.
-------------------------------------------------------------------------------
*)

SPECIFICATION Date 

IMPORT Duration FROM Duration; --Duration object
IMPORT Stream FROM Stream;   --Stream object
IMPORT NDuration FROM NDuration;
IMPORT Calendar FROM Calendar;
IMPORT WDuration FROM WDuration;

TYPE Date = OBJECT (IN inYear : INT, IN inMonth : INT, IN inDay : INT)

PUBLIC
  METHOD SetToActualDate () ;
    -- Set this date to the actual date.
  METHOD Copy () : Date;
    -- Return a copy of this date
  METHOD GetYear () : INT;
  METHOD GetMonth () : INT;
  METHOD GetDay () : INT;
    -- Return the specific information of this date
  METHOD GetDayOfWeek () : INT;
  METHOD GetDayOfYear () : INT;
  METHOD GetWeekOfYear () : INT;
    -- Compute some numbers of this date. The DayOfWeek is in the
    -- range 0..6, where 0 is Sunday. The DayOfYear is in the range
    -- 1..366. The WeekOfYear is in the range 1..53.
  METHOD SetDate (IN inYear : INT, IN inMonth : INT, IN inDay : INT);
    -- Set the values of this date
  METHOD Add (IN inExtent : Duration);
  METHOD Subtract (IN inExtent : Duration);
    -- Add or subtract an extent from this date.
  METHOD NDistance (IN inEndDate : Date) : NDuration;
    -- Return the number of days between this date and the EndDate.
  METHOD WDistance (IN inEndDate : Date, IN inCalen : Calendar) : WDuration;
    -- Return the number of working days between this date and the EndDate
    -- according to the calendar.
  METHOD IsPassed () : BOOL;
  METHOD IsActual () : BOOL;
  METHOD IsInFuture () : BOOL;
    -- Test this date against the actual time.
  METHOD IsEqual (IN inOperand : Date) : BOOL;
  METHOD IsEarlier (IN inOperand : Date) : BOOL;
  METHOD IsLater (IN inOperand : Date) : BOOL;
    -- Compare this date with the Operand date.
  METHOD Serialize (INOUT ioStream : Stream);
    -- Date state value is stored into ioStream.
  METHOD Deserialize (IN inStream : Stream);
    -- Date state value is loaded from inStream.
  METHOD GetType () : STRING ;
    -- This is an internal method.
    -- Returns a String containing type name. To be redefined by each subtype.

PROTECTED
STATE -- Date
  year : INT;
  month : INT;
  day : INT;

END OBJECT; -- Date

EXCEPTION InvalidDate;

END SPECIFICATION;
