(*
-------------------------------------------------------------------------------
-- Name of the source		: DateRepr.t
-- Author(s)			: SNI
-- Date of creation		: 3 Feb 1992
-- Defined Objects		: DateRepr
-- Description of the contents	: 
-- Document reference		: 
-- Copyright 1993, TAO S.A., Barcelona, Spain
-- This software was produced as part of the ESPRIT project ITHACA-IT.
-------------------------------------------------------------------------------
-- Modification log	:
-- Version	Date	Author	Description
-- ------------ ------- ------- -----------------------------------------------
--				Serialize and Deserialize methods redefined here
-------------------------------------------------------------------------------
*)

SPECIFICATION DateRepr 

IMPORT Date FROM Date;      --Date object

TYPE DateRepr = Date OBJECT (IN inYear : INT, IN inMonth : INT, IN inDay : INT,
                             IN inFormat : STRING)

PUBLIC
  METHOD GetFormat : STRING;
    -- Return the actual format string of this date. The format is  
    -- like the format of the strftime () C-Lib call. 
  METHOD SetFormat (IN inFormat : STRING);
    -- Set the format of this date
  METHOD Present : STRING;
    -- Return this date formatted with its representation

PROTECTED
STATE -- DateRepr
  format : STRING;

END OBJECT; -- DateRepr

END SPECIFICATION;
