(*
-------------------------------------------------------------------------------
-- Name of the source		: Duration.t
-- Author(s)			: 
-- Date of creation		: 13 May 1993
-- Defined Objects		: Duration
-- Description of the contents	: This is a non instanciable type
-- Document reference		: 
-- Copyright 1993, TAO S.A., Barcelona, Spain
-- This software was produced as part of the ESPRIT project ITHACA-IT.
-------------------------------------------------------------------------------
-- Modification log	:
-- Version	Date	Author	Description
-- ------------ ------- ------- -----------------------------------------------
-------------------------------------------------------------------------------
*)

SPECIFICATION Duration 

(*Duration works so that time can be measured in various time units,
years, months, days....
Conversion between different units is not always possible. I.e. 
conversion of months to days is an approximation. Because of this,
we may think of units as grouped in two different sets {years,
semesters, quarters, months}, {weeks, days, hours, minutes, seconds}.
Conversion is possible for units within a set. Error may exist when 
converting from/to units in different sets.
Also a consequence is that an exception can be raised when comparing
durations: NotComparableDurations (when indetermination exists due to
unability of conversion between different units).
*)

IMPORT NDuration FROM NDuration;
IMPORT WDuration FROM WDuration;

TYPE Duration = OBJECT (IN inYears : INT, IN inMonths : INT, IN inDays : INT)

PUBLIC
  METHOD GetYearPart () : INT;
  METHOD GetMonthPart () : INT;
  METHOD GetDayPart () : INT;
  METHOD Copy () : Duration;
    -- Return a copy of this duration
  METHOD Add (IN inExtent : Duration);
  METHOD Subtract (IN inExtent : Duration); 
  METHOD Multiply (IN inFactor : INT);
  METHOD Divide (IN inDivisor : INT);
    -- Add or subtract an extent to or from this duration, multiply or
    -- divide this duration by a number.  
  METHOD IsEqual (IN inOperand : Duration) : BOOL;
  METHOD IsShorter (IN inOperand : Duration) : BOOL;
  METHOD IsLonger (IN inOperand : Duration) : BOOL;
    -- Compare this duration with the operand Duration.
  METHOD IsNull () : BOOL;
    -- Compare the actual duration with the null duration.
  METHOD ToMonths () : INT;
    -- Converts years and months to months. (Internal method)
    -- It is used to compare two Durations.
  METHOD ToSeconds () : INT;
    -- Converts days to seconds (Internal method redefined in subtypes).
    -- It is used to compare two Durations.

PROTECTED
STATE -- Duration
  years : INT;
  months : INT;
  days : INT;

END OBJECT; -- Duration

EXCEPTION NegativeDuration;

END SPECIFICATION;
