(*
-------------------------------------------------------------------------------
-- Name of the source		: FileStream.t
-- Author(s)			: Jose Luis Albero
-- Date of creation		: 8/7/93
-- Defined Objects		: FileStream 
-- Description of the contents	: Object representing a file stream   
-- Document reference		: 
-- Copyright 1993, TAO S.A., Barcelona, Spain
-- This software was produced as part of the ESPRIT project ITHACA-IT.
-------------------------------------------------------------------------------
-- Modification log	:
-- Version	Date	Author	Description
-- ---------- --------- ------- -----------------------------------------------
-------------------------------------------------------------------------------
*)

SPECIFICATION FileStream 

IMPORT Stream FROM Stream;   --Stream object
IMPORT FILE FROM Basics;

EXCEPTION FileNameNeeded;
EXCEPTION OpenFileError;
EXCEPTION CloseFileError;


TYPE FileStream = Stream OBJECT (IN inMode : CHAR, IN inName : STRING)

--NEW (IN inMode : INT, IN inName : STRING);
--inMode contains open mode. Valid values are STREAM_READ and STREAM_WRITE
--inName contains name of file, optionally can include path name.
--       file name can not be null

PUBLIC
PROTECTED
STATE
stFile : REF FILE;

END OBJECT; -- FileStream


END SPECIFICATION;
