-- ***************************************************************
-- CoLibri
-- ---------------------------------------------------------------
--
-- Node.cs -- 
-- 
--   Copyright (C) sietec Systemtechnik GmbH & Co OHG 1994
--   All rights reserved
-- 
-- Author          : Lutz Hilken
-- 
-- PURPOSE 
--      |>Description of modules purpose<|
--
-- REFER
--      |>Documents with client documentation<|
--
-- ---------------------------------------------------------------
--
-- Created On      : Wed Jan 12 14:57:15 1994
-- Last Modified By: Karl-Heinz Koester
-- Last Modified On: Wed Feb 23 14:55:02 1994
-- Update Count    : 10
-- 
-- ***************************************************************

SPECIFICATION Node

TYPE Node [Element] = 
ABSTRACT OBJECT

-- ---------------------------------------------------------------
-- General
-- ---------------------------------------------------------------
-- Objects of this class represent list entries, the begin
-- margin and the end margin. This class is a deffered class, which
-- only provides the interface. The subclasses are defining the
-- margins and the entry nodes.
-- ---------------------------------------------------------------

PUBLIC

-- -----------------------------------------------------------------
-- Access to the STATE
-- -----------------------------------------------------------------

  ABSTRACT METHOD GetEntry () : Element;
  ABSTRACT METHOD SetEntry (IN entry : Element);
  -- -----------------------------------------------------------------
  -- Deliver and set the entry of this list entry.
  -- -----------------------------------------------------------------

  ABSTRACT METHOD GetFront () : Node [Element];
  ABSTRACT METHOD GetTail  () : Node [Element];
  -- -----------------------------------------------------------------
  -- Deliver the list before and after this list entry.
  -- -----------------------------------------------------------------

-- -----------------------------------------------------------------
-- Adding and removing entires
-- -----------------------------------------------------------------

  ABSTRACT METHOD Insert (IN entry : Node [Element]);
  -- -----------------------------------------------------------------
  -- Insert ENTRY after this entry.
  -- -----------------------------------------------------------------

  ABSTRACT METHOD Delete ();
  -- -----------------------------------------------------------------
  -- Remove this entry.
  -- -----------------------------------------------------------------

  ABSTRACT METHOD IsBeginMargin () : BOOL;
  ABSTRACT METHOD IsEndMargin   () : BOOL;
  -- -----------------------------------------------------------------
  -- Test this entry for the margins.
  -- -----------------------------------------------------------------
  
  ABSTRACT METHOD SetFront (IN front : Node [Element]); 
  ABSTRACT METHOD SetTail  (IN tail  : Node [Element]); 

PROTECTED
  
STATE

END OBJECT;

-- ---------------------------------------------------------------

TYPE BeginMargin [Element] = Node 
OBJECT

-- ---------------------------------------------------------------
-- General 
-- ---------------------------------------------------------------
-- Objects of this Type defines a list begin margin at the offleft of
-- a list. It inherits all methods of its superclass but handles this
-- object special. 
-- ---------------------------------------------------------------

PUBLIC

  METHOD GetEntry () : Element;
  METHOD SetEntry (IN entry : Element);
  -- -----------------------------------------------------------------
  -- Deliver and set the entry of this list entry.
  -- -----------------------------------------------------------------

  METHOD GetFront () : Node [Element];
  METHOD GetTail  () : Node [Element];
  -- -----------------------------------------------------------------
  -- Deliver the list before and after this list entry.
  -- -----------------------------------------------------------------

-- -----------------------------------------------------------------
-- Adding and removing entires
-- -----------------------------------------------------------------

  METHOD Insert (IN entry : Node [Element]);
  -- -----------------------------------------------------------------
  -- Insert ENTRY after this entry.
  -- -----------------------------------------------------------------

  METHOD Delete ();
  -- -----------------------------------------------------------------
  -- Remove this entry.
  -- -----------------------------------------------------------------

  METHOD IsBeginMargin () : BOOL;
  METHOD IsEndMargin   () : BOOL;
  -- -----------------------------------------------------------------
  -- Test this entry for the margins.
  -- -----------------------------------------------------------------

  METHOD SetFront (IN front : Node [Element]); 
  METHOD SetTail  (IN tail  : Node [Element]); 
  
PROTECTED
  
STATE

  Tail : Node [Element];
  -- --------------------------------------------------------------
  -- The list from which we are the begin margin.
  -- --------------------------------------------------------------

END OBJECT;

-- ---------------------------------------------------------------

TYPE EndMargin [Element] = Node
OBJECT

-- ---------------------------------------------------------------
-- General 
-- ---------------------------------------------------------------
-- Objects of this class defines a list end margin at the offright of
-- a list. It inherits all methods of list but handles this object
-- special.
-- ---------------------------------------------------------------

PUBLIC

  METHOD GetEntry () : Element;
  METHOD SetEntry (IN entry : Element);
  -- -----------------------------------------------------------------
  -- Deliver and set the entry of this list entry.
  -- -----------------------------------------------------------------

  METHOD GetFront () : Node [Element];
  METHOD GetTail  () : Node [Element];
  -- -----------------------------------------------------------------
  -- Deliver the list before and after this list entry.
  -- -----------------------------------------------------------------

-- -----------------------------------------------------------------
-- Adding and removing entires
-- -----------------------------------------------------------------

  METHOD Insert (IN entry : Node [Element]);
  -- -----------------------------------------------------------------
  -- Insert ENTRY after this entry.
  -- -----------------------------------------------------------------

  METHOD Delete ();
  -- -----------------------------------------------------------------
  -- Remove this entry.
  -- -----------------------------------------------------------------

  METHOD IsBeginMargin () : BOOL;
  METHOD IsEndMargin   () : BOOL;
  -- -----------------------------------------------------------------
  -- Test this entry for the margins.
  -- -----------------------------------------------------------------

  METHOD SetFront (IN front : Node [Element]); 
  METHOD SetTail  (IN tail  : Node [Element]); 

PROTECTED
  
STATE

  Front : Node [Element];
  -- -----------------------------------------------------------------
  -- The list we are end margin
  -- -----------------------------------------------------------------

END OBJECT;

-- ---------------------------------------------------------------

TYPE Entry [Element] = Node
OBJECT

-- ---------------------------------------------------------------
-- General 
-- ---------------------------------------------------------------
-- Objects of this class define normal list entries. This class
-- inherits all methods of list but handles this object like an
-- entry. 
-- ---------------------------------------------------------------

PUBLIC

  METHOD GetEntry () : Element;
  METHOD SetEntry (IN entry : Element);
  -- -----------------------------------------------------------------
  -- Deliver and set the entry of this list entry.
  -- -----------------------------------------------------------------

  METHOD GetFront () : Node [Element];
  METHOD GetTail  () : Node [Element];
  -- -----------------------------------------------------------------
  -- Deliver the list before and after this list entry.
  -- -----------------------------------------------------------------

-- -----------------------------------------------------------------
-- Adding and removing entires
-- -----------------------------------------------------------------

  METHOD Insert (IN entry : Node [Element]);
  -- -----------------------------------------------------------------
  -- Insert ENTRY after this entry.
  -- -----------------------------------------------------------------

  METHOD Delete ();
  -- -----------------------------------------------------------------
  -- Remove this entry.
  -- -----------------------------------------------------------------

  METHOD IsBeginMargin () : BOOL;
  METHOD IsEndMargin   () : BOOL;
  -- -----------------------------------------------------------------
  -- Test this entry for the margins.
  -- -----------------------------------------------------------------

  METHOD SetFront (IN front : Node [Element]); 
  METHOD SetTail  (IN tail  : Node [Element]); 
  
PROTECTED
  
STATE

  Entry : Element;			 -- The entry of a given type
  Front : Node [Element];		 -- The previous list
  Tail  : Node [Element];		 -- The next list

END OBJECT;

EXCEPTION NoEntry;
EXCEPTION NoPreviousEntry;
EXCEPTION NoNextEntry;
EXCEPTION ImpossibleInsert;
EXCEPTION ImpossibleDelete;

-- ***************************************************************
CONST spec_vid : STRING = 
   "@(#) $__Header$" ;

END SPECIFICATION (* Node *);
