'[^']' {  /* normal character example : 'a' */
  yylval.attr[1] = (long) yytext [1];
  yysetpos();
  return CHARCONST;
}
'\\.' { /* escaped character */
  unsigned char c;
  
  switch (yytext [2]) {
  case 'n' : c = '\n'; break;
  case 't' : c = '\t'; break;
  case 'v' : c = '\v'; break;
  case 'a' : c = '\a'; break;
  case 'b' : c = '\b'; break;
  case 'r' : c = '\r'; break;
  case 'f' : c = '\f'; break;
  case '0' : c = '\0'; break;
  default :  c =  yytext [2]; break;
  }
  yylval.attr[1] = (long) c;
  yysetpos();
  return CHARCONST;
}
'\\[0-7][0-7][0-7]' { /* character given as octal number */
  long l;
  int i;
  unsigned char c;
  
  for (i = 2, l =0; i <= 4; i++) {
    l = l * 8 + (yytext [i] - '0');
  }
  yylval.attr[1] = (long) l;
  yysetpos();
  return CHARCONST;
}
