/*--------------------------------------------------------------------*/
/* C functions used by constant evaluation */
/*--------------------------------------------------------------------*/

#include <stdio.h>
#include <stdlib.h>


/*--------------------------------------------------------------------*/
/* Int functions */
/*--------------------------------------------------------------------*/

long IsLessInt (unsigned long x, unsigned long y)
{
  return (x < y);
}

long IsEqualInt (unsigned long x, unsigned long y)
{
  return (x == y);
}

void ModInt (unsigned long x, unsigned long y, unsigned long *z)
{
  *z = x % y;
}

/*--------------------------------------------------------------------*/
/* double functions */
/*--------------------------------------------------------------------*/

long IsLessDouble (double *x, double *y)
{
  return (*x < *y);
}

long IsEqualDouble (double *x, double *y)
{
  return (*x == *y);
}

long IsZeroDouble (double *x)
{
  return (*x == 0.0);
}

long IsNegativeDouble (double *x)
{
  return (*x < 0.0);
}

void NegateDouble (double *x, double **z)
{
  *z = (double *) malloc (sizeof (double));
  **z = - (*x);
}

void PlusDouble (double *x, double *y, double **z)
{
  *z = (double *) malloc (sizeof (double));
  **z = *x + *y;
}

void MinusDouble (double *x, double *y, double **z)
{
  *z = (double *) malloc (sizeof (double));
  **z = *x - *y;
}

void TimesDouble (double *x, double *y, double **z)
{
  *z = (double *) malloc (sizeof (double));
  **z = *x * *y;
}

void DivDouble (double *x, double *y, double **z)
{
  *z = (double *) malloc (sizeof (double));
  **z = *x / *y;
}

/*--------------------------------------------------------------------*/
/* Char functions */
/*--------------------------------------------------------------------*/

long IsLessChar (char x, char y)
{
  return (x < y);
}

long IsEqualChar (char x, char y)
{
  return (x == y);
}

/*--------------------------------------------------------------------*/
/* String functions */
/*--------------------------------------------------------------------*/

long IsLessString (char *x, char *y)
{
  return (strcmp (x,y) == -1);
}

long IsEqualString (char *x, char *y)
{
  return (strcmp (x,y) == 0);
}

void PlusStringString (char *x, char *y, char **z)
{
  while (*x != '\0') {
    AppendToString (*x); x++;
  }
  while (*y != '\0') {
    AppendToString (*y); y++;
  }
  GetStringRef (z);
}  

void PlusStringChar (char *x, char y, char **z)
{
  while (*x != '\0') {
    AppendToString (*x); x++;
  }
  AppendToString (y);
  GetStringRef (z);
}

void PlusCharString (char x, char *y, char **z)
{
  AppendToString (x);
  while (*y != '\0') {
    AppendToString (*y); y++;
  }
  GetStringRef (z);
}

void PlusCharChar (char x, char y, char **z)
{
  AppendToString (x);
  AppendToString (y);
  GetStringRef (z);
}

void StringLength (char *string, long *length)
{
  *length = strlen (string);
}

/*--------------------------------------------------------------------*/
/* conversions */
/*--------------------------------------------------------------------*/

void IntToDouble (unsigned long x, double **z)
{
  *z = (double *) malloc (sizeof (double));
  **z = x;
}

void DoubleToInt (double *x, unsigned long *z)
{
  *z = *x;
}


