
'module' ast

'export'
     -- modules
     MODULE IMPORT
     -- declarations
     DECL FPARAMLIST FPARAM CLASSINTERFACE SUPERTYPE ABSTRACT ACCESSMODE
     METHODFLAG PMODE
     -- types
     TYPEINDEXLIST TYPEINDEX TYPE SIMPLETYPE GENERICTYPE COMPOSITETYPE
     TYPEFLAG FIELD ENUMERATORLIST ENUMERATOR
     -- statments
     BLOCK STMT CASE TYPECASE STEP HANDLER
     -- expressions
     EXPRLIST EXPR RECEIVER DOP MOP APARAMLIST APARAM
     -- identifiers
     ID QUALIFIER MEANING EXPORTFLAG CALLCONV STATE
     
'use' extspecs
     
---------------------------------------------------------------------------
-- Modules
---------------------------------------------------------------------------

'type' MODULE
     seq            (Left    : MODULE, 
		     Right   : MODULE)
     specification  (Id      : ID, 
		     Imports : IMPORT, 
		     Specs   : DECL)
     implementation (Id      : ID,
		     Imports : IMPORT, 
		     Impls   : DECL)
     nil
         
'type' IMPORT
     seq           (Left   : IMPORT, 
		    Right  : IMPORT)
     importitem    (Module : ID, 
		    Item   : ID)
     importmodule  (Module : ID)
     importforeign (file   : STRING)
     nil
     
---------------------------------------------------------------------------
-- Declarations
---------------------------------------------------------------------------

'type' DECL 
     seq           (Pos	      : POS, 
		    Left      : DECL, 
		    Right     : DECL)
     nil           (Pos	      : POS)
-- typedecl
     type          (Pos	      : POS,
		    Id	      : ID,
		    Type      : TYPEINDEX)
     class         (Pos       : POS,
		    Id        : ID,
		    Genparams : FPARAMLIST,
		    Interface : CLASSINTERFACE,
		    Methimpls : DECL)
     classspec     (Pos       : POS,
		    Id        : ID,
		    Genparams : FPARAMLIST, 
		    Interface : CLASSINTERFACE)
     classimpl     (Pos       : POS,
		    Id        : ID,
		    Methimpls : DECL)
-- methoddecl
     methodspec    (Pos       : POS,
		    Id        : ID,
		    Mode      : ACCESSMODE,
		    Abstract  : ABSTRACT, 
		    Flag      : METHODFLAG,
		    Params    : FPARAMLIST,
		    Result    : TYPEINDEX)
     methodimpl    (Pos       : POS,
		    Id        : ID,
		    Flag      : METHODFLAG,
		    Params    : FPARAMLIST,
		    Result    : TYPEINDEX,
		    Lvars     : DECL,
		    Body      : BLOCK)
     initially     (Pos       : POS,
		    Fparams   : FPARAMLIST, 
		    Lvars     : DECL,
		    Body      : BLOCK) 
     finally       (Pos       : POS,
		    Lvars     : DECL, 
		    Body      : BLOCK)
-- constdecl
     const         (Pos       : POS,
		    Id        : ID,
		    Type      : TYPEINDEX, 
		    Value     : EXPR)
-- vardecl
     globalvar     (Pos       : POS,
		    Id        : ID, 
		    Export    : EXPORTFLAG,
		    Type      : TYPEINDEX, 
		    Init      : EXPR)
     localvar      (Pos       : POS,
		    Id        : ID, 
		    Type      : TYPEINDEX, 
		    Init      : EXPR)
     instvar       (Pos       : POS,
		    Id        : ID,
		    Type      : TYPEINDEX)
     implicitvar   (Pos       : POS,
		    Id        : ID)
-- exceptiondecl
     exception     (Pos       : POS,
		    Id        : ID,
		    Params    : FPARAMLIST)
-- procdecl
     procspec      (Pos       : POS,
		    Id        : ID,
		    Export    : EXPORTFLAG,
		    CallConv  : CALLCONV,
		    Params    : FPARAMLIST,
		    Return    : TYPEINDEX)
     procimpl      (Pos       : POS,
		    Id        : ID,
		    Params    : FPARAMLIST,
		    Return    : TYPEINDEX,
		    Locals    : DECL,
		    Body      : BLOCK)
-- foreign 
     foreignproc   (Pos       : POS,
		    Id        : ID,
		    CallConv  : CALLCONV,
		    Params    : FPARAMLIST,
		    Return    : TYPEINDEX)
     foreignvar    (Pos       : POS,
		    Id        : ID, 
		    Type      : TYPEINDEX)
     foreigntype   (Pos       : POS,
		    Id        : ID, 
		    Type      : TYPEINDEX)
-- error
     error         (Pos       : POS)

---------------------------------------------------------------------------
-- Specific class declaration terms
---------------------------------------------------------------------------

'type' CLASSINTERFACE
     -- contains only the methods and instance variables declaraed in this
     -- class (only used by syntax and context analysis)
     localdefs (Supertype  : SUPERTYPE,
		Abstract   : ABSTRACT,
		Objparams  : FPARAMLIST,
		Methspecs  : DECL,
		Instvars   : DECL)
     -- contains all exported methods and all instance vars (including all
     -- inherited declarations)
     interface (Supertype  : SUPERTYPE,
		Abstract   : ABSTRACT,
		Objparams  : FPARAMLIST,
		Exportmeth : DECL,
		-- Localmeth  : DECL, -- only use by C++ code generation
		Instvars   : DECL)

'type' SUPERTYPE 
     super (Id : ID)
     none
     error

'type' ABSTRACT
     abstract
     concrete
	
'type' ACCESSMODE
     public
     protected
     private

'type' METHODFLAG
     firstdef 
     defines
     inherited
     redef

---------------------------------------------------------------------------
-- Parameter
---------------------------------------------------------------------------

'type' FPARAMLIST
     fparamlist (FPARAM, 
		 FPARAMLIST)
     ellipsis (POS)
     nil
     error
          
'type' FPARAM
-- formal parameter decl
     fparam        (Pos       : POS,
	            Id        : ID, 
		    Mode      : PMODE, 
	            Type      : TYPEINDEX)
-- formal generic parameter decl
     unconstrained (Pos        : POS,
		    Id         : ID)
     constrained   (Pos        : POS, 
		    Id         : ID, 
		    Constraint : ID)
     
'type' PMODE 
     in
     out
     inout

---------------------------------------------------------------------------
-- Types
---------------------------------------------------------------------------

'type' TYPEINDEXLIST
     typeindexlist  (type : TYPEINDEX,
		     tail : TYPEINDEXLIST)
     nil
     
'table' TYPEINDEX (Pos   : POS,
		   Type  : TYPE,
		   State : STATE,    -- only used by code generation
		   Flag  : TYPEFLAG) -- only used by code generation
     
'type' TYPE
     simple    (Simple    : SIMPLETYPE)
     generic   (Generic   : GENERICTYPE)
     composite (Composite : COMPOSITETYPE)
     unspec -- used by syntax analysis for an yet unknown type of an
	    -- expression 
     error
     
'type' SIMPLETYPE
     void
     bool
     shortint
     unsignedshortint
     int
     unsignedint
     longint
     unsignedlongint
     float
     double
     unsignedchar
     char
     string
     address
     niltype
     error
-- literal types
     intliteraltype
     doubleliteraltype
     stringliteraltype

'type' GENERICTYPE
     genericinst   (Typename     : ID, 
		    Actualparams : TYPEINDEXLIST)
     unconstrained (TypeId       : ID)
     constrained   (TypeId       : ID,
		    Constraint   : ID)
     error

'type' COMPOSITETYPE
-- named type
     typename  (Id : ID)
     unnamed   (Type : TYPEINDEX) -- only used by code generation
-- structured types 
     enum      (Enumerators  : ENUMERATORLIST)
     record    (Fields       : FIELD)
     union     (Fields       : FIELD)
     array     (Range        : EXPR, 
	        Basetype     : TYPEINDEX)
     openarray (Basetype     : TYPEINDEX)
     ref       (Referredtype : TYPEINDEX)
     procedure (Params       : FPARAMLIST,
		Resulttype   : TYPEINDEX)
     method    (Params       : FPARAMLIST,
		Resulttype   : TYPEINDEX),
     classtype (Id         : ID,
		Genparams    : FPARAMLIST, 
		Interface    : CLASSINTERFACE)
     error
	
'type' FIELD 
     seq        (Left  : FIELD,
		 Right : FIELD)
     field      (Pos   : POS,
		 Id    : ID,
		 Type  : TYPEINDEX)
     error
     nil

'type' ENUMERATORLIST
     enumeratorlist (ENUMERATOR,
		     ENUMERATORLIST)
     nil
     
'type' ENUMERATOR
     enumerator (Pos : POS,
		 Id  : ID)

'type' TYPEFLAG  -- used by code generation
     unspecified
     specified
     
---------------------------------------------------------------------------
-- Statements
---------------------------------------------------------------------------

'type' BLOCK
     block (BeginPos : POS,
	    EndPos   : POS,
	    Body     : STMT)     
     error
     
'type' STMT 
     seq         (Pos       : POS, 
		  Left      : STMT, 
		  Right     : STMT)
     assign      (Pos       : POS, 
		  DestType  : TYPEINDEX,
		  Dest      : EXPR, 
		  Source    : EXPR)
     stmtcall    (Pos       : POS,
		  Call      : EXPR)
     return      (Pos       : POS)
     returnvalue (Pos       : POS,
		  Value     : EXPR)
     ifelse      (Pos       : POS,
		  Cond      : EXPR,
		  Then      : STMT,
		  Else      : STMT)
     select      (Pos       : POS, 
		  Cond      : EXPR, 
		  Cases     : CASE,
		  Otherwise : STMT)
     typeselect  (Pos       : POS, 
		  Implicit  : DECL,
		  Init      : EXPR,
		  Typecases : TYPECASE,
		  Otherwise : STMT)
     loop        (Pos       : POS, 
		  Body      : BLOCK)
     while       (Pos       : POS,
		  Cond      : EXPR,
		  Body      : BLOCK)
     for         (Pos       : POS,
		  Implicit  : DECL,
	          Range     : EXPR,
	          Step      : STEP,
		  Body      : BLOCK)
     exit        (Pos       : POS)
     raise       (Pos       : POS,
		  Exception : ID,
		  Params    : APARAMLIST)
     try         (Pos       : POS, 
		  Body      : STMT, 
		  Handlers  : HANDLER, 
		  Otherwise : STMT)
     retry       (Pos	    : POS)
     reraise     (Pos	    : POS)
     delete      (Pos	    : POS,
		  Object    : EXPR)
     nil         (Pos       : POS)
     error       (Pos       : POS)

---------------------------------------------------------------------------
-- SELECT and TYPESELECT statement
---------------------------------------------------------------------------

'type' CASE 
     seq  (Left   : CASE, 
	   Right  : CASE)
     case (Pos    : POS, 
	   Labels : EXPRLIST, 
	   Body   : STMT)
     nil -- possibly superfluous

'type' TYPECASE 
     seq      (Left     : TYPECASE, 
	       Right    : TYPECASE)
     typecase (Pos      : POS, 
	       Typename : ID, 
	       Body     : STMT)
     nil -- possibly superfluous

-------------------------------------------------------------------------------
-- Loop statement
-------------------------------------------------------------------------------

'type' STEP
     incr (Value : EXPR)
     decr (Value : EXPR)	
	
---------------------------------------------------------------------------
-- TRY statment
---------------------------------------------------------------------------

'type' HANDLER 
     seq     (Left   : HANDLER, 
	      Right  : HANDLER)
     handler (Pos    : POS, 
	      Id     : ID,
	      Params : FPARAMLIST,
	      Body   : STMT)
     nil

---------------------------------------------------------------------------
-- Expressions
---------------------------------------------------------------------------
	
'type' EXPRLIST
     exprlist (EXPR, 
	       EXPRLIST)
     error
     nil

'type' EXPR 
     -- constant expressions
     false         (Pos   : POS)
     true          (Pos   : POS)
     posintliteral (Pos   : POS, 
		    Value : INT)
     negintliteral (Pos   : POS, 
		    Value : INT)
     doubleliteral (Pos   : POS, 
		    Value : DOUBLE)
     charliteral   (Pos   : POS, 
		    Value : CHAR)
     stringliteral (Pos   : POS, 
		    Value : STRING)
     expr_nil      (Pos   : POS)
     
     dyop      (Pos	   : POS,
		Type	   : TYPEINDEX,
		Operator   : DOP,
		Left	   : EXPR, 
		Right	   : EXPR)
     monop     (Pos	   : POS,
		Type	   : TYPEINDEX,
		Operator   : MOP,
		Operand	   : EXPR)
     adr       (Pos	   : POS, 
		Desig	   : EXPR)
     sizeof    (Pos	   : POS, 
		Type	   : TYPEINDEX)
     -- dot is only used by syntax and context analysis
     -- fieldsel, unionsel and enumsel are specialized
     -- dot-expresssion generated by the context analysis
     dot       (Pos	   : POS, 
		Desig	   : EXPR, 
		Ident	   : ID)
     fieldsel  (Pos        : POS,                     
		Fieldtype  : TYPEINDEX,
		Record	   : EXPR,
		Fieldname  : ID)
     unionsel  (Pos        : POS,			
		Fieldtype  : TYPEINDEX,
		Union	   : EXPR,
		Fieldname  : ID)
     enumsel   (Pos	   : POS,
		Enumtype   : TYPEINDEX,
		Enumerator : ID,
		Number     : INT)
     methodpointer (Pos    : POS,
		Result     : TYPEINDEX,
		Object     : EXPR,
		Method     : ID),
     -- subscr is only used by syntax and context analysis
     -- arraysubscr and stringsubscr are specialized
     -- subscr-expresssion generated by the context analysis
     subscr    (Pos        : POS, 
		Desig      : EXPR, 
		Index      : EXPR)
     arraysubscr (Pos        : POS, 
		Type       : TYPEINDEX,
		Desig      : EXPR, 
		Index      : EXPR)
     stringsubscr (Pos        : POS, 
		Desig      : EXPR, 
		Index      : EXPR)
     substring (Pos        : POS, 
		String     : EXPR, 
		Range      : EXPR)
     range     (Pos        : POS,
		Lwb        : EXPR,
		Upb        : EXPR)
     deref     (Pos        : POS,
		Type       : TYPEINDEX, 
		Reference  : EXPR)
     applied   (Pos        : POS, 
		Id         : ID)
     current   (Pos        : POS)
     call      (Pos        : POS,
		SpecResult : TYPEINDEX,
		RealResult : TYPE, 
		Receiver   : RECEIVER,
		Params     : APARAMLIST)
     -- callexpr, super and new are generated by the syntax analysis and
     -- transformed to call by the context analysis.
     callexpr  (Pos        : POS, 
		Function   : EXPR, 
		Params     : APARAMLIST)
     super     (Pos        : POS)
     new       (Pos        : POS, 
		Type       : TYPEINDEX)
     error     (Pos        : POS)
     nil       (Pos        : POS)
     
'type' DOP 
     or
     and
     eq
     ne
     lt
     le
     gt
     ge
     plus
     minus
     times
     div
     idiv
     mod

'type' MOP 
     minus
     plus
     not

'type' RECEIVER
     proc        (Id        : ID)
     foreignproc (Id        : ID)
     method      (Object    : EXPR, 
		  Method    : ID)
     localmethod (Class     : ID, 
		  Method    : ID)
     super       (SuperType : ID, 
		  Method    : ID)
     new         (Type      : TYPEINDEX)
     procexpr    (Function  : EXPR)
     methodexpr  (MethodPtr : EXPR)
     error
     
'type' APARAMLIST
     aparamlist (APARAM,
		 APARAMLIST)
     error
     nil
     
'type' APARAM
     in     (Param : EXPR)
     out    (Param : EXPR)
     inout  (Param : EXPR)
     unspec (Param : EXPR) -- used by syntax analysis
     
---------------------------------------------------------------------------
-- Identifiers
---------------------------------------------------------------------------

'table' ID (Pos     : POS,
	    Ident   : Ident,
	    Module  : QUALIFIER,
	    State   : STATE,    -- only used by context analysis and code 
			        -- generation. The state is not marked and 
			        -- not generated at the beginning of the
				-- code generation. 
	    Meaning : MEANING)
     
'type' QUALIFIER
     actual
     module (Id : ID)
	
'type' MEANING
     definingid  (ID)
     module      (Specs	   : DECL)
     type        (Type	   : TYPEINDEX)
     method      (Mode	   : ACCESSMODE,
		  Abstract : ABSTRACT,
		  Params   : FPARAMLIST, 
		  Result   : TYPEINDEX)
     proc        (Export   : EXPORTFLAG,
		  CallConv : CALLCONV,
		  Params   : FPARAMLIST, 
		  Result   : TYPEINDEX)
     const       (Type	   : TYPEINDEX, 
		  Value	   : EXPR)
     globalvar   (Export   : EXPORTFLAG,
		  Type	   : TYPEINDEX)
     localvar    (Type	   : TYPEINDEX)
     instvar     (Type	   : TYPEINDEX)
     implicitvar (Type     : TYPEINDEX) 
     exception   (Params   : FPARAMLIST)
     fparam      (Mode	   : PMODE, 
		  Type	   : TYPEINDEX)
     field       (Type	   : TYPEINDEX)
     enumerator
     
     foreignvar  (Type     : TYPEINDEX)
     foreignproc (CallConv : CALLCONV,
		  Params   : FPARAMLIST, 
		  Result   : TYPEINDEX)
     foreigntype (Type     : TYPEINDEX)
     
     internal
     unspec
     noobj
     error
     
'type' EXPORTFLAG
     root
     foreign
     cool

'type' CALLCONV
     c
     pascal

'type' STATE
     -- used by context analysis
     undeclared
     declared
     included
     checked
     transformed
     
     -- used by code generation
     marked
     generated

---------------------------------------------------------------------------

'end'
