
#ifndef _FILES_H /* if not defined then files.h has not yet been included */
#define _FILES_H
#include <stdio.h>
#include "idents.h"

/*--------------------------------------------------------------------*/
/* EXPORTS */

#define bool int
#define FALSE 0
#define TRUE  1

/* output suffixes */
#define HEADER_SUFFIX ".h"
#define DEST_SUFFIX   ".c"
#define MAX_SUFFIX    ".c2m"

typedef struct FileIdRec FileId;

void InitFiles (void);

void InsertDir (char *);

void OpenFile (char *);
FILE * NextFile (void);
void InsertImportFile (Ident);

void InsertLinePragmat (char *, long);
void InsertLinePragmatNoFilename (long);

void fprintFileId (FILE *, FileId *);
void PrintDependencies (void);
void CheckSpecModuleName (long, Ident);
void CheckImplModuleName (long, Ident);

FILE * OpenOutputFile (char * suffix);

void DumpFileTab (void);

#endif  /* _FILES_H */
