/* CYFRONT -- GENTLE C/YACC FRONTEND -- VERSION 0.0 (220) */
/* COPYRIGHT (C) 1992 F.W. SCHROEER,  ALL RIGHTS RESERVED */

/* Gentle run time system */

#define PRIVATE static
#define PUBLIC

PRIVATE char *thisversion = "@(#)Cyfront 0.0 (220)";

PUBLIC yyInit(required)
   char *required;
{
   char * expected;
   expected = &thisversion[4];
   if (strcmp(expected, required) != 0) {
      printf("invalid grts version (installed: %s, required: %s)\n",
      expected, required);
      exit(1);
   }
   yyExtend();
}

typedef long * yyt;

PUBLIC yyt yyh;
PUBLIC yyt yyhx;

#define HEAPPIECE 20000

PUBLIC yyExtend()
{
   yyh = (yyt) malloc(HEAPPIECE * sizeof(long));
   yyhx = yyh + HEAPPIECE - 100;
   if (yyh == 0) {
      printf ("HEAP STORAGE FULL\n");
      exit(1);
   }
}

#define yyCntlMax 500

PRIVATE yyt CURBLOCK;
PRIVATE yyt CURPOS;
PRIVATE yyt FIRSTBLOCK;

PRIVATE yyt FREELIST = 0;

PRIVATE yyt NEWBLOCK()
{
   yyt p;

   if (FREELIST == 0) {
      p = (yyt) malloc (sizeof (yyt) * (yyCntlMax + 200));
      if (p == 0) {
	 printf("NEWBLOCK: running out of memory\n");
	 exit(1);
      }
   }
   else {
      p = FREELIST;
      FREELIST = (yyt) *p;
   }

   return p;
}

PRIVATE FREEBLOCK (p)
   yyt p;
{
   *p = (long) FREELIST;
   FREELIST = p;
}

PUBLIC yyt yyAllocCntl(n)
{
   yyt p;
   p = CURPOS;
   CURPOS += n;
   if (CURPOS >= CURBLOCK+yyCntlMax) {
      yyt b;
      b = NEWBLOCK();
      *b = 0;
      *CURBLOCK = (long) b;
      CURBLOCK = b;
      CURPOS = CURBLOCK + 1;
      p = CURPOS;
      CURPOS += n;
   }
   return p;
}

typedef struct {
   yyt firstblock;
   yyt curblock;
   yyt curpos;
} yysave;

PUBLIC yyt yyBeginChoice(ref_saved)
   yysave *ref_saved;
{
   ref_saved->curblock = CURBLOCK;
   ref_saved->curpos = CURPOS;
   ref_saved->firstblock = FIRSTBLOCK;

   FIRSTBLOCK = NEWBLOCK();
   *FIRSTBLOCK = 0;
   CURBLOCK = FIRSTBLOCK;
   CURPOS = CURBLOCK + 1;
}

PUBLIC yyEndChoice(saved)
   yysave saved;
{
   yyt p;

   p = FIRSTBLOCK;
   while (p != (yyt) 0) {
      yyt next;
      next = (yyt) *p;
      FREEBLOCK(p);
      p = next;
   }

   CURBLOCK = saved.curblock;
   CURPOS = saved.curpos;
   FIRSTBLOCK = saved.firstblock;
}

PUBLIC yyAbort (Code, FileName, Line)
   int Code;
   char * FileName;
   int Line;
{
   switch(Code) {
   case 1:
      printf ("Undefined value in \"%s.g\", line %d\n", FileName, Line);
      exit(1);
   case 2:
      printf ("No rule applicable in \"%s.g\", line %d\n", FileName, Line);
      exit(1);
   case 3:
      printf ("Selected grammar rule failed in \"%s.g\", line %d\n",
	 FileName, Line);
      exit(1);
   case 4:
      printf ("Selected CHOICE rule failed in \"%s.g\", line %d\n",
	 FileName, Line);
      exit(1);
   default:
      printf ("Error %d (?) in \"%s.g\", line %d\n", Code, FileName, Line);
      exit(1);
   }
}

PUBLIC yyPrintOpaque (i)
   long i;
{
   printf("<<%d>>", i);
}

PUBLIC yyPrintIndex (i)
   long i;
{
   printf("#%d", i);
}

PUBLIC yyPrint_INT (i)
   long i;
{
   printf("%d", i);
}

PUBLIC yyPrint_POS (i)
   long i;
{
   printf("%d", i);
}

#define STRINGLENGTH 40

PUBLIC yyPrint_STRING (Str)
   char *Str;
{
   char OutBuf[STRINGLENGTH];
   char * OutBufPtr;
   OutBufPtr = &OutBuf[0];

   while(*Str) {
      if (OutBufPtr > &OutBuf[STRINGLENGTH-4]) {
	 *OutBufPtr++ = '.';
	 *OutBufPtr++ = '.';
	 *OutBufPtr++ = '.';
	 break;
      }

      switch (*Str) {

      case '\\':
	 *OutBufPtr++ = '\\';
	 *OutBufPtr++ = '\\';
	 Str++;
	 break;
      case '\n':
	 *OutBufPtr++ = '\\';
	 *OutBufPtr++ = 'n';
	 Str++;
	 break;
      case '\"':
	 *OutBufPtr++ = '\\';
	 *OutBufPtr++ = '"';
	 Str++;
	 break;

      default:
         *OutBufPtr++ = *Str++; 
      }
   }
   *OutBufPtr = '\0';

   printf("\"%s\"", OutBuf);
}

PRIVATE long yyIndentation = 0;

PRIVATE yyIndent()
{
   int i;

   for (i = 1; i <= yyIndentation;  i++) {
      printf("   ");
   }
}

PUBLIC yyTerm(f)
{
   printf("%s", f);
}

PUBLIC yyFirstArg()
{
   printf("(\n");
   yyIndentation++;
   yyIndent();
}

PUBLIC yyNextArg()
{
   printf(",\n");
   yyIndent();
}

PUBLIC yyEndArgs()
{
   yyIndentation--;
   printf("\n");
   yyIndent();
   printf(")");
}

PUBLIC yyNoArgs()
{
   ;
}

PUBLIC yyEndPrint()
{
   printf("\n");
}
