%{
#include "gen.h"
extern YYSTYPE yylval;
#include "pos.h"
#include <stdlib.h>
#include <ctype.h>
#include "idents.h"
void SkipRestOfComment (void);
void SkipRestOfLineComment (void);
void ReadStringLiteral (void);
%}
%p 3000
%n 500
%e 1000
%a 2500
%k 2500
%o 3000
%s SPECIAL
%%
"::" { yysetpos(); return yytoken_101; }
"NEW" { yysetpos(); return yytoken_100; }
"TRUE" { yysetpos(); return yytoken_99; }
"FALSE" { yysetpos(); return yytoken_98; }
"SUPER" { yysetpos(); return yytoken_97; }
"CURRENT" { yysetpos(); return yytoken_96; }
"^" { yysetpos(); return yytoken_95; }
"." { yysetpos(); return yytoken_94; }
"SIZEOF" { yysetpos(); return yytoken_93; }
"NIL" { yysetpos(); return yytoken_92; }
"NOT" { yysetpos(); return yytoken_91; }
"ADR" { yysetpos(); return yytoken_90; }
"MOD" { yysetpos(); return yytoken_89; }
"DIV" { yysetpos(); return yytoken_88; }
"/" { yysetpos(); return yytoken_87; }
"*" { yysetpos(); return yytoken_86; }
"-" { yysetpos(); return yytoken_85; }
"+" { yysetpos(); return yytoken_84; }
">" { yysetpos(); return yytoken_83; }
">=" { yysetpos(); return yytoken_82; }
"<>" { yysetpos(); return yytoken_81; }
"<=" { yysetpos(); return yytoken_80; }
"<" { yysetpos(); return yytoken_79; }
"AND" { yysetpos(); return yytoken_78; }
"OR" { yysetpos(); return yytoken_77; }
"RAISE" { yysetpos(); return yytoken_76; }
"EXCEPT" { yysetpos(); return yytoken_75; }
"TRY" { yysetpos(); return yytoken_74; }
"LOOP" { yysetpos(); return yytoken_73; }
"DECR" { yysetpos(); return yytoken_72; }
"INCR" { yysetpos(); return yytoken_71; }
"FOR" { yysetpos(); return yytoken_70; }
"WHILE" { yysetpos(); return yytoken_69; }
"TYPESELECT" { yysetpos(); return yytoken_68; }
"OTHERWISE" { yysetpos(); return yytoken_67; }
"CASE" { yysetpos(); return yytoken_66; }
"SELECT" { yysetpos(); return yytoken_65; }
"ELSE" { yysetpos(); return yytoken_64; }
"ELSIF" { yysetpos(); return yytoken_63; }
"THEN" { yysetpos(); return yytoken_62; }
"IF" { yysetpos(); return yytoken_61; }
"RETURN" { yysetpos(); return yytoken_60; }
"DELETE" { yysetpos(); return yytoken_59; }
"RERAISE" { yysetpos(); return yytoken_58; }
"RETRY" { yysetpos(); return yytoken_57; }
"EXIT" { yysetpos(); return yytoken_56; }
"REF" { yysetpos(); return yytoken_55; }
"OF" { yysetpos(); return yytoken_54; }
"ARRAY" { yysetpos(); return yytoken_53; }
"UNION" { yysetpos(); return yytoken_52; }
"RECORD" { yysetpos(); return yytoken_51; }
"ENUM" { yysetpos(); return yytoken_50; }
"ADDRESS" { yysetpos(); return yytoken_49; }
"STRING" { yysetpos(); return yytoken_48; }
"CHAR" { yysetpos(); return yytoken_47; }
"DOUBLE" { yysetpos(); return yytoken_46; }
"FLOAT" { yysetpos(); return yytoken_45; }
"LONG" { yysetpos(); return yytoken_44; }
"SHORT" { yysetpos(); return yytoken_43; }
"UNSIGNED" { yysetpos(); return yytoken_42; }
"INT" { yysetpos(); return yytoken_41; }
"BOOL" { yysetpos(); return yytoken_40; }
"EXCEPTION" { yysetpos(); return yytoken_39; }
"CONST" { yysetpos(); return yytoken_38; }
":=" { yysetpos(); return yytoken_37; }
"PASCAL" { yysetpos(); return yytoken_36; }
"INOUT" { yysetpos(); return yytoken_35; }
"OUT" { yysetpos(); return yytoken_34; }
"IN" { yysetpos(); return yytoken_33; }
".." { yysetpos(); return yytoken_32; }
")" { yysetpos(); return yytoken_31; }
"(" { yysetpos(); return yytoken_30; }
"DO" { yysetpos(); return yytoken_29; }
"PROCEDURE" { yysetpos(); return yytoken_28; }
"ROOT" { yysetpos(); return yytoken_27; }
"REDEFINED" { yysetpos(); return yytoken_26; }
"FINALLY" { yysetpos(); return yytoken_25; }
"INITIALLY" { yysetpos(); return yytoken_24; }
"METHOD" { yysetpos(); return yytoken_23; }
"ABSTRACT" { yysetpos(); return yytoken_22; }
"PROTECTED" { yysetpos(); return yytoken_21; }
"PUBLIC" { yysetpos(); return yytoken_20; }
"STATE" { yysetpos(); return yytoken_19; }
"BODY" { yysetpos(); return yytoken_18; }
"OBJECT" { yysetpos(); return yytoken_17; }
"->" { yysetpos(); return yytoken_16; }
"," { yysetpos(); return yytoken_15; }
"]" { yysetpos(); return yytoken_14; }
"[" { yysetpos(); return yytoken_13; }
"=" { yysetpos(); return yytoken_12; }
"TYPE" { yysetpos(); return yytoken_11; }
":" { yysetpos(); return yytoken_10; }
"VAR" { yysetpos(); return yytoken_9; }
"EXPORT" { yysetpos(); return yytoken_8; }
"FOREIGN" { yysetpos(); return yytoken_7; }
"FROM" { yysetpos(); return yytoken_6; }
"IMPORT" { yysetpos(); return yytoken_5; }
"SPECIFICATION" { yysetpos(); return yytoken_4; }
";" { yysetpos(); return yytoken_3; }
"END" { yysetpos(); return yytoken_2; }
"IMPLEMENTATION" { yysetpos(); return yytoken_1; }
[A-Za-z_][A-Za-z0-9_]* { 
   Ident id;
   string_to_id (yytext, &id);
   yylval.attr[1] = (long) id;
   yysetpos();
   return IDENTIFIER;
}
[0-9]+ {
   yylval.attr[1] = atol (yytext);
   yysetpos();
   return INTCONST;
}
[0-9]+"."[0-9]+([eE][-+]?[0-9]+)? {
  double *p;
  
  p = (double *) malloc (sizeof (double));
  *p = atof (yytext);
  yylval.attr[1] = (long) p;
  yysetpos();
  return DOUBLECONST;
}
'[^']' {  /* normal character example : 'a' */
  yylval.attr[1] = (long) yytext [1];
  yysetpos();
  return CHARCONST;
}
'\\.' { /* escaped character */
  unsigned char c;
  
  switch (yytext [2]) {
  case 'n' : c = '\n'; break;
  case 't' : c = '\t'; break;
  case 'v' : c = '\v'; break;
  case 'a' : c = '\a'; break;
  case 'b' : c = '\b'; break;
  case 'r' : c = '\r'; break;
  case 'f' : c = '\f'; break;
  case '0' : c = '\0'; break;
  default :  c =  yytext [2]; break;
  }
  yylval.attr[1] = (long) c;
  yysetpos();
  return CHARCONST;
}
'\\[0-7][0-7][0-7]' { /* character given as octal number */
  long l;
  int i;
  unsigned char c;
  
  for (i = 2, l =0; i <= 4; i++) {
    l = l * 8 + (yytext [i] - '0');
  }
  yylval.attr[1] = (long) l;
  yysetpos();
  return CHARCONST;
}
\" {
  yypos++; /* initial '"' */
  
  ReadStringLiteral ();
  return STRINGCONST;
}
<<EOF>> {
  BEGIN (SPECIAL);
  unput ('@');
  return EOFILE;
}
<SPECIAL>@ {
  FILE * next;

  BEGIN (0);
  next = NextFile ();
  if (next == (FILE *) 0) {
    yyterminate ();
  }
  else {
    yy_delete_buffer (YY_CURRENT_BUFFER);
    yy_switch_to_buffer (yy_create_buffer (next, YY_BUF_SIZE));
    return NEXTUNIT;
  }
}
"(*" {
   yypos++; yypos++; /* initial '(*' */
   SkipRestOfComment ();
}
"--" {
   yypos++; yypos++; /* initial '}' */
   SkipRestOfLineComment ();
}
#[ \t]*(line[ \t]*)?[0-9]+[ \t]*\n { 
   char *start;
   long number;
   start = yytext;
   while (! isdigit (*start))
     start++;
   number = atoi (start);
   /* newline is counted in yyPosToNextFile */
   /* via InsertLinePragmatNoFilename */
   InsertLinePragmatNoFilename (number);
}
#[ \t]*(line[ \t]*)?[0-9]+[ \t]*\"[^"]*\"[ \t]*\n { 
   char *start, *stop;
   long number;
   start = yytext;
   while (! isdigit (*start)) 
     start++;
   number = atoi (start);
   while (*start != '"') 
     start++; 
   start++;
   stop = start;
   while (*stop != '"')
     stop++;
   *stop = '\0';
   /* newline is counted in yyPosToNextFile */
   /* via InsertLinePragmat */
   InsertLinePragmat (start, number);
}
\  { yypos += 1; }
\n { yyPosToNextLine(); }
\t { yypos += 9 - (yyColAtPos (yypos) % 8); } 
. { yysetpos(); yyerror("illegal token"); }
%%

#define EOFCHAR EOF
#define NEXTCHAR (yypos++, input())

/* ---------------------------------------------- */

void SkipRestOfFile (void)
{
  int ch;
  
  ch = NEXTCHAR;
  while (ch != EOFCHAR) {
    ch = NEXTCHAR;
  }
  BEGIN (SPECIAL);
  unput ('@');
}

/* ---------------------------------------------- */

void SkipRestOfComment (void)
{
  int ch;
  int nest = 1;
  
  ch = NEXTCHAR;
  for (;;) {
    switch (ch) {
    case '\n' :
      yyPosToNextLine ();
      ch = NEXTCHAR;
      break;
    case EOFCHAR :
      yylexerror ("unexpected eof in comment");
      exit (1);
      break;
    case '*' : /* possible end of comment */
      ch = NEXTCHAR;
      if (ch == ')') {
	nest--;
	if (nest == 0) { /* reached end of last comment */
	  return;
	}
	ch = NEXTCHAR;
      }
      break;
    case '(' :
      ch = NEXTCHAR;
      if (ch == '*') {
	nest++; 
	ch = NEXTCHAR;
      }
    default :
      ch = NEXTCHAR;
    }
  }
}

/* ---------------------------------------------- */

void SkipRestOfLineComment (void)
{
  int ch;
  
  do {
    ch = NEXTCHAR;
  } while (ch != '\n');
  yyPosToNextLine();
}

/* ---------------------------------------------- */

void ReadStringLiteral (void) 
{
  int ch;
  
  for(;;) {
    ch = NEXTCHAR;
    switch (ch) {
    case EOFCHAR :
      yylexerror("end of file inside string");
      break;
    case '\n' :
      yylexerror("end of line inside string");
      break;
    case '\\' : 
      AppendToString(ch);
      ch = NEXTCHAR;
      AppendToString (ch);
      break;
    case '"' : /* string read */
      yylval.attr [0] = yypos;
      GetStringRef(&yylval.attr[1]);
      return;
      break;
    default :
      AppendToString(ch);
    }
  }
}
#ifndef yywrap
yywrap() { return 1; }
#endif
