-----------------------------------------------------------------------------
--                  CooL-V2.0 - destination code interface                 --
-----------------------------------------------------------------------------
--                          type mapping routines                          --
--                            Version 1.0, 1993                            --
-----------------------------------------------------------------------------

'module' mapping

'export' MAPPING      -- kind of mapping
         MapInterface -- mapping for object types
         MapTypeIndex -- mapping for nonobject types
         MapType
         MapProcedure -- procedure mapping
         MapMethods   -- method mapping
         MapParameterTypes
         MapImportedItem

'use' ast
      extspecs
      misc
      codetype
      coder
      types

-----------------------------------------------------------------------------

'type' MAPPING
    specification
    implementation

-- MapImportedItem ----------------------------------------------------------

'action' MapImportedItem( ID )

     'rule' MapImportedItem( Item )
	  GetDefiningId (Item -> DefId)
	  DefId'Meaning -> type (_)
	  GenerateImportedType (DefId)

    'rule' MapImportedItem( Item )
        GetIdMeaning( Item -> proc( _, _, Params, Result ) )
        MapParameterTypes( Params, specification )
        MapTypeIndex( Result, specification -> Type )

    'rule' MapImportedItem( Item )
        GetIdMeaning( Item -> const( TypeIndex, _ ) )
        MapTypeIndex( TypeIndex, specification -> Type )

    'rule' MapImportedItem( Item )
        GetIdMeaning( Item -> globalvar( _, TypeIndex ) )
        MapTypeIndex( TypeIndex, specification -> Type )

    'rule' MapImportedItem( Item )
        GetIdMeaning( Item -> exception( Params ) )
        MapParameterTypes( Params, specification )

    'rule' MapImportedItem( Item )
        GetIdMeaning( Item -> foreignvar( TypeIndex ) )
        MapTypeIndex( TypeIndex, specification -> Type )

    'rule' MapImportedItem( Item )
        GetIdMeaning( Item -> foreignproc( _, Params, Result ) )
        MapParameterTypes( Params, specification )
	 MapTypeIndex( Result, specification -> Type )
     
     'rule' MapImportedItem (Item) :
	  GetIdMeaning (Item -> foreigntype (TypeI))
	  MapTypeIndex (TypeI, specification -> _)
	  
-- MapTypeIndex -------------------------------------------------------------

'action' MapTypeIndex( TYPEINDEX, MAPPING -> TYPE )

    'rule' MapTypeIndex( TypeIndex, Mapping -> Type )
        TransformTypeIndex( TypeIndex -> Type )
        MapType( Type, Mapping )

-----------------------------------------------------------------------------
-- mapping routines for generic object types                               --
-----------------------------------------------------------------------------

-- MapGenericType -----------------------------------------------------------

'action' MapGenericType( GENERICTYPE, MAPPING )

    -- Here it may be necessary to map TypeName and ActualTypeParams.
    -- In the first release only the ActualTypeParams are mapped.

     'rule' MapGenericType (genericinst (TypeName, _), _)
	  GetDefiningId (TypeName -> DefTypeName)
	  DefTypeName'State -> generated

     'rule' MapGenericType (genericinst (TypeName, _), _)
	  IsImportedName (TypeName)
	  GetDefiningId (TypeName -> DefTypeName)
	  DefTypeName'Meaning -> type (TypeIndex)
	  TypeIndex'Flag <- unspecified
	  (|
	       DefTypeName'State -> marked
	  ||
	       GenerateImportedType (DefTypeName)
	  |)
	  
     'rule' MapGenericType (genericinst (TypeName, _), _) :
	  GetDefiningId (TypeName -> TypeNameDef)
	  TypeNameDef'State -> marked
	  TypeNameDef'Meaning -> type (TypeIndex)
	  (|
	       TypeIndex'Flag -> specified
	  ||
	       GenerateClassForwardSpecification (TypeName)
	       TypeIndex'Flag <- specified
	  |)

    'rule' MapGenericType( genericinst( TypeName, ActualTypeParams ), Mapping )
	GetDefiningId( TypeName -> TypeName1 )
        TypeName1'State <- marked	
        MapTypes( ActualTypeParams, implementation )
	GetIdMeaning( TypeName -> type( TypeIndex ) )
        TypeIndex'Type -> Type
        MapType( Type, Mapping ) -- here an object type is mapped

    -- An unconstrained type is always mapped.

     'rule' MapGenericType (unconstrained (_), _)
	
    -- AN constrained type is mapped if the constrained is mapped.

     'rule' MapGenericType (constrained (_, Constraint), Mapping)
	  MapType (composite (typename (Constraint)), Mapping)
	
-- MapTypes -----------------------------------------------------------------
	
'action' MapTypes( TYPEINDEXLIST, MAPPING )

    'rule' MapTypes( typeindexlist( TypeIndex, List ), Mapping )
        MapTypeIndex( TypeIndex, Mapping -> ActualType )
        MapTypes( List, Mapping )

    'rule' MapTypes( nil, _ )
	
-----------------------------------------------------------------------------
-- mapping routines for object types                                       --
-----------------------------------------------------------------------------

-- MapInterface -------------------------------------------------------------

'action' MapInterface (CLASSINTERFACE)

     'rule' MapInterface (interface (Super, _, ObjParams, ExportMeth, InstVar))
	  MapSuperType (Super)
	  MapParameterTypes (ObjParams, specification)
	  MapMethods (ExportMeth)
	  MapInstanceVariables (InstVar)
	
-- MapSuperType -------------------------------------------------------------

'action' MapSuperType( SUPERTYPE )

    'rule' MapSuperType( super( Super ) )
        Super'Meaning -> definingid( Id2 )
        Id2'State -> generated

    'rule' MapSuperType( super( Super ) )
        Super'Meaning -> definingid( Id2 )
        Id2'State -> marked
        GenerateClassForwardSpecification( Id2 )

    'rule' MapSuperType( super( Super ) )
        IsImportedName( Super )
        Super'Meaning -> definingid( Id2 )
        GenerateImportedType( Id2 )
        Id2'State <- generated

    'rule' MapSuperType( super( Super ) )
        Super'Meaning -> definingid( Id2 )
        Id2'Meaning -> type( TypeIndex )
        TypeIndex'Type -> composite( classtype( Id3, GenParams, Interface ) )
        Id2'Pos -> Pos
        GenerateClassSpecification( classspec( Pos, Id2, 
					       GenParams, Interface ) )

    'rule' MapSuperType( none )

-- MapMethods ---------------------------------------------------------------
	
'action' MapMethods( DECL )

    'rule' MapMethods( seq( _, Left, Right ) )
        MapMethods( Left )
        MapMethods( Right )

    'rule' MapMethods( nil( _ ) )

    'rule' MapMethods( methodspec( _, _, _, _, _, Params, Result ) )
        MapParameterTypes( Params, specification )
        MapTypeIndex( Result, specification -> ActualResultType )

    'rule' MapMethods( methodimpl( _, _, _, Params, Result, Locals, Block ) )
        MapParameterTypes( Params, implementation )
        MapTypeIndex( Result, implementation -> ActualResultType )
        MapLocalVariables( Locals )
        MapBlock( Block )

     'rule' MapMethods( initially( _, Params, Locals, Block ) )
        MapParameterTypes( Params, implementation )
        MapLocalVariables( Locals )
        MapBlock( Block )

    'rule' MapMethods( finally( _, Locals, Block ) )
        MapLocalVariables( Locals )
        MapBlock( Block )

-- MapInstanceVariables -----------------------------------------------------

'action' MapInstanceVariables( DECL )

    'rule' MapInstanceVariables( seq( _, Left, Right ) )
        MapInstanceVariables( Left )
        MapInstanceVariables( Right )

    'rule' MapInstanceVariables( nil( _ ) )

    'rule' MapInstanceVariables( instvar( _, _, TypeIndex ) )
        MapTypeIndex( TypeIndex, implementation -> ActualType )

-----------------------------------------------------------------------------
-- mapping routines for local variables                                    --
-----------------------------------------------------------------------------

-- MapLocalVariables --------------------------------------------------------

'action' MapLocalVariables( DECL )

    'rule' MapLocalVariables( seq( _, Left, Right ) )
        MapLocalVariables( Left )
        MapLocalVariables( Right )

    'rule' MapLocalVariables( nil( _ ) )

    'rule' MapLocalVariables( localvar( _, _, TypeIndex, _ ) )
        MapTypeIndex( TypeIndex, implementation -> ActualType )

-----------------------------------------------------------------------------
-- mapping routines for procedures                                         --
-----------------------------------------------------------------------------

-- MapProcedure -------------------------------------------------------------

'action' MapProcedure( DECL )

    'rule' MapProcedure( procspec( _, Name, _, _, _, _ ) )
        IsImportedName( Name )

    'rule' MapProcedure( procspec( _, _, _, _, Params, ResultType ) )
-- problem using specification :
-- if a type of a parameter is an named record which is not yet generated, 
-- a forward decl : struct name is generated. The parameter type is
-- generated as struct name and the cl compiler on Windows NT does not
-- accept this type! 
--        MapParameterTypes( Params, specification )
--        MapTypeIndex( ResultType, specification -> ActualResultType )
        MapParameterTypes( Params, implementation )
        MapTypeIndex( ResultType, implementation -> ActualResultType )

    'rule' MapProcedure( procimpl( _, Name, _, _, _, Block ) )
        IsImportedName( Name )
        MapBlock( Block )

    'rule' MapProcedure( procimpl( _, _, Params, ResultType, Locals, Block ) )
        MapParameterTypes( Params, implementation )
        MapTypeIndex( ResultType, implementation -> ActualResultType )
        MapLocalVariables( Locals )
        MapBlock( Block )

    'rule' MapProcedure( foreignproc( _, _, _, Params, ResultType ) )
        MapParameterTypes( Params, specification )
        MapTypeIndex( ResultType, specification -> ActualResultType )

-- MapBlock -----------------------------------------------------------------

'action' MapBlock( BLOCK )

    'rule' MapBlock( block( _, _, Body ) )
        MapStatements( Body )

-- MapStatements ------------------------------------------------------------

'action' MapStatements( STMT )

    'rule' MapStatements( seq( _, Left, Right ) )
        MapStatements( Left )
        MapStatements( Right )

    'rule' MapStatements( assign( _, _, Dest, Src ) )
        MapExpression( Dest )
        MapExpression( Src )

    'rule' MapStatements( stmtcall( _, Call ) )
        MapExpression( Call )

    'rule' MapStatements( returnvalue( _,  Value ) )
        MapExpression( Value )
 
    'rule' MapStatements( ifelse( _, Cond, Then, Else ) )
        MapExpression( Cond )
        MapStatements( Then )
        MapStatements( Else )

    'rule' MapStatements( select( _, Cond, Cases, Otherwise ) )
        MapExpression( Cond )
	MapCases( Cases )
        MapStatements( Otherwise )
				
    'rule' MapStatements( typeselect( _, _, Init, TypeCases, Otherwise ) )
        MapExpression( Init )
        MapTypeCases( TypeCases )
        MapStatements( Otherwise )
				
    'rule' MapStatements( loop( _, block( _, _, Body ) ) )
	MapStatements( Body )

    'rule' MapStatements( while( _, Cond, block( _, _, Body ) ) )
        MapExpression( Cond )
	MapStatements( Body )

    'rule' MapStatements( for( _, _, Range, Step, block( _, _, Body ) ) )
        MapExpression( Range )
        MapStep( Step )
	MapStatements( Body )

    'rule' MapStatements( try( _, Body, Handler, Otherwise ) )
        MapStatements( Body )
        MapHandler( Handler )
        MapStatements( Otherwise )

    'rule' MapStatements( delete( _, Object ) )
        MapExpression( Object )

    'rule' MapStatements( _ )

-- MapStep --------------------------------------------------------

'action' MapStep( STEP )

    'rule' MapStep( incr( Value ) )
        MapExpression( Value )

    'rule' MapStep( decr( Value ) )
        MapExpression( Value )

-- MapExpressions -------------------------------------------------

'action' MapExpression( EXPR )

    'rule' MapExpression( dyop( _, _, _, Left, Right ) )
        MapExpression( Left )
        MapExpression( Right )

    'rule' MapExpression( monop( _, _, _, Operand ) )
        MapExpression( Operand )

    'rule' MapExpression( adr( _, Desig ) )
        MapExpression( Desig )

    'rule' MapExpression( sizeof( _, TypeIndex ) )
        MapTypeIndex( TypeIndex, implementation -> Dummy )

    'rule' MapExpression( fieldsel( _, _, Tag, _ ) )
        MapExpression( Tag )

    'rule' MapExpression( unionsel( _, _, Tag, _ ) )
        MapExpression( Tag )

    'rule' MapExpression( methodpointer( _, _, Object, _ ) )
        MapExpression( Object )

    'rule' MapExpression( arraysubscr( _, _, Desig, Index ) )
        MapExpression( Desig )
        MapExpression( Index )

     'rule' MapExpression( stringsubscr( _, Desig, Index ) )
        MapExpression( Desig )
        MapExpression( Index )

   'rule' MapExpression( substring( _, String, Range ) )
        MapExpression( String )
        MapExpression( Range )

    'rule' MapExpression( range( _, Lwb, Upb ) )
        MapExpression( Lwb )
        MapExpression( Upb )

    'rule' MapExpression( deref( _, _, Ref ) )
        MapExpression( Ref )

    'rule' MapExpression( call( _, _, _, Receiver, AParams ) )
        MapReceiver( Receiver )
        MapActualParameter( AParams )

    'rule' MapExpression( _ )

-- MapActualParameter ----------------------------------------------------

'action' MapActualParameter( APARAMLIST )

    'rule' MapActualParameter( aparamlist( in( Param ), List ) )
        MapExpression( Param )
        MapActualParameter( List )

    'rule' MapActualParameter( aparamlist( out( Param ), List ) )
        MapExpression( Param )
        MapActualParameter( List )

    'rule' MapActualParameter( aparamlist( inout( Param ), List ) )
        MapExpression( Param )
        MapActualParameter( List )

    'rule' MapActualParameter( nil )

-- MapReceiver ----------------------------------------------------

'action' MapReceiver (RECEIVER)
	  
     'rule' MapReceiver (method (Object, _)) :
	  MapExpression (Object)
	  
     'rule' MapReceiver (new (TypeIndex))
	  FollowNameChainIndex 
             (TypeIndex -> 
	      composite (classtype (ClassId, GenParams, 
				    interface (_, _, ObjParams, _, _))))
	  (|
	       ClassId'State -> generated
	  ||
	       MapCompositeType (typename (ClassId), specification)
	       MapParameterTypes (ObjParams, specification)
	       GenerateNEWSpecification (ClassId, GenParams, ObjParams)
	  |)
	  
     'rule' MapReceiver (procexpr (Expr)) :
	  MapExpression (Expr)
	  
     'rule' MapReceiver (methodexpr (Expr)) :
	  MapExpression (Expr)
	  
     'rule' MapReceiver (_)

-- Cases ----------------------------------------------------------

'action' MapCases( CASE )

    'rule' MapCases( seq( Left, Right ) )
        MapCases( Left )
        MapCases( Right )

    'rule' MapCases( case( _, _, Body ) )
        MapStatements( Body )

    'rule' MapCases( nil )

-- MapTypeCases ------------------------------------------------------

'action' MapTypeCases( TYPECASE )

    'rule' MapTypeCases( seq( Left, Right ) )
        MapTypeCases( Left )
        MapTypeCases( Right )

    'rule' MapTypeCases( typecase( _, TypeId, Body ) )
        MapType( composite( typename( TypeId ) ), specification )
        MapStatements( Body )

    'rule' MapTypeCases( nil )

-- MapHandler ------------------------------------------------------

'action' MapHandler( HANDLER )

    'rule' MapHandler( seq( Left, Right ) )
        MapHandler( Left )
        MapHandler( Right )

    'rule' MapHandler( handler( _, _, _, Body ) )
        MapStatements( Body )

    'rule' MapHandler( nil )

-----------------------------------------------------------------------------
-- mapping routines for nonobject types                                    --
-----------------------------------------------------------------------------

-- MapType ------------------------------------------------------------------

'action' MapType( TYPE, MAPPING )

    'rule' MapType( simple( SimpleType ), _ )

    'rule' MapType( generic( GenericType ), Mapping )
        MapGenericType( GenericType, Mapping )

    'rule' MapType( composite( CompositeType ), Mapping )
	 MapCompositeType( CompositeType, Mapping )

-- MapCompositeType ---------------------------------------------------------

'action' MapCompositeType( COMPOSITETYPE, MAPPING )

     'rule' MapCompositeType (typename (Id), _) :
	  GetIdMeaning (Id -> foreigntype (_))
	  
    -- type was generated 

    'rule' MapCompositeType( typename( Id ), Mapping )
        GetDefiningId( Id -> Id2 )
        Id2'State -> generated
	
    -- inside the same object

     'rule' MapCompositeType (typename (Id), _)
	  GetDefiningId (Id -> Id2)
	  Id2'Meaning -> type (TypeIndex)
	  TypeIndex'Type -> composite (Class:classtype (Name, _, _))
	  (|
	       IsImportedName (Id2)
	  ||
	       Id2'State -> marked
	  |)
	  (|
	       TypeIndex'Flag -> specified
	  ||
	       GenerateClassForwardSpecification (Name)
	       TypeIndex'Flag <- specified
	  |)

    -- using of an object type for a field or instance variable

     'rule' MapCompositeType (typename (Id), _)
	  GetIdMeaning (Id -> type (TypeIndex))
	  TypeIndex'Type -> composite (Class:classtype (Name, GenParams,
							Interface))
	  Name'Pos -> Pos
	  GenerateClassSpecification (classspec (Pos, Name, 
						 GenParams, Interface))
     
    -- special rule for instance variable of any generic object type

     'rule' MapCompositeType (typename (Id), Mapping)
	  GetIdMeaning (Id -> type (TypeIndex))
	  TypeIndex'Type -> generic (GenericType)
	  MapGenericType (GenericType, Mapping)

    'rule' MapCompositeType( typename( Id ), Mapping )
        GetDefiningId( Id -> Id2 )
	Id2'Meaning -> type( TypeIndex )
	TypeIndex'Type -> simple( SimpleType )
        Id'Pos -> Pos
        GenerateTypeDeclaration( type( Pos, Id, TypeIndex ) )
        Id2'State <- generated

    -- forward declaration was generated before
    -- used for direct and indirect recusion (record or union)

     'rule' MapCompositeType (typename (Id), specification)
	  GetIdMeaning (Id -> type (TypeIndex))
	  TypeIndex'Flag -> specified

    -- record or union type without forward declaration
    -- direct and indirect recursion

    'rule' MapCompositeType( typename( Id ), specification )
        GetDefiningId( Id -> Id2 )
	Id2'Meaning -> type( TypeIndex )
	TypeIndex'Type -> composite( ActualCompositeType )
	GenerateForwardDeclaration( Id2, TypeIndex )
	TypeIndex'Flag <- specified

     -- unmapped type must be generated, State is changed to generated

    'rule' MapCompositeType( typename( Id ), implementation )
        GetDefiningId( Id -> Id2 )
        Id'Pos -> Pos
        Id2'Meaning -> type( TypeIndex )
        GenerateTypeDeclaration( type( Pos, Id, TypeIndex ) )
        Id2'State <- generated

--    'rule' MapCompositeType( unnamed( TypeIndex ), Mapping )
        -- unnamed is mapped

    -- An enumeration type is mapped by default, because the Enumerators
    -- are type independent
	
    'rule' MapCompositeType( enum( Enumerators ), Mapping )

    -- A record type is mapped if all fields are mapped.
	
    'rule' MapCompositeType( record( Fields ), Mapping )
        MapFields( Fields, Mapping )

    -- A union type is mapped if all fields are mapped.
	
    'rule' MapCompositeType( union( Fields ), Mapping )
        MapFields( Fields, Mapping )

    -- A array type is mapped if the base type is mapped.
	
    'rule' MapCompositeType( array( Range, BaseType ), Mapping )
        MapTypeIndex( BaseType, Mapping -> ActualBaseType )

    -- A open array type is mapped if the base type is mapped.
	
    'rule' MapCompositeType( openarray( BaseType ), Mapping )
        MapTypeIndex( BaseType, Mapping -> ActualBaseType )
	
     -- A ref type is mapped if the base type is mapped.
	
    'rule' MapCompositeType( ref( BaseType ), Mapping )
        MapTypeIndex( BaseType, specification -> ActualBaseType )

    -- A method type is mapped if all parameter types and the result
    -- type are mapped.

    'rule' MapCompositeType( method( Params, ResultType ), Mapping )
        MapParameterTypes( Params, specification )
        MapTypeIndex( ResultType, specification -> ActualResultType )
	
    -- A procedure type is mapped if all parameter types and the result
    -- type are mapped.

    'rule' MapCompositeType( procedure( Params, ResultType ), Mapping )
        MapParameterTypes( Params, specification )
        MapTypeIndex( ResultType, specification -> ActualResultType )
	
    'rule' MapCompositeType( classtype( Name, GenParams, Interface ), Mapping )
	Name'Pos -> Pos
	GenerateClassSpecification( classspec( Pos, Name, 
					       GenParams, Interface ) )

-- MapFields ----------------------------------------------------------------

'action' MapFields( FIELD, MAPPING )

    'rule' MapFields( seq( Left, Right ), Mapping )
        MapFields( Left, Mapping )
        MapFields( Right, Mapping )

    'rule' MapFields( field( Pos, Name, TypeIndex ), Mapping )
        MapTypeIndex( TypeIndex, Mapping -> ActualType )

    'rule' MapFields( nil, Mapping )

-- MapParameterTypes --------------------------------------------------------

'action' MapParameterTypes( FPARAMLIST, MAPPING )

    'rule' MapParameterTypes( fparamlist( Param , List ), Mapping )
        MapParameterType( Param, Mapping )
        MapParameterTypes( List, Mapping )

    'rule' MapParameterTypes( ellipsis, Mapping )

    'rule' MapParameterTypes( nil, Mapping )

-- MapParameterType ---------------------------------------------------------

'action' MapParameterType( FPARAM, MAPPING )

    'rule' MapParameterType( fparam( Pos, Mode, IdentID, TypeIndex ), Mapping )
        MapTypeIndex( TypeIndex, Mapping -> ActualType )

    'rule' MapParameterType( unconstrained( Pos, Name ), Mapping )

    'rule' MapParameterType( constrained( Pos, Name, Constraint ), Mapping )
        -- not yet implemented

-- GenerateImportedType -------------------------------------------------------

'action' GenerateImportedType( ID )

     'rule' GenerateImportedType (TypeName)
	  TypeName'Meaning -> type (TypeIndex)
	  (|
	       TypeIndex'Type -> composite (classtype (_, _, _))
	       GenerateClassForwardSpecification (TypeName)
	  ||
	       TypeName'Pos -> Pos
	       GenerateTypeDeclaration (type (Pos, TypeName, TypeIndex))
	  |)
	  TypeName'State <- generated

'end'

